package com.elitesland.tw.tw5.server.prd.taskpro.model.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 通用任务成员关系
 *
 * @author duwh
 * @date 2024-02-01
 */
@Entity
@Table(name = "pms_task_member_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_member_ref", comment = "通用任务成员关系")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskMemberRefDO extends BaseModel implements Serializable  {

    @ApiModelProperty("任务主键")
    @Column()
    private Long taskId;
    /** 关联主键类型 USER、RELATED */
    @Comment("关联主键类型 USER、RELATED")
    @Column()
    private String type;
    /** 关联类型 FOLLOW:关注人 PART:参与人  */
    @Comment("关联类型 FOLLOW:关注人 PART:参与人 ")
    @Column()
    private String objType;
    /** 关联主键 */
    @Comment("关联主键")
    @Column()
    private Long objId;

    public void copy(TaskMemberRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
