package com.elitesland.tw.tw5.server.prd.taskpro.model.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 任务场景类别关系表
 *
 * @author duwh
 * @date 2024-01-31
 */
@Entity
@Table(name = "pms_task_scene_category_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_scene_category_ref", comment = "任务场景类别关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskSceneCategoryRefDO extends BaseModel implements Serializable  {
    /** 任务类别主键 pms_task_scene.id */
    @Comment("任务类别主键 pms_task_scene.id")
    @Column()
    private Long sceneId;
    /** 任务类别主键 pms_task_category.id */
    @Comment("任务类别主键 pms_task_category.id")
    @Column()
    private Long categoryId;

    public void copy(TaskSceneCategoryRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
