package com.elitesland.tw.tw5.server.prd.taskpro.repo.dao;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.QStateFlowDO;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskMemberRefTypeEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProGroupEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProShowScopeEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.QTaskMemberRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.QTaskProDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskProDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskProRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Repository
@RequiredArgsConstructor
public class TaskProDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TaskProRepo repo;
    private final QTaskProDO qdo = QTaskProDO.taskProDO;
    private final QTaskMemberRefDO qTaskMemberRefDO = QTaskMemberRefDO.taskMemberRefDO;
    private final QProRelatedPartiesDO qProRelatedPartiesDO = QProRelatedPartiesDO.proRelatedPartiesDO;
    private final QStateFlowDO qStateFlowDO = QStateFlowDO.stateFlowDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TaskProVO> getJpaQuerySelect() {
        return jpaQueryFactory.selectDistinct(Projections.bean(TaskProVO.class,

            // 相对方
            // 负责人
            qProRelatedPartiesDO.name.as("directorRelatedPartiesName"),

            // 状态流
            qStateFlowDO.state.as("stateFlowState"),
            qStateFlowDO.name.as("stateFlowName"),
            // 进度百分比
            qStateFlowDO.progressPercentage,

            // 任务
            qdo.id,
            //qdo.remark,
            qdo.createUserId, qdo.creator, qdo.createTime,
            qdo.createRelatedPartiesId,
            qdo.wbsId,
            qdo.wbsName,
            qdo.createRelatedPartiesName,
            //qdo.modifyUserId,
            //qdo.updater,
            //qdo.modifyTime,
            // 父主键
            qdo.parentId,
            // 事由类型
            qdo.reasonType,
            // 事由id
            qdo.reasonId,
            // 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]
            qdo.showScope,
            // 任务编号
            qdo.taskNo,
            // 任务名称
            qdo.taskName,
            // 任务状态
            qdo.taskStatus, qdo.stateFlowId,
            // 任务类别
            qdo.taskCategoryId,
            // 任务类别名称
            qdo.taskCategoryName,
            // 优先级 UDC[PMS:TASK_PRO:PRIORITY]
            qdo.priority,
            // 发包userId
            qdo.disterUserId,
            // 负责人userId
            qdo.directorUserId,
            // 负责人相关方id pro_related_parties.id
            qdo.directorRelatedPartiesId,
            // 费用承担bu_id
            qdo.expenseBuId,
            // 接收资源bu_id
            qdo.receiverBuId,
            // 接收userId
            qdo.receiverUserId,
            // 资源来源类型
            qdo.resSourceType,
            // 预估工时
            qdo.predictWorkHours,
            // 实际工时
            qdo.actualWorkHours,
            // 完工百分比
            qdo.finishRate,
            // 计划开始日期
            qdo.planStartDate,
            // 计划结束日期
            qdo.planEndDate,
            // 实际开始日期
            qdo.actualStartDate,
            // 实际结束日期
            qdo.actualEndDate,
            // 任务类型
            qdo.taskType,
            // 任务包关闭时间
            qdo.closedTime,
            // 发包日期
            qdo.distDate,
            // 系统自动建包
            qdo.autoCreateFlag,
            // 描述内容
            qdo.content,
            // 排序
            qdo.sort,
            // 是否置顶
            qdo.topFlag,
            // 置顶操作时间
            qdo.topModifyTime,
            // 拓展字段1
            qdo.ext1,
            // 拓展字段2
            qdo.ext2,
            // 拓展字段3
            qdo.ext3,
            // 拓展字段4
            qdo.ext4,
            // 拓展字段5
            qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TaskProVO> getJpaQueryWhere(TaskProQuery query) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.leftJoin(qProRelatedPartiesDO).on(qdo.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id));
        jpaQuery.leftJoin(qStateFlowDO).on(qdo.stateFlowId.eq(qStateFlowDO.id));
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TaskProQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.countDistinct()).from(qdo).leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        ;
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TaskProQuery query) {
        List<Predicate> list = new ArrayList<>();
        String searchType = query.getSearchType();
        if (!ObjectUtils.isEmpty(searchType)) {
            if (searchType.equals(TaskProGroupEnum.ALL_ALL.getCode())) {
                BooleanExpression expression = qdo.showScope.eq(TaskProShowScopeEnum.EMPLOYEE.getCode());
                if (!ObjectUtils.isEmpty(query.getRelatedIdList())) {
                    expression = expression.and(qTaskMemberRefDO.deleteFlag.eq(0));
                    expression = expression.and(qTaskMemberRefDO.type.eq(TaskMemberRefTypeEnum.RELATED.getCode()).and(qTaskMemberRefDO.objId.in(query.getRelatedIdList())));
                    expression = expression.or(qdo.directorRelatedPartiesId.in(query.getRelatedIdList()));
                    expression = expression.or(qdo.createRelatedPartiesId.in(query.getRelatedIdList()));
                }
                expression = expression.or(qdo.showScope.eq(TaskProShowScopeEnum.ALL.getCode()));
                expression = expression.or(qdo.showScope.isNull());
                list.add(expression);
            }
        }
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getWbsId())) {
            list.add(qdo.wbsId.eq(query.getWbsId()));
        }
        /** 父主键 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getKeyword())) {
            list.add(qdo.taskNo.like("%" + query.getKeyword() + "%").or(qdo.taskName.like("%" + query.getKeyword() + "%")));
        }
        if (!ObjectUtils.isEmpty(query.getParentNullFlag())) {
            if (query.getParentNullFlag()) {
                list.add(qdo.parentId.isNull());
            }
        }
        if (!ObjectUtils.isEmpty(query.getIdList())) {
            list.add(qdo.id.in(query.getIdList()));
        }
        /** 事由类型 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }

        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonIdList())) {
            list.add(qdo.reasonId.in(query.getReasonIdList()));
        }
        /** 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE] 精确 */
        if (!ObjectUtils.isEmpty(query.getShowScope())) {
            list.add(qdo.showScope.eq(query.getShowScope()));
        }
        /** 任务编号 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskNo())) {
            list.add(qdo.taskNo.eq(query.getTaskNo()));
        }
        /** 任务名称 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskName())) {
            list.add(qdo.taskName.eq(query.getTaskName()));
        }
        /** 任务状态 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskStatus())) {
            list.add(qdo.taskStatus.eq(query.getTaskStatus()));
        }
        /** 任务类别 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskCategoryId())) {
            list.add(qdo.taskCategoryId.eq(query.getTaskCategoryId()));
        }
        /** 任务类别名称 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskCategoryName())) {
            list.add(qdo.taskCategoryName.eq(query.getTaskCategoryName()));
        }
        if (!ObjectUtils.isEmpty(query.getStateFlowId())) {
            list.add(qdo.stateFlowId.eq(query.getStateFlowId()));
        }
        if (CollUtil.isNotEmpty(query.getStateFlowIdList())) {
            list.add(qdo.stateFlowId.in(query.getStateFlowIdList()));
        }
        if (!ObjectUtils.isEmpty(query.getStateFlowName())) {
            list.add(qdo.stateFlowName.eq(query.getStateFlowName()));
        }
        /** 优先级 UDC[PMS:TASK_PRO:PRIORITY] 精确 */
        if (!ObjectUtils.isEmpty(query.getPriority())) {
            list.add(qdo.priority.eq(query.getPriority()));
        }
        /** 发包userId 精确 */
        if (!ObjectUtils.isEmpty(query.getDisterUserId())) {
            list.add(qdo.disterUserId.eq(query.getDisterUserId()));
        }
        /** 负责人userId 精确 */
        if (!ObjectUtils.isEmpty(query.getDirectorUserId())) {
            list.add(qdo.directorUserId.eq(query.getDirectorUserId()));
        }
        /** 负责人userIdList 精确 */
        if (!ObjectUtils.isEmpty(query.getDirectorUserIdList())) {
            list.add(qdo.directorUserId.in(query.getDirectorUserIdList()));
        }
        /** 负责人相关方id pro_related_parties.id 精确 */
        if (!ObjectUtils.isEmpty(query.getDirectorRelatedPartiesId())) {
            list.add(qdo.directorRelatedPartiesId.eq(query.getDirectorRelatedPartiesId()));
        }
        if (!ObjectUtils.isEmpty(query.getDirectorRelatedPartiesIdList())) {
            list.add(qdo.directorRelatedPartiesId.in(query.getDirectorRelatedPartiesIdList()));
        }
        /** 费用承担bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** 接收资源bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiverBuId())) {
            list.add(qdo.receiverBuId.eq(query.getReceiverBuId()));
        }
        /** 接收userId 精确 */
        if (!ObjectUtils.isEmpty(query.getReceiverUserId())) {
            list.add(qdo.receiverUserId.eq(query.getReceiverUserId()));
        }
        /** 资源来源类型 精确 */
        if (!ObjectUtils.isEmpty(query.getResSourceType())) {
            list.add(qdo.resSourceType.eq(query.getResSourceType()));
        }
        /** 预估工时 精确 */
        if (!ObjectUtils.isEmpty(query.getPredictWorkHours())) {
            list.add(qdo.predictWorkHours.eq(query.getPredictWorkHours()));
        }
        /** 实际工时 精确 */
        if (!ObjectUtils.isEmpty(query.getActualWorkHours())) {
            list.add(qdo.actualWorkHours.eq(query.getActualWorkHours()));
        }
        /** 完工百分比 精确 */
        if (!ObjectUtils.isEmpty(query.getFinishRate())) {
            list.add(qdo.finishRate.eq(query.getFinishRate()));
        }
        /** 计划开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanStartDate())) {
            list.add(qdo.planStartDate.eq(query.getPlanStartDate()));
        }
        /** 计划结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getPlanEndDate())) {
            list.add(qdo.planEndDate.eq(query.getPlanEndDate()));
        }
        /** 实际开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getActualStartDate())) {
            list.add(qdo.actualStartDate.eq(query.getActualStartDate()));
        }
        /** 实际结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getActualEndDate())) {
            list.add(qdo.actualEndDate.eq(query.getActualEndDate()));
        }
        /** 任务类型 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskType())) {
            list.add(qdo.taskType.eq(query.getTaskType()));
        }
        /** 任务包关闭时间 精确 */
        if (!ObjectUtils.isEmpty(query.getClosedTime())) {
            list.add(qdo.closedTime.eq(query.getClosedTime()));
        }
        /** 发包日期 精确 */
        if (!ObjectUtils.isEmpty(query.getDistDate())) {
            list.add(qdo.distDate.eq(query.getDistDate()));
        }
        /** 系统自动建包 精确 */
        if (!ObjectUtils.isEmpty(query.getAutoCreateFlag())) {
            list.add(qdo.autoCreateFlag.eq(query.getAutoCreateFlag()));
        }
        /** 描述内容 精确 */
        if (!ObjectUtils.isEmpty(query.getContent())) {
            list.add(qdo.content.eq(query.getContent()));
        }
        /** 排序 精确 */
        if (!ObjectUtils.isEmpty(query.getSort())) {
            list.add(qdo.sort.eq(query.getSort()));
        }
        /** 是否置顶 精确 */
        if (!ObjectUtils.isEmpty(query.getTopFlag())) {
            list.add(qdo.topFlag.eq(query.getTopFlag()));
        }
        /** 置顶操作时间 精确 */
        if (!ObjectUtils.isEmpty(query.getTopModifyTime())) {
            list.add(qdo.topModifyTime.eq(query.getTopModifyTime()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateRelatedPartiesId())) {
            list.add(qdo.createRelatedPartiesId.eq(query.getCreateRelatedPartiesId()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateRelatedPartiesName())) {
            list.add(qdo.createRelatedPartiesName.like(SqlUtil.toSqlLikeString(query.getCreateRelatedPartiesName())));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        if (!ObjectUtils.isEmpty(query.getLoginUserId())) {
            list.add(qdo.createUserId.eq(query.getLoginUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TaskProVO queryByKey(Long id) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.leftJoin(qProRelatedPartiesDO).on(qdo.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id));
        jpaQuery.leftJoin(qStateFlowDO).on(qdo.stateFlowId.eq(qStateFlowDO.id));
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TaskProVO> queryListDynamic(TaskProQuery query) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TaskProVO> queryPaging(TaskProQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TaskProVO> jpaQuery = getJpaQueryWhere(query);
        List<TaskProVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetch();
        return PagingVO.<TaskProVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TaskProDO save(TaskProDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TaskProDO> saveAll(List<TaskProDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TaskProPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo).where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 父主键
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 事由类型
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]
        if (payload.getShowScope() != null) {
            update.set(qdo.showScope, payload.getShowScope());
        }
        // 任务编号
        if (payload.getTaskNo() != null) {
            update.set(qdo.taskNo, payload.getTaskNo());
        }
        // 任务名称
        if (payload.getTaskName() != null) {
            update.set(qdo.taskName, payload.getTaskName());
        }
        // 任务状态
        if (payload.getTaskStatus() != null) {
            update.set(qdo.taskStatus, payload.getTaskStatus());
        }
        // 任务类别
        if (payload.getTaskCategoryId() != null) {
            update.set(qdo.taskCategoryId, payload.getTaskCategoryId());
        }
        // 任务类别名称
        if (payload.getTaskCategoryName() != null) {
            update.set(qdo.taskCategoryName, payload.getTaskCategoryName());
        }
        // 优先级 UDC[PMS:TASK_PRO:PRIORITY]
        if (payload.getPriority() != null) {
            update.set(qdo.priority, payload.getPriority());
        }
        // 发包userId
        if (payload.getDisterUserId() != null) {
            update.set(qdo.disterUserId, payload.getDisterUserId());
        }
        // 负责人userId
        if (payload.getDirectorUserId() != null) {
            update.set(qdo.directorUserId, payload.getDirectorUserId());
        }
        // 负责人相关方id pro_related_parties.id
        if (payload.getDirectorRelatedPartiesId() != null) {
            update.set(qdo.directorRelatedPartiesId, payload.getDirectorRelatedPartiesId());
        }
        // 费用承担bu_id
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 接收资源bu_id
        if (payload.getReceiverBuId() != null) {
            update.set(qdo.receiverBuId, payload.getReceiverBuId());
        }
        // 接收userId
        if (payload.getReceiverUserId() != null) {
            update.set(qdo.receiverUserId, payload.getReceiverUserId());
        }
        // 资源来源类型
        if (payload.getResSourceType() != null) {
            update.set(qdo.resSourceType, payload.getResSourceType());
        }
        // 预估工时
        if (payload.getPredictWorkHours() != null) {
            update.set(qdo.predictWorkHours, payload.getPredictWorkHours());
        }
        // 实际工时
        if (payload.getActualWorkHours() != null) {
            update.set(qdo.actualWorkHours, payload.getActualWorkHours());
        }
        // 完工百分比
        if (payload.getFinishRate() != null) {
            update.set(qdo.finishRate, payload.getFinishRate());
        }
        // 计划开始日期
        if (payload.getPlanStartDate() != null) {
            update.set(qdo.planStartDate, payload.getPlanStartDate());
        }
        // 计划结束日期
        if (payload.getPlanEndDate() != null) {
            update.set(qdo.planEndDate, payload.getPlanEndDate());
        }
        // 实际开始日期
        if (payload.getActualStartDate() != null) {
            update.set(qdo.actualStartDate, payload.getActualStartDate());
        }
        // 实际结束日期
        if (payload.getActualEndDate() != null) {
            update.set(qdo.actualEndDate, payload.getActualEndDate());
        }
        // 任务类型
        if (payload.getTaskType() != null) {
            update.set(qdo.taskType, payload.getTaskType());
        }
        // 任务包关闭时间
        if (payload.getClosedTime() != null) {
            update.set(qdo.closedTime, payload.getClosedTime());
        }
        // 发包日期
        if (payload.getDistDate() != null) {
            update.set(qdo.distDate, payload.getDistDate());
        }
        // 系统自动建包
        if (payload.getAutoCreateFlag() != null) {
            update.set(qdo.autoCreateFlag, payload.getAutoCreateFlag());
        }
        // 状态流id
        if (payload.getStateFlowId() != null) {
            update.set(qdo.stateFlowId, payload.getStateFlowId());
        }
        // 描述内容
        if (payload.getContent() != null) {
            update.set(qdo.content, payload.getContent());
        }
        // 排序
        if (payload.getSort() != null) {
            update.set(qdo.sort, payload.getSort());
        }
        // 是否置顶
        if (payload.getTopFlag() != null) {
            update.set(qdo.topFlag, payload.getTopFlag());
        }
        // 置顶操作时间
        if (payload.getTopModifyTime() != null) {
            update.set(qdo.topModifyTime, payload.getTopModifyTime());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 父主键
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 事由类型
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]
            if (nullFields.contains("showScope")) {
                update.setNull(qdo.showScope);
            }
            // 任务编号
            if (nullFields.contains("taskNo")) {
                update.setNull(qdo.taskNo);
            }
            // 任务名称
            if (nullFields.contains("taskName")) {
                update.setNull(qdo.taskName);
            }
            // 任务状态
            if (nullFields.contains("taskStatus")) {
                update.setNull(qdo.taskStatus);
            }
            // 任务类别
            if (nullFields.contains("taskCategoryId")) {
                update.setNull(qdo.taskCategoryId);
            }
            // 任务类别名称
            if (nullFields.contains("taskCategoryName")) {
                update.setNull(qdo.taskCategoryName);
            }
            // 优先级 UDC[PMS:TASK_PRO:PRIORITY]
            if (nullFields.contains("priority")) {
                update.setNull(qdo.priority);
            }
            // 发包userId
            if (nullFields.contains("disterUserId")) {
                update.setNull(qdo.disterUserId);
            }
            // 负责人userId
            if (nullFields.contains("directorUserId")) {
                update.setNull(qdo.directorUserId);
            }
            // 负责人相关方id pro_related_parties.id
            if (nullFields.contains("directorRelatedPartiesId")) {
                update.setNull(qdo.directorRelatedPartiesId);
            }
            // 费用承担bu_id
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // 接收资源bu_id
            if (nullFields.contains("receiverBuId")) {
                update.setNull(qdo.receiverBuId);
            }
            // 接收userId
            if (nullFields.contains("receiverUserId")) {
                update.setNull(qdo.receiverUserId);
            }
            // 资源来源类型
            if (nullFields.contains("resSourceType")) {
                update.setNull(qdo.resSourceType);
            }
            // 预估工时
            if (nullFields.contains("predictWorkHours")) {
                update.setNull(qdo.predictWorkHours);
            }
            // 实际工时
            if (nullFields.contains("actualWorkHours")) {
                update.setNull(qdo.actualWorkHours);
            }
            // 完工百分比
            if (nullFields.contains("finishRate")) {
                update.setNull(qdo.finishRate);
            }
            // 计划开始日期
            if (nullFields.contains("planStartDate")) {
                update.setNull(qdo.planStartDate);
            }
            // 计划结束日期
            if (nullFields.contains("planEndDate")) {
                update.setNull(qdo.planEndDate);
            }
            // 实际开始日期
            if (nullFields.contains("actualStartDate")) {
                update.setNull(qdo.actualStartDate);
            }
            // 实际结束日期
            if (nullFields.contains("actualEndDate")) {
                update.setNull(qdo.actualEndDate);
            }
            // 任务类型
            if (nullFields.contains("taskType")) {
                update.setNull(qdo.taskType);
            }
            // 任务包关闭时间
            if (nullFields.contains("closedTime")) {
                update.setNull(qdo.closedTime);
            }
            // 发包日期
            if (nullFields.contains("distDate")) {
                update.setNull(qdo.distDate);
            }
            // 系统自动建包
            if (nullFields.contains("autoCreateFlag")) {
                update.setNull(qdo.autoCreateFlag);
            }
            // 描述内容
            if (nullFields.contains("content")) {
                update.setNull(qdo.content);
            }
            // 排序
            if (nullFields.contains("sort")) {
                update.setNull(qdo.sort);
            }
            // 是否置顶
            if (nullFields.contains("topFlag")) {
                update.setNull(qdo.topFlag);
            }
            // 置顶操作时间
            if (nullFields.contains("topModifyTime")) {
                update.setNull(qdo.topModifyTime);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo).set(qdo.deleteFlag, 1).where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * count left联接成员ref
     *
     * @param objId 相对方主键
     * @param type  类型
     * @return long
     */
    public long countLeftJoinMemberRef(Long objId, String type) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.countDistinct()).from(qdo).leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.where(qTaskMemberRefDO.deleteFlag.eq(0), qTaskMemberRefDO.objId.eq(objId), qTaskMemberRefDO.objType.eq(type), qTaskMemberRefDO.type.eq(TaskMemberRefTypeEnum.RELATED.getCode()));
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 关联任务成员 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long countLeftJoinMemberRef(TaskProQuery query, Long objId, String type) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.countDistinct()).from(qdo).leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.where(qTaskMemberRefDO.deleteFlag.eq(0), qTaskMemberRefDO.objId.eq(objId), qTaskMemberRefDO.objType.eq(type), qTaskMemberRefDO.type.eq(TaskMemberRefTypeEnum.RELATED.getCode()));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 分页查询 关联任务成员
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TaskProVO> queryPagingLeftJoinMemberRef(TaskProQuery query, Long objId, String type) {
        long total = countLeftJoinMemberRef(query, objId, type);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<TaskProVO> jpaQuery = getJpaQueryWhereLeftJoinMemberRef(query, objId, type);
        List<TaskProVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetch();
        return PagingVO.<TaskProVO>builder().records(result).total(total).build();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TaskProVO> queryListDynamicLeftJoinMemberRef(TaskProQuery query, Long objId, String type) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQueryWhereLeftJoinMemberRef(query, objId, type);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件 关联任务成员
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TaskProVO> getJpaQueryWhereLeftJoinMemberRef(TaskProQuery query, Long objId, String type) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.where(qTaskMemberRefDO.deleteFlag.eq(0), qTaskMemberRefDO.objId.eq(objId), qTaskMemberRefDO.objType.eq(type), qTaskMemberRefDO.type.eq(TaskMemberRefTypeEnum.RELATED.getCode()));
        jpaQuery.leftJoin(qProRelatedPartiesDO).on(qdo.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id));
        jpaQuery.leftJoin(qStateFlowDO).on(qdo.stateFlowId.eq(qStateFlowDO.id));
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 子任务父任务解绑
     *
     * @param subTaskId    子任务id
     * @param parentTaskId 父任务id
     * @return long
     */
    public long unbindRef(Long subTaskId, Long parentTaskId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo).setNull(qdo.parentId).where(qdo.id.eq(subTaskId).and(qdo.parentId.eq(parentTaskId)));
        return update.execute();
    }

    public List<TaskProVO> queryListByTaskIdsAndHaveWbsId(List<Long> taskIds) {
        JPAQuery<TaskProVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.leftJoin(qTaskMemberRefDO).on(qTaskMemberRefDO.taskId.eq(qdo.id));
        jpaQuery.leftJoin(qProRelatedPartiesDO).on(qdo.directorRelatedPartiesId.eq(qProRelatedPartiesDO.id));
        jpaQuery.leftJoin(qStateFlowDO).on(qdo.stateFlowId.eq(qStateFlowDO.id));
        jpaQuery.where(
            qdo.wbsId.isNotNull(),
            qdo.id.in(taskIds)
        );
        return jpaQuery.fetch();
    }
}

