package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskSceneConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskSceneDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskScenePayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskSceneRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskSceneDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 任务场景
 *
 * @author duwh
 * @date 2024-01-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskSceneServiceImpl extends BaseServiceImpl implements TaskSceneService {

    private final TaskSceneRepo taskSceneRepo;
    private final TaskSceneDAO taskSceneDAO;

    @Autowired
    @Lazy
    private TaskInfoService taskInfoService;
    @Autowired
    @Lazy
    private  TaskCategoryService taskCategoryService;
//    private final TaskSceneCategoryRefService taskSceneCategoryRefService;
//    private final TaskCategoryService taskCategoryService;

    @Override
    public PagingVO<TaskSceneVO> queryPaging(TaskSceneQuery query) {
        PagingVO<TaskSceneVO> pagingVO = taskSceneDAO.queryPaging(query);
        if(!CollectionUtils.isEmpty(pagingVO.getRecords())){
            List<Long> categoryIdList = pagingVO.getRecords().stream().filter(p -> p.getCategoryId() != null).map(s -> s.getCategoryId()).collect(Collectors.toList());
            if(!CollectionUtils.isEmpty(categoryIdList)){
                TaskCategoryQuery categoryQuery = new TaskCategoryQuery();
                categoryQuery.setIdList(categoryIdList);
                List<TaskCategoryVO> taskCategoryVOS = taskCategoryService.queryListDynamic(categoryQuery);
                Map<Long, List<TaskCategoryVO>> categoryMap = taskCategoryVOS.stream().collect(Collectors.groupingBy(TaskCategoryVO::getId));

                pagingVO.getRecords().forEach(vo -> {
                    if(vo.getCategoryId()!=null && categoryMap.containsKey(vo.getCategoryId())){
                        TaskCategoryVO taskCategoryVO = categoryMap.get(vo.getCategoryId()).get(0);
                        vo.setCategoryName(taskCategoryVO.getName());
                    }
                });
            }

            pagingVO.getRecords().forEach(vo -> {
                // 翻译
                translate(vo);
            });
        }

        return pagingVO;
    }

    @Override
    public List<TaskSceneVO> queryListDynamic(TaskSceneQuery query) {
        return taskSceneDAO.queryListDynamic(query);
    }

    @Override
    public TaskSceneVO queryByKey(Long key) {
        TaskSceneDO entity = taskSceneRepo.findById(key).orElseGet(TaskSceneDO::new);
        Assert.notNull(entity.getId(), "场景不存在");
        TaskSceneVO vo = TaskSceneConvert.INSTANCE.toVo(entity);

        // 翻译
        translate(vo);
        return vo;
    }

    private void translate(TaskSceneVO vo) {
        // 关联的类别
        TaskSceneCategoryRefQuery taskSceneCategoryRefQuery = new TaskSceneCategoryRefQuery();
        taskSceneCategoryRefQuery.setSceneId(vo.getId());
//        List<TaskSceneCategoryRefVO> categoryRefVOS = taskSceneCategoryRefService.queryListDynamic(taskSceneCategoryRefQuery);
//        List<Long> categoryIdList = categoryRefVOS.stream().map(TaskSceneCategoryRefVO::getCategoryId).collect(Collectors.toList());
//        vo.setCategoryIdList(categoryIdList);

        // 类别对象
//        TaskCategoryQuery categoryQuery = new TaskCategoryQuery();
//        categoryQuery.setIdList(categoryIdList);
//        List<TaskCategoryVO> taskCategoryVOList = taskCategoryService.queryListDynamic(categoryQuery);
//        vo.setCategoryVoList(taskCategoryVOList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSceneVO insert(TaskScenePayload payload) {

        // 校验
        check(payload);

        // 唯一性校验
        uniquenessVerification(payload);

        TaskSceneDO entityDo = TaskSceneConvert.INSTANCE.toDo(payload);
        TaskSceneDO save = taskSceneRepo.save(entityDo);


        // 先清空关系，再全部插入
//        Long sceneId = save.getId();
//        taskSceneCategoryRefService.deleteSoftBySceneId(sceneId);
//        List<Long> categoryIdList = payload.getCategoryIdList();
//        if (!CollectionUtils.isEmpty(categoryIdList)) {
//            categoryIdList.stream().forEach(categoryId -> {
//                TaskSceneCategoryRefPayload refPayload = new TaskSceneCategoryRefPayload();
//                refPayload.setCategoryId(categoryId);
//                refPayload.setSceneId(sceneId);
//                taskSceneCategoryRefService.insert(refPayload);
//            });
//        }
        return TaskSceneConvert.INSTANCE.toVo(save);
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(TaskScenePayload payload) {
        Assert.hasText(payload.getName(), "场景名称不能为空");
    }


    /**
     * 唯一性验证
     *
     * @param payload 有效载荷
     */
    private void uniquenessVerification(TaskScenePayload payload) {
        TaskSceneQuery sceneQuery = new TaskSceneQuery();
        sceneQuery.setNameEq(payload.getName());
        sceneQuery.setIdNeq(payload.getId());
        long count = taskSceneDAO.count(sceneQuery);
        if (count > 0) {
            throw TwException.error("", "该任务类型数据已存在！");
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSceneVO update(TaskScenePayload payload) {
        TaskSceneDO entity = taskSceneRepo.findById(payload.getId()).orElseGet(TaskSceneDO::new);
        Assert.notNull(entity.getId(), "场景不存在");
        // 校验
        check(payload);
        // 唯一性校验
        uniquenessVerification(payload);

        TaskSceneDO entityDo = TaskSceneConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TaskSceneDO save = taskSceneRepo.save(entity);
        // 先清空关系，再全部插入
//        Long sceneId = save.getId();
//        taskSceneCategoryRefService.deleteSoftBySceneId(sceneId);
//        List<Long> categoryIdList = payload.getCategoryIdList();
//        if (!CollectionUtils.isEmpty(categoryIdList)) {
//            categoryIdList.stream().forEach(categoryId -> {
//                TaskSceneCategoryRefPayload refPayload = new TaskSceneCategoryRefPayload();
//                refPayload.setCategoryId(categoryId);
//                refPayload.setSceneId(sceneId);
//                taskSceneCategoryRefService.insert(refPayload);
//            });
//        }
        return TaskSceneConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskScenePayload payload) {
        TaskSceneDO entity = taskSceneRepo.findById(payload.getId()).orElseGet(TaskSceneDO::new);
        Assert.notNull(entity.getId(), "场景不存在");
        long result = taskSceneDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskSceneDAO.deleteSoft(keys);
            keys.forEach(x -> {
                // 检查任务是否存在
                Long res = taskInfoService.countBySceneId(x);
                if (res > 0) {
                    throw new BusinessException("该任务流下存在任务，不能被删除");
                }

            });

            // 同时删除关联的类别
//            taskSceneCategoryRefService.deleteSoftBySceneIdList(keys);
        }
    }

    @Override
    public List<TaskCategoryVO> listByRef(TaskCategoryQuery query) {
        return taskSceneDAO.listByRef(query);
    }

    @Override
    public Long count(TaskSceneQuery taskSceneQuery) {

        long res = taskSceneDAO.count(taskSceneQuery);
        return res;
    }

}
