package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.TServerApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.service.TServerApplyServiceImpl;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SERVER_APPLY" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class TServerApplyWorkflowCallBackController implements WorkflowCallBack {

    private final TServerApplyServiceImpl serverApplyService;
    private final TServerApplyDAO serverApplyDAO;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
//        String taskKey = payload.getTaskKey();
//        String businessKey = payload.getBusinessKey();
//        HashMap<String, Object> variables = new HashMap<>();
//        //根据业务key查询当前业务对象
//        TServerApplyVO tServerApplyVO = serverApplyService.queryByKey(Long.valueOf(businessKey));
//        if ("CLOUD".equals(tServerApplyVO.getType())) {
//            variables.put("cloudServerFlag", true);
//        } else {
//            variables.put("cloudServerFlag", false);
//        }
//        workflowUtil.setVaribales(SetVariablesPayload.of(payload.getProcDefKey(),variables));
//        ArrayList<String> list = new ArrayList<>();
//        if (tServerApplyVO != null) {
//            if (taskKey.equals("Activity_0zkpvgk")) {
//                //获取费用承担部门
//                Long expenseBuId = tServerApplyVO.getExpenseBuId();
//                Long expenseBuManageUserId = daoOrg.queryManageIdById(expenseBuId);
//                list.add(expenseBuManageUserId.toString());
//            }
//            if (taskKey.equals("Activity_0ph077t")) {
//                // 获取使用人部门负责人
//                Long userBuId = tServerApplyVO.getUserBuId();
//  //                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(applyDo.getUserResId());
//                Long userBuManageUserId = daoOrg.queryManageIdById(userBuId);
//                variables.put("Activity_0ph077t", userBuManageUserId);
//            }
//            if ("Activity_1tge65e".equals(taskKey)) {
//                // 平台IT负责人
//                PrdOrgRoleVO platItAdmin = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, "PLAT_IT_ADMIN");
//                if (ObjectUtils.isEmpty(platItAdmin)) {
//                    throw new BusinessException("平台IT负责人角色不存在！");
//                }
//                String[] splitByPlatItAdmin = platItAdmin.getRoleEmployees().split(",");
//                variables.put("Activity_1tge65e", Arrays.asList(splitByPlatItAdmin));
//            }
//            if ("".equals(taskKey)) {
//                // 平台采购主管
//                PrdOrgRoleVO purchaseManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, "PURCHASE_MANAGER");
//                if (ObjectUtils.isEmpty(purchaseManager)) {
//                    throw new BusinessException("平台采购主管角色不存在！");
//                }
//                String[] splitByPurchaseManager = purchaseManager.getRoleEmployees().split(",");
//                variables.put("Activity_1gcgq14", Arrays.asList(splitByPurchaseManager));
//
//            }
//        }
//        return WorkflowResult.success(list);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }


    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TServerApplyPayload serverApplyPayload = new TServerApplyPayload();
        serverApplyPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        TServerApplyVO tServerApplyVO = serverApplyService.queryByKey(Long.valueOf(businessKey));
        if (tServerApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                case INVALID://先删除流程再删除单据
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.INVALID.getCode());
                    serverApplyPayload.setDeleteFlag(1);
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    serverApplyPayload.setApprovedTime(LocalDateTime.now());
                    break;
                case APPROVING:
                    serverApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    serverApplyPayload.setApplyStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            serverApplyDAO.updateByKeyDynamic(serverApplyPayload);
        }
        return WorkflowResult.success(null);
    }
}
