package com.elitesland.tw.tw5.server.yeedoc.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 附件工具类
 */
public interface FileUtilService {
    /**
     * 创建文件夹（一个或者多个）
     * @param libraryId
     * @param itemId
     * @param pathArry
     * @param authTokenByYdk
     * @return 易道壳的文件夹的itemId
     */
    String createYdkFolder(String libraryId, String itemId, List<String> pathArry, String authTokenByYdk);

    /**
     * 文件夹重命名
     * @return 易道壳的文件夹的itemId
     */
    String reNameFolder(String itemId, String folderName, String authTokenByYdk);

    /**
     * 最终保存附件
     * @return map(cacheKey,itemId)
     */
    Map<String, String> saveYdkFile(String libraryId, String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk);

}
