package com.elitesland.tw.tw5.server.yeedocpro.service;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.pms.payload.NewUploadFilesSavePayload;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.*;

import java.util.List;
import java.util.Map;

/**
 * yeedoc服务
 *
 * @author
 */
public interface YeedocProService {

    /**
     * 最终保存文件
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link String}>
     */
    List<String> newUploadFilesSave(NewUploadFilesSavePayload payload);

    /**
     * 最终保存文件
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link String}>
     */
    List<GetCaCheKeyItemIdDTO> newUploadFilesSaveAndReturnItemId(NewUploadFilesSavePayload payload);


    /**
     * 获取上传的附件Id
     *
     * @param paload paload
     * @return {@link List}<{@link GetCaCheKeyItemIdDTO}>
     */
    List<GetCaCheKeyItemIdDTO> getCaCheKeyItemId(GetCaCheKeyItemIdPayload paload);

    /**
     * 获取所有文件信息
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link GetAllItemsInfoDTO}>
     */
    List<GetAllItemsInfoDTO> getAllItemsInfo(GetAllItemsInfoPayload payload);

    /**
     * (单个文件夹)获取创建问价夹后的id
     *
     * @param createFolderTwPayload 创建文件夹tw负载
     * @return {@link YeedocCreateFolderForTwDTO}
     */
    YeedocCreateFolderForTwDTO createFolderForTw(CreateFolderTwPayload createFolderTwPayload);

    /**
     * (单个文件夹)获取创建问价夹后的id
     * 解析创建文件夹返回
     *
     * @param yeedcocReturnResult yeedcoc返回结果
     * @return {@link String}
     */
    YeedocCreateFolderForTwDTO createFolderForTwReturnOne(String yeedcocReturnResult);

    /**
     * 创建文件夹
     * <p>
     * request
     * {
     * "LibraryId": "d5d26f53-81a2-46e9-991c-4321a53a7516",
     * "Path": "/caa/dd/eee"
     * }
     * <p>
     * return
     * {
     * "Message": "创建成功!",
     * "IsSuccess": true,
     * "Code": 0,
     * "TotalCount": 0,
     * "Data": {
     * "FolderId": "06fdd8e8-f876-4537-8dd3-de352114ade1",
     * "LeafName": "eee",
     * "LibraryId": "d5d26f53-81a2-46e9-991c-4321a53a7516"
     * }
     * }
     *
     * @param createFolderPayload 创建文件夹负载
     * @return {@link String}
     */
    String createFolder(CreateFolderPayload createFolderPayload);


    /**
     * (多个文件夹)获取创建问价夹后的id
     *
     * @param yeedcocReturnResult yeedcoc返回结果
     * @return {@link List}<{@link YeedocCreateFolderDataDTO}>
     */
    YeedocCreateFolderDataDTO createFolderReturn(String yeedcocReturnResult);

    /**
     * 根据文件夹id拉取文件列表-易稻壳
     *
     * @param itemInfoPayload 有效载荷
     * @return {@link String}
     */
    String itemInfo(ItemInfoPayload itemInfoPayload);

    /**
     * 根据文件夹id拉取文件列表-易稻壳
     *
     * @param itemInfoPayload 项目信息有效载荷
     * @return {@link Map}<{@link String}, {@link List}<{@link ItemInfoDataFileDTO}>>
     */
    Map<String, List<ItemInfoDataFileDTO>> itemInfoReturn(ItemInfoPayload itemInfoPayload);

    /**
     * 根据文件名称 查询 所属文件夹 id
     *
     * @param payload 有效载荷
     * @return {@link List<FolderListByItemNameDTO>}
     */
    List<FolderListByItemNameDTO> folderListByItemName(FolderListByItemNamePayload payload);

    /**
     * 重命名文件夹
     *
     * @param map 地图
     * @return {@link String}
     */
    String reNameFolder(Map<String, Object> map);

    /**
     * @param map 上传文件或文件夹的最终保存
     * @param authToken
     * @return
     */
    // String newUploadFilesSave(Map<String, Object> map, String authToken);

    /**
     * @param map 获取上传的附件Id
     * @param authToken
     * @return
     */
    // String getCaCheKeyItemId (Map<String, Object> map, String authToken);


    /**
     * 获取易稻壳文件夹链接uri
     *
     * @param itemId 项目id
     * @return {@link String}
     */
    String preViewItemPro(String itemId);

    /**
     * 删除项目
     *
     * @param itemId 项id
     * @return {@link String}
     */
    String deleteItem(String itemId);

    String deleteItem(String itemId, String authToken);

    /**
     * 通过用户信息生成易稻壳的jwt
     *
     * @param loginUser
     */
    String getYeedocJwt(SysUserDTO loginUser);

    /**
     * 获取当前登录人的易稻壳的jwt
     */
    String getYeedocJwt();
}
