/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.QyWx.service;

import com.alibaba.cloud.commons.io.IOUtils;
import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxCalendarPayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.payload.QyWxScheduleRepeatPayload;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.BeanConverterUtils;
import com.elitesland.tw.tw5.server.common.BeanMapTool;
import com.elitesland.tw.tw5.server.common.QyWx.QyWxUtil.CallBackEventEnum;
import com.elitesland.tw.tw5.server.common.QyWx.QyWxUtil.WXBizMsgCrypt;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleDAO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WXPushService {
    private static final String sToken = "wIzBCTPJ";
    private static final String sEncodingAESKey = "IFxAxLOaqxfbYXW1U78KJy7x4pjfG4Fd5UKvjAdL1cx";
    private static final String sCorpID = "wx7760085f07e6ac57";
    private final PrdCalendarService calendarService;
    private final PrdScheduleService scheduleService;
    private final PrdCalendarDAO calendarDAO;
    private final PrdScheduleDAO scheduleDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final QyWxCommunicationService communicationService;

    public String autograph(String msgSignature, String timestamp, String nonce, String echostr) {
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            String sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp, nonce, echostr);
            System.out.println("verifyurl echostr: " + sEchoStr);
            return sEchoStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, String> decrypt(String msgSignature, String timestamp, String nonce, HttpServletRequest request) {
        try {
            ServletInputStream inputStream = request.getInputStream();
            String sReqData = IOUtils.toString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            String sMsg = wxcpt.DecryptMsg(msgSignature, timestamp, nonce, sReqData);
            System.out.println("after decrypt msg: " + sMsg);
            Map<String, String> stringStringMap = WXPushService.parseXml(sMsg);
            return stringStringMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encrypt(String timestamp, String nonce, String data, String fromUserName, String toUserName) {
        String sRespData = "<xml><ToUserName><![CDATA[" + toUserName + "]]></ToUserName><Content><![CDATA[" + data + "]]></Content><AgentID><![CDATA[1000030]]></AgentID><FromUserName><![CDATA[" + fromUserName + "]]></FromUserName><FromUserName><![CDATA[" + toUserName + "]]></FromUserName><CreateTime>" + timestamp + "</CreateTime><MsgType><![CDATA[text]]></MsgType></xml>";
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            String sEncryptMsg = wxcpt.EncryptMsg(sRespData, timestamp, nonce);
            return sEncryptMsg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> parseXml(String msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8.name()));){
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)inputStream);
            Element root = document.getRootElement();
            List elementList = root.elements();
            for (Element e : elementList) {
                map.put(e.getName(), e.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Transactional
    public String doCallBack(Map<String, String> content, String timestamp, String nonce) {
        if (content != null) {
            String fromUserName = this.employeeDAO.queryByWeComeId(content.get("FromUserName")).getEmployeeName();
            CallBackEventEnum event = CallBackEventEnum.valueOf(content.get("Event").toUpperCase());
            switch (event) {
                case MODIFY_CALENDAR: {
                    Map<String, Object> calendar = this.communicationService.getCalendar(content.get("CalId"));
                    QyWxCalendarPayload qyWxCalendarPayload = BeanMapTool.mapToBean(QyWxCalendarPayload.class, calendar);
                    PrdCalendarPayload prdCalendarPayload = this.calendarService.transferToPrdPayload(qyWxCalendarPayload);
                    PrdCalendarVO calendarVo = this.calendarDAO.queryByQyWxCalId(content.get("CalId"));
                    prdCalendarPayload.setDefaultFlag(calendarVo.getDefaultFlag());
                    prdCalendarPayload.setId(calendarVo.getId());
                    prdCalendarPayload.setFromQyWx(Boolean.valueOf(true));
                    this.calendarService.insertOrUpdate(prdCalendarPayload);
                    break;
                }
                case DELETE_CALENDAR: {
                    PrdCalendarVO calendarVo = this.calendarDAO.queryByQyWxCalId(content.get("CalId"));
                    Long id = calendarVo.getId();
                    this.calendarService.deleteSoft(Collections.singletonList(id));
                    break;
                }
                case ADD_SCHEDULE: 
                case MODIFY_SCHEDULE: {
                    Map<String, Object> schedule = this.communicationService.getSchedule(content.get("ScheduleId"));
                    QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
                    QyWxScheduleRepeatPayload repeatPayload = new QyWxScheduleRepeatPayload();
                    try {
                        Map reminders = (Map)JSON.parse((String)String.valueOf(schedule.get("reminders")));
                        List excludeListMapList = (List)reminders.get("exclude_time_list");
                        reminders.put("exclude_time_list", excludeListMapList);
                        BeanConverterUtils.map2Bean(reminders, repeatPayload);
                        List attendees = (List)schedule.get("attendees");
                        schedule.put("attendees", attendees);
                        schedule.put("reminders", repeatPayload);
                        BeanConverterUtils.map2Bean(schedule, qyWxSchedulePayload);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PrdSchedulePayload prdSchedulePayload = this.scheduleService.transferToPrdPayload(qyWxSchedulePayload);
                    PrdCalendarVO calendarVo = this.calendarDAO.queryByQyWxCalId(content.get("CalId"));
                    PrdScheduleVO scheduleVo = this.scheduleDAO.queryByQyWxScheduleId(content.get("ScheduleId"));
                    prdSchedulePayload.setCalId(calendarVo.getId());
                    if (scheduleVo != null) {
                        prdSchedulePayload.setId(scheduleVo.getId());
                    }
                    prdSchedulePayload.setFromQyWx(Boolean.valueOf(true));
                    this.scheduleService.insertOrUpdate(prdSchedulePayload);
                    break;
                }
                case DELETE_SCHEDULE: {
                    PrdScheduleVO scheduleVo = this.scheduleDAO.queryByQyWxScheduleId(content.get("ScheduleId"));
                    if (scheduleVo == null) break;
                    Long scheduleVoId = scheduleVo.getId();
                    this.scheduleService.deleteSoft(Collections.singletonList(scheduleVoId));
                    break;
                }
                default: {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public WXPushService(PrdCalendarService calendarService, PrdScheduleService scheduleService, PrdCalendarDAO calendarDAO, PrdScheduleDAO scheduleDAO, PrdOrgEmployeeDAO employeeDAO, QyWxCommunicationService communicationService) {
        this.calendarService = calendarService;
        this.scheduleService = scheduleService;
        this.calendarDAO = calendarDAO;
        this.scheduleDAO = scheduleDAO;
        this.employeeDAO = employeeDAO;
        this.communicationService = communicationService;
    }
}

