/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ExpressionUtils {
    private static final Map<String, Expression> EXPRESSION_CACHE = new ConcurrentHashMap<String, Expression>(64);

    @Nullable
    public static Expression getExpression(@Nullable String expressionString) {
        if (StringUtils.isBlank((CharSequence)expressionString)) {
            return null;
        }
        if (EXPRESSION_CACHE.containsKey(expressionString)) {
            return EXPRESSION_CACHE.get(expressionString);
        }
        Expression expression = new SpelExpressionParser().parseExpression(expressionString);
        EXPRESSION_CACHE.put(expressionString, expression);
        return expression;
    }

    @Nullable
    public static <T> T getExpressionValue(@Nullable Object root, @Nullable String expressionString, @NonNull Class<? extends T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (root == null) {
            return null;
        }
        Expression expression = ExpressionUtils.getExpression(expressionString);
        if (expression == null) {
            return null;
        }
        return (T)expression.getValue(root, clazz);
    }

    @Nullable
    public static <T> T getExpressionValue(@Nullable Object root, @Nullable String expressionString) {
        if (root == null) {
            return null;
        }
        Expression expression = ExpressionUtils.getExpression(expressionString);
        if (expression == null) {
            return null;
        }
        return (T)expression.getValue(root);
    }

    public static <T> T[] getExpressionValue(@Nullable Object root, String ... expressionStrings) {
        if (root == null) {
            return null;
        }
        if (ArrayUtils.isEmpty((Object[])expressionStrings)) {
            return null;
        }
        Assert.notNull((Object)expressionStrings, (String)"Expressions cannot be null!");
        Object[] values = new Object[expressionStrings.length];
        for (int i = 0; i < expressionStrings.length; ++i) {
            values[i] = ExpressionUtils.getExpressionValue(root, expressionStrings[i]);
        }
        return values;
    }

    @Nullable
    public static boolean getConditionValue(@Nullable Object root, @Nullable String expressionString) {
        Object value = ExpressionUtils.getExpressionValue(root, expressionString);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() > 0L;
        }
        return true;
    }

    @Nullable
    public static boolean getConditionValue(@Nullable Object root, String ... expressionStrings) {
        if (root == null) {
            return false;
        }
        if (ArrayUtils.isEmpty((Object[])expressionStrings)) {
            return false;
        }
        Assert.notNull((Object)expressionStrings, (String)"Expressions cannot be null!");
        for (String expressionString : expressionStrings) {
            if (ExpressionUtils.getConditionValue(root, expressionString)) continue;
            return false;
        }
        return true;
    }
}

