/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimRuleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimRuleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimRuleNoticeLevelEnum;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimRuleTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimRuleConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimRuleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimRuleRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AccReimRuleServiceImpl
extends BaseServiceImpl
implements AccReimRuleService {
    private static final Logger log = LoggerFactory.getLogger(AccReimRuleServiceImpl.class);
    private final AccReimRuleRepo repo;
    private final AccReimRuleDAO dao;
    private final AccBusinessItemService accBusinessItemService;
    private final AccReimDAO reimDAO;
    private final AccReimDetailDAO reimDetailDAO;
    private final InvInvoiceService invInvoiceService;
    private final CacheUtil cacheUtil;

    public PagingVO<AccReimRuleVO> queryPaging(AccReimRuleQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<AccReimRuleVO> queryListDynamic(AccReimRuleQuery query) {
        return this.dao.queryListDynamic(query);
    }

    public AccReimRuleVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    @Transactional
    public AccReimRuleVO insert(AccReimRulePayload payload) {
        AccReimRuleDO entityDo = AccReimRuleConvert.INSTANCE.toDo(payload);
        return AccReimRuleConvert.INSTANCE.toVo((AccReimRuleDO)this.repo.save(entityDo));
    }

    @Transactional
    public AccReimRuleVO update(AccReimRulePayload payload) {
        AccReimRuleDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimRuleDO entityDo = AccReimRuleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimRuleConvert.INSTANCE.toVo((AccReimRuleDO)this.repo.save(entity));
    }

    @Transactional
    public long updateByKeyDynamic(AccReimRulePayload payload) {
        AccReimRuleDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimRuleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.dao.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
        }
    }

    public List<Map<String, String>> reimRuleCheck(AccReimPayload payload) {
        List invInvoiceVOS;
        List details = payload.getDetails();
        if (ObjectUtils.isEmpty((Object)details)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> checkResult = new ArrayList<Map<String, String>>();
        AccReimRuleQuery query = new AccReimRuleQuery();
        query.setRuleFlag(Integer.valueOf(1));
        List<AccReimRuleVO> accReimRuleVOS = this.dao.queryListDynamic(query);
        ArrayList normalAndSelfRuleVOS = new ArrayList();
        ArrayList item4RuleVOS = new ArrayList();
        accReimRuleVOS.forEach(ruleVO -> {
            if (AccReimRuleTypeEnum.NORMAL.getCode().equals(ruleVO.getRuleType()) || payload.getReimDocType().equals(ruleVO.getRuleType())) {
                normalAndSelfRuleVOS.add(ruleVO);
            } else {
                item4RuleVOS.add(ruleVO);
            }
        });
        ArrayList invIdList = new ArrayList();
        for (AccReimDetailPayload detailPayload : details) {
            if (ObjectUtils.isEmpty((Object)detailPayload.getInvIdList())) continue;
            invIdList.addAll(detailPayload.getInvIdList());
        }
        if (!ObjectUtils.isEmpty(invIdList)) {
            InvInvoiceQuery invoiceQuery = new InvInvoiceQuery();
            invoiceQuery.setIdList(invIdList);
            invInvoiceVOS = this.invInvoiceService.queryListDynamic(invoiceQuery);
        } else {
            invInvoiceVOS = null;
        }
        PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(payload.getReimUserId());
        details.forEach(dtl -> {
            List selfInvVO;
            List busItem4Rules = item4RuleVOS.stream().filter(vo -> !ObjectUtils.isEmpty((Object)vo.getBusAccItemCodes()) && vo.getBusAccItemCodes().contains(dtl.getBusAccItemCode())).collect(Collectors.toList());
            busItem4Rules.addAll(normalAndSelfRuleVOS);
            if (!(ObjectUtils.isEmpty((Object)invInvoiceVOS) || ObjectUtils.isEmpty((Object)dtl.getInvIdList()) || ObjectUtils.isEmpty(selfInvVO = invInvoiceVOS.stream().filter(invInvoiceVO -> dtl.getInvIdList().contains(invInvoiceVO.getId())).collect(Collectors.toList())))) {
                dtl.setInvInvoiceVOS(selfInvVO);
            }
            List<AccReimVO> currentMonthReim = this.getCurrentMonthReim(payload.getReimUserId(), dtl.getExpenseDate());
            ArrayList<AccReimDetailVO> currentMonthDtl = new ArrayList();
            if (!ObjectUtils.isEmpty(currentMonthReim)) {
                currentMonthDtl = this.getCurrentMonthDtl(currentMonthReim);
            }
            for (AccReimRuleVO ruleVO : busItem4Rules) {
                this.ruleHandler(ruleVO, payload, (AccReimDetailPayload)dtl, (List<Map<String, String>>)checkResult, (List<AccReimDetailVO>)currentMonthDtl, employeeVO, currentMonthReim);
            }
        });
        return checkResult;
    }

    private List<AccReimDetailVO> getCurrentMonthDtl(List<AccReimVO> voList) {
        Set reimIdList = voList.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
        return this.reimDetailDAO.queryByMasIds(new ArrayList<Long>(reimIdList));
    }

    private List<AccReimVO> getCurrentMonthReim(Long reimUserId, LocalDate expenseDate) {
        AccReimQuery reimQuery = new AccReimQuery();
        reimQuery.setReimUserId(reimUserId);
        LocalDate startOfMonth = expenseDate.withDayOfMonth(1);
        LocalDate endOfMonth = expenseDate.withDayOfMonth(expenseDate.lengthOfMonth());
        endOfMonth = endOfMonth.plusDays(1L);
        reimQuery.setExpenseDateStart(startOfMonth);
        reimQuery.setExpenseDateEnd(endOfMonth);
        List<AccReimVO> voList = this.reimDAO.queryList4Rule(reimQuery);
        if (ObjectUtils.isEmpty(voList)) {
            return Collections.emptyList();
        }
        return voList;
    }

    private void ruleHandler(AccReimRuleVO ruleVO, AccReimPayload payload, AccReimDetailPayload detailPayload, List<Map<String, String>> checkResult, List<AccReimDetailVO> currentMonthDtl, PrdOrgEmployeeVO employeeVO, List<AccReimVO> currentMonthReim) {
        switch (RuleCodeEnum.find(ruleVO.getRuleNo())) {
            case RULE001: {
                break;
            }
            case RULE002: {
                break;
            }
            case RULE003: {
                break;
            }
            case RULE004: {
                break;
            }
            case RULE005: {
                break;
            }
            case RULE006: {
                break;
            }
            case RULE007: {
                break;
            }
            case RULE008: {
                this.mealAndEntertainRepeatHandler(ruleVO, checkResult, detailPayload, currentMonthDtl, currentMonthReim, payload);
                break;
            }
            case RULE009: {
                this.dtlInvFillHandler(ruleVO, payload, detailPayload, checkResult);
                break;
            }
            case RULE010: {
                break;
            }
            case RULE011: {
                this.invAndExpenseDateHandler(ruleVO, checkResult, detailPayload);
                break;
            }
            case RULE012: {
                break;
            }
            case RULE013: {
                Set collect = currentMonthReim.stream().filter(vo -> AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(vo.getReimDocType())).map(BaseViewModel::getId).collect(Collectors.toSet());
                if (ObjectUtils.isEmpty(collect)) break;
                List<AccReimDetailVO> filterDtl = currentMonthDtl.stream().filter(dtl -> collect.contains(dtl.getMasId())).collect(Collectors.toList());
                this.reimRepeatHandler(ruleVO, detailPayload, checkResult, filterDtl, payload.getId());
                break;
            }
            case RULE014: {
                this.busEntertainFeeHandler(ruleVO, detailPayload, checkResult, payload);
                break;
            }
            case RULE015: {
                this.limitAmtHandler(ruleVO, detailPayload, employeeVO, checkResult, payload);
                break;
            }
        }
    }

    private void dtlInvFillHandler(AccReimRuleVO ruleVO, AccReimPayload payload, AccReimDetailPayload detailPayload, List<Map<String, String>> checkResult) {
        if (!AccReimDocTypeEnum.ACC_TRIP_TICKET.getCode().equals(payload.getReimDocType()) && ObjectUtils.isEmpty((Object)detailPayload.getNoinvReason()) && ObjectUtils.isEmpty((Object)detailPayload.getInvIdList())) {
            if (AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u5fc5\u987b\u5173\u8054\u53d1\u7968\u6216\u8005\u586b\u5199\u65e0\u53d1\u7968\u539f\u56e0\uff01\uff01\uff01");
            }
            if (AccReimRuleNoticeLevelEnum.WARN.getCode().equals(ruleVO.getNoticeLevel())) {
                // empty if block
            }
        }
    }

    private void reimRepeatHandler(AccReimRuleVO ruleVO, AccReimDetailPayload detailPayload, List<Map<String, String>> checkResult, List<AccReimDetailVO> currentMonthDtl, Long reimId) {
        if (!ObjectUtils.isEmpty((Object)reimId) && reimId <= 0L) {
            reimId = null;
        }
        if (ObjectUtils.isEmpty(currentMonthDtl)) {
            return;
        }
        List busItemIds = currentMonthDtl.stream().map(AccReimDetailVO::getBusAccItemId).collect(Collectors.toList());
        if (busItemIds.contains(detailPayload.getBusAccItemId())) {
            Set<Long> masIds = currentMonthDtl.stream().filter(dtl -> dtl.getBusAccItemId().equals(detailPayload.getBusAccItemId())).map(AccReimDetailVO::getMasId).collect(Collectors.toSet());
            Long useReimId = reimId;
            masIds.forEach(masId -> {
                if (!Objects.equals(masId, useReimId)) {
                    if (AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                        throw TwException.error("", "\u4e13\u9879\u62a5\u9500\u91cd\u590d!\u6bcf\u4e00\u79cd\u4e13\u9879\u62a5\u9500\u79d1\u76ee\u7c7b\u578b\u5f53\u6708\u4ec5\u5141\u8bb8\u63d0\u4ea4\u4e00\u6b21\uff01");
                    }
                    if (AccReimRuleNoticeLevelEnum.WARN.getCode().equals(ruleVO.getNoticeLevel())) {
                        // empty if block
                    }
                }
            });
        }
    }

    private void busEntertainFeeHandler(AccReimRuleVO ruleVO, AccReimDetailPayload detailPayload, List<Map<String, String>> checkResult, AccReimPayload payload) {
        if (!AccReimDocTypeEnum.ACC_TRIP.getCode().equals(payload.getReimDocType())) {
            return;
        }
        if (ruleVO.getBusAccItemCodes().contains(detailPayload.getBusAccItemCode()) && detailPayload.getReimAmt().compareTo(ruleVO.getLimitAmt()) > 0) {
            if (AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u4e1a\u52a1\u62db\u5f85\u8d39\u8d85\u8fc7" + ruleVO.getLimitAmt() + "\u8bf7\u8d70\u7279\u6b8a\u8d39\u7528\u62a5\u9500\uff01");
            }
            if (AccReimRuleNoticeLevelEnum.WARN.getCode().equals(ruleVO.getNoticeLevel())) {
                // empty if block
            }
        }
    }

    private void mealAndEntertainRepeatHandler(AccReimRuleVO ruleVO, List<Map<String, String>> checkResult, AccReimDetailPayload detailPayload, List<AccReimDetailVO> currentMonthDtl, List<AccReimVO> currentMonthReim, AccReimPayload payload) {
        String[] split = ruleVO.getBusAccItemCodes().split(",");
        List<String> ruleItemCodes = List.of(split);
        List currentReimCode = payload.getDetails().stream().map(AccReimDetailPayload::getBusAccItemCode).collect(Collectors.toList());
        if (currentReimCode.containsAll(ruleItemCodes) && AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
            throw TwException.error("", "\u5b58\u5728\u9910\u8d39\u4e0e\u4e1a\u52a1\u62db\u5f85\u8d39\u91cd\u590d\u62a5\u9500\uff01");
        }
        if (!ruleItemCodes.contains(detailPayload.getBusAccItemCode())) {
            return;
        }
        if (ObjectUtils.isEmpty(currentMonthReim) || ObjectUtils.isEmpty(currentMonthDtl)) {
            return;
        }
        List dtlExpenseDateList = payload.getDetails().stream().map(AccReimDetailPayload::getExpenseDate).collect(Collectors.toList());
        Set masIdSet = currentMonthDtl.stream().filter(dtl -> dtlExpenseDateList.contains(dtl.getExpenseDate())).map(AccReimDetailVO::getMasId).collect(Collectors.toSet());
        Set relateDocIds = currentMonthReim.stream().filter(reim -> !ObjectUtils.isEmpty((Object)reim.getRelatedDocId()) && masIdSet.contains(reim.getId())).map(AccReimVO::getRelatedDocId).collect(Collectors.toSet());
        if (ObjectUtils.isEmpty(relateDocIds) || !relateDocIds.contains(payload.getRelatedDocId())) {
            return;
        }
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            return;
        }
        List busAccItemCodes = currentMonthDtl.stream().filter(dtl -> detailPayload.getExpenseDate().equals(dtl.getExpenseDate())).map(AccReimDetailVO::getBusAccItemCode).collect(Collectors.toList());
        for (String ruleItemCode : ruleItemCodes) {
            if (!busAccItemCodes.contains(ruleItemCode)) continue;
            if (AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u5b58\u5728\u9910\u8d39\u4e0e\u4e1a\u52a1\u62db\u5f85\u8d39\u91cd\u590d\u62a5\u9500\uff01");
            }
            if (!AccReimRuleNoticeLevelEnum.WARN.getCode().equals(ruleVO.getNoticeLevel())) continue;
        }
    }

    private void invAndExpenseDateHandler(AccReimRuleVO ruleVO, List<Map<String, String>> checkResult, AccReimDetailPayload detailPayload) {
        if (ObjectUtils.isEmpty((Object)detailPayload.getInvInvoiceVOS())) {
            log.info("\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u9700\u6821\u9a8c");
            return;
        }
        if (ruleVO.getBusAccItemCodes().contains(detailPayload.getBusAccItemCode())) {
            log.info("\u5f53\u524d\u79d1\u76ee\u4e0d\u9700\u505a\u6b64\u9879\u68c0\u67e5\uff0c\u79d1\u76ee\u7f16\u7801 is {}", (Object)detailPayload.getBusAccItemCode());
            return;
        }
        for (InvInvoiceVO invInvoiceVO : detailPayload.getInvInvoiceVOS()) {
            if (ObjectUtils.isEmpty((Object)invInvoiceVO.getInvoiceDate())) {
                log.info("\u53d1\u7968\u5f00\u7968\u65e5\u671f\u4e3a\u7a7a\uff0c\u8c03\u8fc7\u6821\u9a8c\uff0c\u53d1\u7968\u53f7\u4e3a\uff1a{}", (Object)invInvoiceVO.getInvoiceNo());
                continue;
            }
            LocalDate invDate = LocalDate.parse(invInvoiceVO.getInvoiceDate());
            if (invDate.compareTo(detailPayload.getExpenseDate()) >= 0) continue;
            if (AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u53d1\u7968\u7684\u5f00\u7968\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d39\u7528\u53d1\u751f\u65e5\u671f");
            }
            if (!AccReimRuleNoticeLevelEnum.WARN.getCode().equals(ruleVO.getNoticeLevel())) continue;
        }
    }

    private void limitAmtHandler(AccReimRuleVO ruleVO, AccReimDetailPayload detailPayload, PrdOrgEmployeeVO employeeVO, List<Map<String, String>> checkResult, AccReimPayload payload) {
        if (!AccReimDocTypeEnum.ACC_SPECIAL.getCode().equals(payload.getReimDocType())) {
            return;
        }
        Object[] split = ruleVO.getBusAccItemCodes().split(",");
        if (ObjectUtils.isEmpty((Object[])split) || split.length < 2) {
            log.error("\u4ea4\u901a\u3001\u901a\u8baf\u8d39\u7528code\u672a\u5728\u914d\u7f6e\u8868\u8fdb\u884c\u7ef4\u62a4\uff0c\u8bf7\u5728acc_reim_rule\u8868\u4e2d\u7ef4\u62a4\u5f53\u524d\u89c4\u5219\u4fe1\u606f\uff0crule info is {}", (Object)JSON.toJSONString((Object)ruleVO));
            throw TwException.error("", "\u4ea4\u901a\u3001\u901a\u8baf\u8d39\u7528code\u672a\u5728\u914d\u7f6e\u8868\u8fdb\u884c\u7ef4\u62a4\uff0c\u8bf7\u5728acc_reim_rule\u8868\u4e2d\u7ef4\u62a4\u5f53\u524d\u89c4\u5219\u4fe1\u606f,\u89c4\u5219\u7f16\u53f7\u4e3a\uff1a" + ruleVO.getRuleNo());
        }
        String extString7 = employeeVO.getExtString7();
        String extString8 = employeeVO.getExtString8();
        if (ObjectUtils.isEmpty((Object)extString7) || ObjectUtils.isEmpty((Object)extString8)) {
            throw TwException.error("", "\u5458\u5de5\u4fe1\u606f\u7684\u4ea4\u901a\u8d39\u989d\u5ea6\u6216\u901a\u8baf\u8d39\u989d\u5ea6\u672a\u7ef4\u62a4\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7ef4\u62a4\uff01");
        }
        if (detailPayload.getBusAccItemCode().equals(split[0])) {
            BigDecimal portLimitAmt = new BigDecimal(extString8);
            if (detailPayload.getReimAmt().compareTo(portLimitAmt) > 0 && AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u4e13\u9879\u62a5\u9500\u4ea4\u901a\u8d39\u5df2\u8d85\u8fc7\u4e2a\u4eba\u989d\u5ea6\uff01");
            }
        }
        if (detailPayload.getBusAccItemCode().equals(split[1])) {
            BigDecimal phoneLimitAmt = new BigDecimal(extString7);
            if (detailPayload.getReimAmt().compareTo(phoneLimitAmt) > 0 && AccReimRuleNoticeLevelEnum.ILLEGAL.getCode().equals(ruleVO.getNoticeLevel())) {
                throw TwException.error("", "\u4e13\u9879\u62a5\u9500\u901a\u8baf\u8d39\u5df2\u8d85\u8fc7\u4e2a\u4eba\u989d\u5ea6\uff01");
            }
        }
    }

    public AccReimRuleServiceImpl(AccReimRuleRepo repo, AccReimRuleDAO dao, AccBusinessItemService accBusinessItemService, AccReimDAO reimDAO, AccReimDetailDAO reimDetailDAO, InvInvoiceService invInvoiceService, CacheUtil cacheUtil) {
        this.repo = repo;
        this.dao = dao;
        this.accBusinessItemService = accBusinessItemService;
        this.reimDAO = reimDAO;
        this.reimDetailDAO = reimDetailDAO;
        this.invInvoiceService = invInvoiceService;
        this.cacheUtil = cacheUtil;
    }

    static enum RuleCodeEnum {
        RULE001("RULE001"),
        RULE002("RULE002"),
        RULE003("RULE003"),
        RULE004("RULE004"),
        RULE005("RULE005"),
        RULE006("RULE006"),
        RULE007("RULE007"),
        RULE008("RULE008"),
        RULE009("RULE009"),
        RULE010("RULE010"),
        RULE011("RULE011"),
        RULE012("RULE012"),
        RULE013("RULE013"),
        RULE014("RULE014"),
        RULE015("RULE015");

        private String ruleDesc;

        private RuleCodeEnum(String ruleDesc) {
            this.ruleDesc = ruleDesc;
        }

        static RuleCodeEnum find(String ruleDesc) {
            for (RuleCodeEnum instance : RuleCodeEnum.values()) {
                if (!ruleDesc.equals(instance.ruleDesc)) continue;
                return instance;
            }
            return null;
        }
    }
}

