/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingLimitPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingLimitRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitRuleService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingLimitService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitRuleVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingLimitVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingLimitConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingLimitRuleConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingLimitDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingLimitRuleDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingLimitDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingLimitRuleDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingLimitRuleRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AccReimSettingLimitServiceImpl
extends BaseServiceImpl
implements AccReimSettingLimitService {
    private static final Logger log = LoggerFactory.getLogger(AccReimSettingLimitServiceImpl.class);
    private final AccReimSettingLimitRepo accReimSettingLimitRepo;
    private final AccReimSettingLimitDAO accReimSettingLimitDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final AccReimSettingLimitRuleService accReimSettingLimitRuleService;
    private final AccReimSettingLimitRuleRepo accReimSettingLimitRuleRepo;
    private final AccReimSettingLimitRuleDAO accReimSettingLimitRuleDAO;
    private final PrdOrgEmployeeService employeeService;

    public PagingVO<AccReimSettingLimitVO> queryPaging(AccReimSettingLimitQuery query) {
        return this.accReimSettingLimitDAO.queryPaging(query);
    }

    public List<AccReimSettingLimitVO> queryListDynamic(AccReimSettingLimitQuery query) {
        return this.accReimSettingLimitDAO.queryListDynamic(query);
    }

    public AccReimSettingLimitVO queryByKey(Long key) {
        AccReimSettingLimitDO entity = this.accReimSettingLimitRepo.findById(key).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingLimitVO vo = AccReimSettingLimitConvert.INSTANCE.toVo(entity);
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.LODGE_OVERAGE.getCode());
        List accReimSettingVOS = this.accReimSettingService.queryListDynamic(accReimSettingQuery);
        if (!CollectionUtils.isEmpty((Collection)accReimSettingVOS)) {
            vo.setAccReimSettingVO((AccReimSettingVO)accReimSettingVOS.get(0));
        }
        AccReimSettingLimitRuleQuery accReimSettingLimitRuleQuery = new AccReimSettingLimitRuleQuery();
        accReimSettingLimitRuleQuery.setReimSettingLimitId(key);
        List accReimSettingLimitRuleVOS = this.accReimSettingLimitRuleService.queryListDynamic(accReimSettingLimitRuleQuery);
        vo.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingLimitVO insert(AccReimSettingLimitPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        AccReimSettingLimitDO entityDo = AccReimSettingLimitConvert.INSTANCE.toDo(payload);
        AccReimSettingLimitVO accReimSettingLimitVO = AccReimSettingLimitConvert.INSTANCE.toVo((AccReimSettingLimitDO)this.accReimSettingLimitRepo.save(entityDo));
        Long id = accReimSettingLimitVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.LODGE_OVERAGE.getCode());
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingDO));
        accReimSettingLimitVO.setAccReimSettingVO(accReimSettingVO);
        List accReimSettingLimitRulePayloadList = payload.getAccReimSettingLimitRulePayloadList();
        accReimSettingLimitRulePayloadList.stream().forEach(e -> e.setReimSettingLimitId(id));
        if (!accReimSettingLimitRulePayloadList.isEmpty()) {
            List<AccReimSettingLimitRuleDO> accReimSettingLimitRuleDOS = AccReimSettingLimitRuleConvert.INSTANCE.toDoList(accReimSettingLimitRulePayloadList);
            List accReimSettingLimitRuleVOS = AccReimSettingLimitRuleConvert.INSTANCE.toVoList(this.accReimSettingLimitRuleRepo.saveAll(accReimSettingLimitRuleDOS));
            accReimSettingLimitVO.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        }
        return accReimSettingLimitVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public AccReimSettingLimitVO update(AccReimSettingLimitPayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        this.accReimSettingService.checkRepeat(accReimSettingPayload);
        List deleteAccReimSettingOverdueDiscuntKeys = payload.getDeleteAccReimSettingLimitRuleKeys();
        if (!CollectionUtils.isEmpty((Collection)deleteAccReimSettingOverdueDiscuntKeys)) {
            this.accReimSettingLimitRuleDAO.deleteSoft(deleteAccReimSettingOverdueDiscuntKeys);
        }
        AccReimSettingLimitDO entity = this.accReimSettingLimitRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingLimitDO entityDo = AccReimSettingLimitConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingLimitVO accReimSettingLimitVO = AccReimSettingLimitConvert.INSTANCE.toVo((AccReimSettingLimitDO)this.accReimSettingLimitRepo.save(entity));
        AccReimSettingDO accReimSettingEntity = this.accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull((Object)accReimSettingEntity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo((AccReimSettingDO)this.accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingLimitVO.setAccReimSettingVO(accReimSettingVO);
        List accReimSettingLimitRulePayloadList = payload.getAccReimSettingLimitRulePayloadList();
        if (!accReimSettingLimitRulePayloadList.isEmpty()) {
            List<AccReimSettingLimitRuleDO> accReimSettingLimitRuleDOS = AccReimSettingLimitRuleConvert.INSTANCE.toDoList(accReimSettingLimitRulePayloadList);
            ArrayList<AccReimSettingLimitRuleVO> accReimSettingLimitRuleVOS = new ArrayList<AccReimSettingLimitRuleVO>();
            for (AccReimSettingLimitRuleDO accReimSettingLimitRuleDO : accReimSettingLimitRuleDOS) {
                if (accReimSettingLimitRuleDO.getId() != null) {
                    AccReimSettingLimitRuleDO accReimSettingLimitRuleEntity = this.accReimSettingLimitRuleRepo.findById(accReimSettingLimitRuleDO.getId()).orElseGet(AccReimSettingLimitRuleDO::new);
                    Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
                    accReimSettingLimitRuleEntity.copy(accReimSettingLimitRuleDO);
                    accReimSettingLimitRuleVOS.add(AccReimSettingLimitRuleConvert.INSTANCE.toVo((AccReimSettingLimitRuleDO)this.accReimSettingLimitRuleRepo.save(accReimSettingLimitRuleEntity)));
                    continue;
                }
                accReimSettingLimitRuleDO.setReimSettingLimitId(payload.getId());
                accReimSettingLimitRuleVOS.add(AccReimSettingLimitRuleConvert.INSTANCE.toVo((AccReimSettingLimitRuleDO)this.accReimSettingLimitRuleRepo.save(accReimSettingLimitRuleDO)));
            }
            accReimSettingLimitVO.setAccReimSettingLimitRuleVOList(accReimSettingLimitRuleVOS);
        }
        return accReimSettingLimitVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AccReimSettingLimitPayload payload) {
        AccReimSettingLimitDO entity = this.accReimSettingLimitRepo.findById(payload.getId()).orElseGet(AccReimSettingLimitDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.accReimSettingLimitDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accReimSettingLimitDAO.deleteSoft(keys);
        }
    }

    public AccReimSettingLimitVO ruleCheck(Long key, Long reimUserId, BigDecimal reimAmt, String expensePlaceGrade) {
        List idList;
        expensePlaceGrade = expensePlaceGrade == null ? "3" : expensePlaceGrade;
        AccReimSettingLimitVO accReimSettingLimitVO = this.queryByKey(key);
        AccReimSettingVO accReimSettingVO = accReimSettingLimitVO.getAccReimSettingVO();
        String whiteList = accReimSettingVO.getWhiteList();
        if (StringUtils.hasText((String)whiteList) && (idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList())).contains(reimUserId)) {
            return accReimSettingLimitVO;
        }
        PrdOrgEmployeeVO employeeVO = this.employeeService.queryByUserId(reimUserId);
        String professionalGrade = employeeVO.getExtString1();
        String manageGrade = employeeVO.getExtString2();
        List accReimSettingLimitRuleVOList = accReimSettingLimitVO.getAccReimSettingLimitRuleVOList();
        for (AccReimSettingLimitRuleVO accReimSettingLimitRuleVO : accReimSettingLimitRuleVOList) {
            List collect;
            boolean thisSetting = false;
            if (StringUtils.hasText((String)manageGrade) && StringUtils.hasText((String)accReimSettingLimitRuleVO.getManageGrade())) {
                collect = Arrays.stream(accReimSettingLimitRuleVO.getManageGrade().split(",")).collect(Collectors.toList());
                if (collect.contains(manageGrade)) {
                    thisSetting = true;
                }
            } else if (StringUtils.hasText((String)professionalGrade) && StringUtils.hasText((String)accReimSettingLimitRuleVO.getProfessionalGrade()) && (collect = Arrays.stream(accReimSettingLimitRuleVO.getProfessionalGrade().split(",")).collect(Collectors.toList())).contains(professionalGrade)) {
                thisSetting = true;
            }
            if (!thisSetting) continue;
            BigDecimal limit = BigDecimal.ZERO;
            switch (expensePlaceGrade) {
                case "1": {
                    limit = accReimSettingLimitRuleVO.getMegacitiesLimit();
                    break;
                }
                case "2": {
                    limit = accReimSettingLimitRuleVO.getFirstTierCityLimit();
                    break;
                }
                case "3": {
                    limit = accReimSettingLimitRuleVO.getOtherLimit();
                }
            }
            accReimSettingLimitVO.setReimLimit(limit);
            if (reimAmt.compareTo(limit) <= 0) break;
            accReimSettingLimitVO.setExcessLimit(Boolean.valueOf(true));
            if (accReimSettingVO.getRemindText() != null) {
                accReimSettingVO.setRemindText(accReimSettingVO.getRemindText().replace("#{1}", limit.toString()));
            }
            if (accReimSettingVO.getErrorText() == null) break;
            accReimSettingVO.setErrorText(accReimSettingVO.getErrorText().replace("#{1}", limit.toString()));
            break;
        }
        return accReimSettingLimitVO;
    }

    public AccReimSettingLimitServiceImpl(AccReimSettingLimitRepo accReimSettingLimitRepo, AccReimSettingLimitDAO accReimSettingLimitDAO, AccReimSettingService accReimSettingService, AccReimSettingRepo accReimSettingRepo, AccReimSettingLimitRuleService accReimSettingLimitRuleService, AccReimSettingLimitRuleRepo accReimSettingLimitRuleRepo, AccReimSettingLimitRuleDAO accReimSettingLimitRuleDAO, PrdOrgEmployeeService employeeService) {
        this.accReimSettingLimitRepo = accReimSettingLimitRepo;
        this.accReimSettingLimitDAO = accReimSettingLimitDAO;
        this.accReimSettingService = accReimSettingService;
        this.accReimSettingRepo = accReimSettingRepo;
        this.accReimSettingLimitRuleService = accReimSettingLimitRuleService;
        this.accReimSettingLimitRuleRepo = accReimSettingLimitRuleRepo;
        this.accReimSettingLimitRuleDAO = accReimSettingLimitRuleDAO;
        this.employeeService = employeeService;
    }
}

