/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalSettlePricePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalSettlePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalSettlePriceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalSettlePriceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalSettlePriceConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalSettlePriceDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalSettlePriceDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalSettlePriceRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CalSettlePriceServiceImpl
extends BaseServiceImpl
implements CalSettlePriceService {
    private static final Logger log = LoggerFactory.getLogger(CalSettlePriceServiceImpl.class);
    private final CalSettlePriceRepo calSettlePriceRepo;
    private final CalSettlePriceDAO calSettlePriceDAO;

    public PagingVO<CalSettlePriceVO> queryPaging(CalSettlePriceQuery query) {
        PagingVO<CalSettlePriceVO> CalSettlePriceVOPagingVO = this.calSettlePriceDAO.queryPaging(query);
        if (CalSettlePriceVOPagingVO.getTotal() > 0L) {
            CalSettlePriceVOPagingVO.getRecords().forEach(this::translateData);
        }
        return CalSettlePriceVOPagingVO;
    }

    public List<CalSettlePriceVO> queryListDynamic(CalSettlePriceQuery query) {
        return this.calSettlePriceDAO.queryListDynamic(query);
    }

    public CalSettlePriceVO queryByKey(Long key) {
        CalSettlePriceVO CalSettlePriceVO2 = this.calSettlePriceDAO.queryByKey(key);
        this.translateData(CalSettlePriceVO2);
        return CalSettlePriceVO2;
    }

    void translateData(CalSettlePriceVO CalSettlePriceVO2) {
        if (CalSettlePriceVO2.getFinYear() != null && CalSettlePriceVO2.getFinPeriod() != null) {
            String finPeriodName = CalSettlePriceVO2.getFinYear() + "-" + (CalSettlePriceVO2.getFinPeriod() > 9 ? "" + CalSettlePriceVO2.getFinPeriod() : "0" + CalSettlePriceVO2.getFinPeriod());
            CalSettlePriceVO2.setFinPeriodName(finPeriodName);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CalSettlePriceVO insertOrUpdate(CalSettlePricePayload payload) {
        this.checkDate(payload);
        CalSettlePriceDO entityDo = CalSettlePriceConvert.INSTANCE.toDo(payload);
        return CalSettlePriceConvert.INSTANCE.toVo((CalSettlePriceDO)this.calSettlePriceRepo.save(entityDo));
    }

    void checkDate(CalSettlePricePayload payload) {
        if (payload.getFinPeriod() != null && payload.getFinYear() == null) {
            throw TwException.error("", "\u671f\u95f4\u5b58\u5728\uff0c\u5e74\u5ea6\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.hasText((String)payload.getJobType2()) && !StringUtils.hasText((String)payload.getJobType1())) {
            throw TwException.error("", "\u5de5\u79cd\u5b50\u7c7b\u5b58\u5728\uff0c\u5de5\u79cd\u4e0d\u53ef\u4e3a\u7a7a");
        }
        CalSettlePriceQuery CalSettlePriceQuery2 = CalSettlePriceConvert.INSTANCE.toQuery(payload);
        List<Long> longs = this.calSettlePriceDAO.queryCheckData(CalSettlePriceQuery2);
        if (!(ObjectUtils.isEmpty(longs) || payload.getId() != null && longs.size() <= 1 && longs.get(0).equals(payload.getId()))) {
            throw TwException.error("", "\u5b58\u5728\u76f8\u540c\u7ed3\u7b97\u5b9a\u4ef7");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.calSettlePriceDAO.deleteSoft(keys);
        }
    }

    public CalSettlePriceVO getSettlePricePlus(CalSettlePriceQuery query) {
        return this.calSettlePriceDAO.getSettlePricePlus(query);
    }

    public CalSettlePriceServiceImpl(CalSettlePriceRepo calSettlePriceRepo, CalSettlePriceDAO calSettlePriceDAO) {
        this.calSettlePriceRepo = calSettlePriceRepo;
        this.calSettlePriceDAO = calSettlePriceDAO;
    }
}

