/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.ability.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdAbilityLevelPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdIndividAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdIndividAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdAbilityLevelService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdIndividAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdIndividAbilityVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.dao.PrdIndividAbilityDao;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdIndividAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.repo.PrdIndividAbilityRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdIndividAbilityConvert;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdIndividAbilityServiceImpl
implements PrdIndividAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PrdIndividAbilityServiceImpl.class);
    private final PrdIndividAbilityDao prdIndividAbilityDao;
    private final PrdIndividAbilityRepo prdIndividAbilityRepo;
    private final PrdAbilityLevelService prdAbilityLevelService;

    @Transactional(rollbackFor={Exception.class})
    public PrdIndividAbilityVO save(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        PrdIndividAbilityQuery prdIndividAbilityQuery;
        this.checkData(prdIndividAbilityPayload);
        if (CollUtil.isNotEmpty((Collection)prdIndividAbilityPayload.getPrdAbilityLevelPayloadList())) {
            List levelList = prdIndividAbilityPayload.getPrdAbilityLevelPayloadList().stream().map(x -> x.getLevelDtlId()).collect(Collectors.toList());
            HashSet levelSet = new HashSet(levelList);
            if (levelList.size() != levelSet.size()) {
                throw new BusinessException("\u7ea7\u522b\u5b9a\u4e49\u660e\u7ec6\u4e0d\u80fd\u91cd\u590d");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(prdIndividAbilityQuery = new PrdIndividAbilityQuery()).getDocNo())) {
            prdIndividAbilityQuery.setDocNo(prdIndividAbilityPayload.getDocNo());
            Long count = this.prdIndividAbilityDao.count(prdIndividAbilityQuery);
            if (count > 0L) {
                throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        PrdIndividAbilityDO prdIndividAbilityDO = new PrdIndividAbilityDO();
        prdIndividAbilityDO = PrdIndividAbilityConvert.INSTANCE.p2d(prdIndividAbilityPayload);
        PrdIndividAbilityDO res = (PrdIndividAbilityDO)((Object)this.prdIndividAbilityRepo.save((Object)prdIndividAbilityDO));
        if (CollUtil.isNotEmpty((Collection)prdIndividAbilityPayload.getPrdAbilityLevelPayloadList())) {
            for (PrdAbilityLevelPayload prdAbilityLevelPayload : prdIndividAbilityPayload.getPrdAbilityLevelPayloadList()) {
                prdAbilityLevelPayload.setAbilityId(res.getId());
                prdAbilityLevelPayload.setType(Integer.valueOf(1));
                this.prdAbilityLevelService.save(prdAbilityLevelPayload);
            }
        }
        return PrdIndividAbilityConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdIndividAbilityVO update(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        Assert.notNull((Object)prdIndividAbilityPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        this.prdAbilityLevelService.delByAbilitId(prdIndividAbilityPayload.getId());
        PrdIndividAbilityVO res = this.save(prdIndividAbilityPayload);
        return res;
    }

    public PrdIndividAbilityVO get(Long id) {
        PrdIndividAbilityVO res;
        if (null == id) {
            return null;
        }
        res.setLevelFlag(Boolean.valueOf(null != (res = this.prdIndividAbilityDao.get(id)).getLevelId()));
        PrdAbilityLevelQuery prdAbilityLevelQuery = new PrdAbilityLevelQuery();
        prdAbilityLevelQuery.setType(Integer.valueOf(1));
        prdAbilityLevelQuery.setAbilityId(id);
        List levelDtl = this.prdAbilityLevelService.getList(prdAbilityLevelQuery);
        res.setPrdAbilityLevelVOList(levelDtl);
        return res;
    }

    public PagingVO<PrdIndividAbilityVO> page(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        PagingVO<PrdIndividAbilityVO> res = this.prdIndividAbilityDao.page(prdIndividAbilityQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.prdIndividAbilityDao.del(ids);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateShow(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        Assert.notNull((Object)prdIndividAbilityPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)prdIndividAbilityPayload.getShowFlag(), (String)"showflag\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdIndividAbilityDao.updateShow(prdIndividAbilityPayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateState(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        Assert.notNull((Object)prdIndividAbilityPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)prdIndividAbilityPayload.getState(), (String)"state\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.prdIndividAbilityDao.updateState(prdIndividAbilityPayload);
        return res;
    }

    public PagingVO<PrdIndividAbilityVO> levelPage(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        prdIndividAbilityQuery.setState(Integer.valueOf(1));
        PagingVO<PrdIndividAbilityVO> res = this.prdIndividAbilityDao.levelPage(prdIndividAbilityQuery);
        return res;
    }

    private void checkData(PrdIndividAbilityPayload prdIndividAbilityPayload) {
        if (null == prdIndividAbilityPayload.getState()) {
            throw new BusinessException("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdIndividAbilityPayload.getName())) {
            throw new BusinessException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)prdIndividAbilityPayload.getCateType1())) {
            throw new BusinessException("\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<PrdIndividAbilityVO> levelList(PrdIndividAbilityQuery prdIndividAbilityQuery) {
        prdIndividAbilityQuery.setState(Integer.valueOf(1));
        List<PrdIndividAbilityVO> res = this.prdIndividAbilityDao.levelList(prdIndividAbilityQuery);
        return res;
    }

    public PrdIndividAbilityServiceImpl(PrdIndividAbilityDao prdIndividAbilityDao, PrdIndividAbilityRepo prdIndividAbilityRepo, PrdAbilityLevelService prdAbilityLevelService) {
        this.prdIndividAbilityDao = prdIndividAbilityDao;
        this.prdIndividAbilityRepo = prdIndividAbilityRepo;
        this.prdAbilityLevelService = prdAbilityLevelService;
    }
}

