/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.callback;

import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.EmployeeDepartApplyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/RES_DEPART/callBack"})
@Transactional
public class EmployeeDepartWorkFlowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(EmployeeDepartWorkFlowCallBackController.class);
    private final EmployeeDepartApplyDAO departApplyDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final SysUserRpcService userRpcService;
    private final UserVacationService userVacationService;
    private final ResEntryExitLogService entryExitLogService;
    private final PrdOrgEmployeeService employeeService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        EmployeeDepartPayload employeeDepartPayload = new EmployeeDepartPayload();
        employeeDepartPayload.setId(applyId);
        EmployeeDepartApplyVO departApplyVO = this.departApplyDAO.queryByKey(applyId);
        Long employeeId = departApplyVO.getEmployeeId();
        switch (procInstStatus) {
            case NOTSUBMIT: {
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                this.employeeDAO.updateResStatus(employeeId, "3");
                break;
            }
            case INTERRUPT: {
                employeeDepartPayload.setProcInstStatus(null);
                employeeDepartPayload.setProcInstId(null);
                employeeDepartPayload.setDeleteFlag(Integer.valueOf(1));
                this.employeeDAO.updateResStatus(employeeId, "3");
            }
            case INVALID: {
                employeeDepartPayload.setProcInstStatus(null);
                employeeDepartPayload.setProcInstId(null);
                employeeDepartPayload.setDeleteFlag(Integer.valueOf(1));
                this.employeeDAO.updateResStatus(employeeId, "3");
                break;
            }
            case REJECTED: {
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                this.employeeDAO.updateResStatus(employeeId, "3");
                break;
            }
            case APPROVED: {
                PrdOrgEmployeeVO prdOrgEmployeeVO = this.employeeDAO.queryByKey(employeeId);
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                employeeDepartPayload.setApprovedTime(LocalDateTime.now());
                this.employeeDAO.updateResStatus(employeeId, "6");
                SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
                ArrayList<Long> userIds = new ArrayList<Long>();
                userIds.add(prdOrgEmployeeVO.getUserId());
                sysUserBatchSwitchParam.setEnable(false);
                sysUserBatchSwitchParam.setUserIds(userIds);
                this.userRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
                this.userVacationService.deleteAllByUserId(prdOrgEmployeeVO.getUserId());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate exitDate = LocalDate.parse(departApplyVO.getContractEndDate(), formatter);
                this.employeeDAO.updateExitDate(employeeId, exitDate);
                ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
                resEntryExitLogPayload.setEmployeeId(employeeId);
                resEntryExitLogPayload.setEntryExitDate(departApplyVO.getContractEndDate());
                resEntryExitLogPayload.setReasonType1("RES_LEAVE_APPLY");
                resEntryExitLogPayload.setReasonType2("LEAVE");
                resEntryExitLogPayload.setResType(prdOrgEmployeeVO.getExtString6());
                resEntryExitLogPayload.setBookId(prdOrgEmployeeVO.getBookId());
                resEntryExitLogPayload.setOrgId(prdOrgEmployeeVO.getOrgId());
                resEntryExitLogPayload.setBaseCity(prdOrgEmployeeVO.getExtString5());
                resEntryExitLogPayload.setCoopType(prdOrgEmployeeVO.getCooperationMode());
                resEntryExitLogPayload.setJob(prdOrgEmployeeVO.getJobs());
                resEntryExitLogPayload.setLeaveReason(departApplyVO.getHrLeaveDescCode());
                resEntryExitLogPayload.setLeaveReasonDesc(departApplyVO.getHrReason());
                this.entryExitLogService.save(resEntryExitLogPayload);
                this.employeeService.deleteOrgRefSoftAll(prdOrgEmployeeVO.getUserId(), exitDate);
                break;
            }
            case APPROVING: {
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
        }
        this.departApplyDAO.updateProcData(employeeDepartPayload);
        return WorkflowResult.success(null);
    }

    public EmployeeDepartWorkFlowCallBackController(EmployeeDepartApplyDAO departApplyDAO, PrdOrgEmployeeDAO employeeDAO, SysUserRpcService userRpcService, UserVacationService userVacationService, ResEntryExitLogService entryExitLogService, PrdOrgEmployeeService employeeService) {
        this.departApplyDAO = departApplyDAO;
        this.employeeDAO = employeeDAO;
        this.userRpcService = userRpcService;
        this.userVacationService = userVacationService;
        this.entryExitLogService = entryExitLogService;
        this.employeeService = employeeService;
    }
}

