/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.my.payload.PwdForgotPayload;
import com.elitesland.tw.tw5.api.prd.my.service.PrdOrgEmployeeConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsConContractService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemProblemFeedbackService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.Bangwo8Signature;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import com.elitesland.tw.tw5.server.common.util.JavaMailUtil;
import com.elitesland.tw.tw5.server.common.util.RsaEncrypt;
import com.elitesland.tw.tw5.server.common.util.SpelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RemindTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskEvalStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.PrdUserRemindDO;
import com.elitesland.tw.tw5.server.prd.qixin.config.QiXinProperties;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@RefreshScope
public class PrdUserServiceImpl
implements PrdUserService {
    private static final Logger log = LoggerFactory.getLogger(PrdUserServiceImpl.class);
    private final PrdUserDAO dao;
    private final CrmCustomerOperationChanceDAO customerOperationChanceDAO;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
    private final PrdSystemProblemFeedbackService prdSystemProblemFeedbackService;
    private final CrmActActivityService activityservice;
    @Autowired
    private CrmLeadsService crmLeadsService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final VisitTaskDAO visitTaskDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PmsConContractService conContractService;
    private final PmsResourcePlanService pmsResourcePlanService;
    private final PmsProjectService pmsProjectService;
    private final PrdOrgEmployeeEqvaRatioService eqvaRatioService;
    private final TaskInfoService taskInfoService;
    private final ConReceivablePlanService receivablePlanService;
    private final SaleConExecConditionService saleConExecConditionService;
    @Autowired
    private SysUserRpcService sysUserService;
    private static final Integer CODE_LEN = 6;
    private static final int MIN_STRENGTH = 5;
    private final JavaMailUtil mailHelper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value(value="${bangwo8.url:xxx}")
    private String bangwo8Url;
    @Value(value="${bangwo8.key:xxx}")
    private String bangwo8Key;
    @Value(value="${bangwo8.aid:xxx}")
    private String aid;
    @Value(value="${bangwo8.api.login:xxx}")
    private String loginUrl;
    @Value(value="${bangwo8.authaccount:xxx}")
    private String authaccount;
    @Value(value="${bangwo8.private_key:xxx}")
    private String privateKey;
    @Value(value="${bangwo8.api.ticket:xxx}")
    private String ticketUrl;
    @Value(value="${report.publicKey:xxx}")
    private String reportPublicKey;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final QiXinProperties qiXinProperties;
    private final BusinessPartnerService businessPartnerService;
    private final CalAccountService calAccountService;
    private final PrdPerformanceExamResultService prdPerformanceExamResultService;
    private final PrdOrgEmployeeConfigService prdOrgEmployeeConfigService;
    private final PrdSystemShortcutService prdSystemShortcutService;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";

    @Transactional
    public PrdUserDataVO queryUserDetail() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = this.dao.queryUserDetail(userId);
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setOrgRoles(this.dao.queryRolesById("" + userId));
        vo.setParentName(this.cacheUtil.getUserName(vo.getParentId()));
        String ticket = UUID.randomUUID().toString();
        vo.setTicket(new String(Base64.encodeBase64((byte[])ticket.getBytes())));
        List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(userId);
        vo.setRoleCodes(new HashSet<String>(userSystemRoleCodes));
        vo.setQxBEnabled(this.qiXinProperties.getEnabled());
        this.transferSystemSelection(vo);
        this.dao.updateTicket(vo.getId(), ticket);
        CalAccountVO calAccountVO = this.calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.RES.getCode(), userId);
        vo.setTotalAmt(calAccountVO.getTotalAmt());
        vo.setTotalQty(calAccountVO.getTotalQty());
        vo.setAvalQty(calAccountVO.getAvalQty());
        LocalDate today = LocalDate.now();
        LocalDate firstDay = today.with(TemporalAdjusters.firstDayOfYear());
        LocalDate lastDay = today.with(TemporalAdjusters.lastDayOfYear());
        BigDecimal eqvaRatio = this.eqvaRatioService.getEqvaRatio(userId, today);
        vo.setEqvaRatio(eqvaRatio);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdUserDataVO getUserInfoBase() {
        Long userId = GlobalUtil.getLoginUserId();
        PrdUserDataVO vo = this.dao.queryUserDetail(userId);
        vo.setUserId(userId);
        vo.setOrgRoles(this.dao.queryRolesById("" + userId));
        vo.setSystemRoles(this.cacheUtil.getSystemRoleCodes(userId));
        this.transferSystemSelection(vo);
        vo.setWorkflowEnabled(this.workflow_enabled);
        vo.setQxBEnabled(this.qiXinProperties.getEnabled());
        return vo;
    }

    @Transactional
    public Long updateShortcut(String shortcutIds) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.updateShortcut(userId, shortcutIds);
    }

    public void updatePassword(String oldPassword, String newPassword) {
        if (!StringUtils.hasText((String)oldPassword) || !StringUtils.hasText((String)newPassword)) {
            throw TwException.error("", "\u65e0\u6548\u7684\u5bc6\u7801");
        }
        Long userId = GlobalUtil.getLoginUserId();
        this.sysUserService.changePasswordNoSec(GlobalUtil.getLoginUserId(), newPassword);
    }

    public List<TwRecentWorkVO> findMyWork() {
        Long userId = GlobalUtil.getLoginUserId();
        ArrayList<TwRecentWorkVO> recentWorkVOList = new ArrayList<TwRecentWorkVO>();
        this.customerOperationChance(recentWorkVOList, userId);
        this.activityRelease(recentWorkVOList, userId);
        this.problemFeedback(recentWorkVOList, userId);
        this.leadsToReceive(recentWorkVOList, userId);
        this.leadsToDistribute(recentWorkVOList, userId);
        this.operationPlanDetail(recentWorkVOList, userId);
        this.visitTask(recentWorkVOList, userId);
        this.visitTaskEval(recentWorkVOList, userId);
        this.confilmedCustomer(recentWorkVOList);
        this.resourcePlanNotice(recentWorkVOList, userId);
        this.projectBriefWork(recentWorkVOList, userId);
        this.queryProjectUpdateBudgetWorkCount(recentWorkVOList, userId);
        this.taskAcceptance(recentWorkVOList, userId);
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_PRJ_ACCOUNTANT.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            this.recycleSettle(recentWorkVOList);
        }
        this.contractBudgetPersonPlan(recentWorkVOList, userId);
        return recentWorkVOList;
    }

    public List<PrdUserRemindVO> findMyRemind() {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        ArrayList<PrdUserRemindVO> resRemindVOS = new ArrayList<PrdUserRemindVO>();
        List<PrdUserRemindVO> remindVOS = this.dao.queryReminds(userId);
        for (PrdUserRemindVO remindVO : remindVOS) {
            Map objectMap;
            Long num;
            String remindContent;
            HashMap<String, Long> map;
            long num2;
            if (remindVO.getNoRemindDate() != null && remindVO.getNoRemindDate().equals(newDate)) continue;
            String remindType = remindVO.getRemindType();
            if (remindType.equals(RemindTypeEnum.RECEIVED_LEAD.getCode()) && (num2 = this.crmLeadsService.countNotReceivedLeadsByUserId(userId.longValue())) > 0L) {
                map = new HashMap<String, Long>();
                map.put("num", num2);
                remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
                remindVO.setRemindContent(remindContent);
                resRemindVOS.add(remindVO);
            }
            if (!remindType.equals(RemindTypeEnum.ACTIVITY_UNRELEASE.getCode()) || (num = (Long)(objectMap = this.activityservice.findActivityUnReleaseByUserId(userId.longValue())).get("num")) <= 0L) continue;
            map = new HashMap();
            map.put("num", num);
            remindContent = SpelUtil.parseStringExpression(remindVO.getRemindContent(), map);
            remindVO.setRemindContent(remindContent);
            remindVO.setSurplusTime("" + objectMap.get("time"));
            resRemindVOS.add(remindVO);
        }
        return resRemindVOS;
    }

    @Transactional
    public Boolean updateMyRemind(String remindType) {
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate newDate = LocalDate.now();
        PrdUserRemindDO userRemindDO = this.dao.queryUserRemind(userId, remindType);
        if (userRemindDO == null) {
            userRemindDO = new PrdUserRemindDO();
            userRemindDO.setRemindType(remindType);
            userRemindDO.setUserId(userId);
        }
        userRemindDO.setNoRemindDate(newDate);
        this.dao.saveUserRemind(userRemindDO);
        return true;
    }

    public void queryUserByTicket(HttpServletRequest request, HttpServletResponse response) {
        String ticket = request.getParameter("ticket");
        if (ticket != null && !ticket.isEmpty()) {
            ticket = new String(Base64.decodeBase64((byte[])ticket.getBytes()));
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JSONObject jsonObject = null;
        HttpSession session = request.getSession();
        PrdUserDataVO info = this.dao.queryUserByTicket(ticket);
        try {
            if (info == null) {
                paramMap.put("el-result-cod", "NG_UNSUPPORTED");
                paramMap.put("statusCode", "401");
                jsonObject = new JSONObject(paramMap);
                response.setStatus(401);
                session.setAttribute("paramMap", paramMap);
            }
            paramMap.put("app_login_type", "SSO");
            paramMap.put("app_login_id", info.getId());
            paramMap.put("app_login_email", info.getEmail());
            paramMap.put("app_login_ticket", ticket);
            paramMap.put("el-result-cod", "OK");
            paramMap.put("statusCode", "200");
            jsonObject = new JSONObject(paramMap);
            response.setStatus(200);
            session.setAttribute("paramMap", paramMap);
            response.getWriter().print(jsonObject);
        }
        catch (NullPointerException e) {
            try {
                response.getWriter().print(jsonObject);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getBangwo8Sign() {
        Object loginName = "";
        try {
            SysUserDTO loginUser = GlobalUtil.getLoginUser();
            String[] split = loginUser.getEmail().split("\\.");
            loginName = split[0] + split[1].split("@")[0];
        }
        catch (Exception e) {
            TwException.error("", "\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff01");
        }
        long currentTime = System.currentTimeMillis() / 1000L - 300L;
        String message = this.aid + (String)loginName + currentTime + this.bangwo8Key;
        String sign = DigestUtils.md5DigestAsHex((byte[])message.getBytes());
        String url = String.join((CharSequence)"", new CharSequence[]{this.bangwo8Url, this.loginUrl, "?aid=", this.aid, "&loginname=", loginName, "&type=0&time=", String.valueOf(currentTime), "&sign=", sign});
        return url;
    }

    public String getBangwo8LoginFreeSign() {
        String nonce = "123456";
        String timestamp = String.valueOf(System.currentTimeMillis());
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("authaccount", this.authaccount);
        map.put("private_key", this.privateKey);
        map.put("timestamp", timestamp);
        map.put("nonce", nonce);
        String sign = Bangwo8Signature.makeSignature(map);
        return String.join((CharSequence)"", this.bangwo8Url, this.ticketUrl, "&nonce=", nonce, "&timestamp=", timestamp, "&signature=", sign, "&authaccount=", this.authaccount);
    }

    public String getFrSsoToken() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if (ObjectUtils.isEmpty((Object)loginUser)) {
            throw TwException.error("", "\u767b\u5f55\u5931\u8d25,\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        String encrypt = RsaEncrypt.encrypt(loginUser.getEmail(), this.reportPublicKey);
        System.out.println("encrypted username: " + encrypt);
        String encode = "";
        try {
            encode = URLEncoder.encode(encrypt, "UTF-8");
        }
        catch (Exception e) {
            throw TwException.error("", e.toString());
        }
        log.debug("\u52a0\u5bc6\u540e\u7684\u503c\u4e3a\uff1a\uff1a" + encode);
        return encode;
    }

    public void captcha2Email(String email, String type) {
        String captchaCode;
        long currentTime = System.currentTimeMillis();
        String captchaAndTimestamp = (String)this.redisTemplate.opsForValue().get((Object)(type + email));
        if (StringUtils.hasText((String)captchaAndTimestamp)) {
            String[] split = captchaAndTimestamp.split("=");
            captchaCode = split[0];
            long timestamp = Long.parseLong(split[1]);
            if (currentTime - timestamp > 300000L) {
                captchaCode = RandomUtil.randomStringUpper((int)CODE_LEN);
                this.redisTemplate.opsForValue().set((Object)(type + email), (Object)(captchaCode + "=" + currentTime), 5L, TimeUnit.MINUTES);
            }
        } else {
            captchaCode = RandomUtil.randomStringUpper((int)CODE_LEN);
            this.redisTemplate.opsForValue().set((Object)(type + email), (Object)(captchaCode + "=" + currentTime), 5L, TimeUnit.MINUTES);
        }
        StringBuilder msgContent = new StringBuilder("<html><body>");
        msgContent.append("\u5c0a\u656c\u7684\u7528\u6237\uff0c<br>");
        msgContent.append("\u60a8\u597d\uff01\u6211\u4eec\u6ce8\u610f\u5230\u60a8\u6700\u8fd1\u5728\u627e\u56de\u5bc6\u7801\u65b9\u9762\u9047\u5230\u4e86\u4e00\u4e9b\u95ee\u9898\u3002\u4e3a\u4e86\u786e\u4fdd\u60a8\u7684\u8d26\u6237\u5b89\u5168\uff0c\u6211\u4eec\u7279\u522b\u4e3a\u60a8\u63d0\u4f9b\u4e86\u4ee5\u4e0b\u9a8c\u8bc1\u7801\u4ee5\u4f9b\u9a8c\u8bc1\u8eab\u4efd\u3002\u8bf7\u5728\u627e\u56de\u5bc6\u7801\u9875\u9762\u8f93\u5165\u4ee5\u4e0b\u9a8c\u8bc1\u7801\uff1a<br>");
        msgContent.append("\u9a8c\u8bc1\u7801\uff1a<a style=\"color: red;font-size: 20px;\"> [").append(captchaCode).append("]</a><br>");
        msgContent.append("\u6b64\u9a8c\u8bc1\u7801\u5c06\u5728\u63a5\u6536\u90ae\u4ef6\u540e\u7684").append("<a style=\"font-size: 20px;\">").append(" 5\u5206\u949f ").append("</a>\u5185\u6709\u6548\uff0c\u8bf7\u60a8\u5c3d\u5feb\u4f7f\u7528\u3002<br>");
        msgContent.append("\u4e3a\u4e86\u4fdd\u62a4\u60a8\u7684\u8d26\u6237\u5b89\u5168\uff0c\u8bf7\u6ce8\u610f\u4ee5\u4e0b\u51e0\u70b9\uff1a<br>");
        msgContent.append("<p style=\"text-indent: 20px;\">\u4e0d\u8981\u6cc4\u9732\u9a8c\u8bc1\u7801\uff1a \u8bf7\u52ff\u5c06\u6b64\u9a8c\u8bc1\u7801\u900f\u9732\u7ed9\u4efb\u4f55\u4eba\uff0c\u5305\u62ec\u6211\u4eec\u7684\u5ba2\u670d\u4eba\u5458\u3002\u6211\u4eec\u7edd\u4e0d\u4f1a\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u6216\u7535\u8bdd\u7d22\u53d6\u6b64\u9a8c\u8bc1\u7801\u3002</p>");
        msgContent.append("<p style=\"text-indent: 20px;\">\u9632\u8303\u9493\u9c7c\u7f51\u7ad9\uff1a \u8bf7\u59cb\u7ec8\u901a\u8fc7\u6211\u4eec\u5b98\u65b9\u7f51\u7ad9\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e\u64cd\u4f5c\uff0c\u907f\u514d\u53d7\u5230\u9493\u9c7c\u7f51\u7ad9\u7684\u6b3a\u9a97\u3002</p>");
        msgContent.append("\u5982\u679c\u60a8\u6ca1\u6709\u5c1d\u8bd5\u627e\u56de\u5bc6\u7801\uff0c\u8bf7\u5ffd\u7565\u6b64\u90ae\u4ef6\u3002\u5982\u679c\u60a8\u6709\u4efb\u4f55\u7591\u95ee\u6216\u9700\u8981\u5e2e\u52a9\uff0c\u8bf7\u968f\u65f6\u8054\u7cfb\u6211\u4eec\u7684\u5ba2\u670d\u56e2\u961f\u3002<br>");
        msgContent.append("\u518d\u6b21\u611f\u8c22\u60a8\u5bf9\u6211\u4eec\u7684\u4fe1\u4efb\u548c\u652f\u6301\uff01<br>");
        msgContent.append("\u6cf0\u5217\u6c83\u514b\u4e8b\u4e1a\u90e8\u795d\u60a8\u4e00\u5207\u987a\u5229\uff01</body></html>");
        JavaMailPayload mailPayload = new JavaMailPayload();
        mailPayload.setReceiveEmail(email);
        mailPayload.setSubject("\u5bc6\u7801\u91cd\u7f6e\u9a8c\u8bc1\u7801\u53ca\u5b89\u5168\u63d0\u9192");
        mailPayload.setText(msgContent.toString());
        this.mailHelper.sendEmailByAdmin(mailPayload);
    }

    public void forgotPwd(PwdForgotPayload payload, String type) {
        List search;
        this.checkForgotPwdParams(payload);
        this.checkPasswordStrength(payload.getNewPwd());
        String captchaAndTimestamp = (String)this.redisTemplate.opsForValue().get((Object)(type + payload.getEmail()));
        if (StringUtils.hasText((String)captchaAndTimestamp) && captchaAndTimestamp.split("=")[0].equals(payload.getCaptchaCode())) {
            SysUserRpcDtoParam param = new SysUserRpcDtoParam();
            param.setEmails(List.of(payload.getEmail()));
            search = this.sysUserService.findUserRpcDtoByParam(param);
            if (CollectionUtils.isEmpty((Collection)search)) {
                throw new BusinessException("\u6839\u636e\u5f53\u524d\u90ae\u7bb1\u672a\u627e\u5230\u7cfb\u7edf\u7528\u6237\u4fe1\u606f");
            }
        } else {
            throw new BusinessException("\u9a8c\u8bc1\u7801\u6821\u9a8c\u9519\u8bef\uff0c\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        }
        SysUserRpcDTO sysUserDTO = (SysUserRpcDTO)search.get(0);
        this.sysUserService.changePasswordNoSec(sysUserDTO.getId(), payload.getNewPwd());
    }

    private void checkForgotPwdParams(PwdForgotPayload payload) {
        Assert.notNull((Object)payload.getNewPwd(), (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getConfirmPwd(), (String)"\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getCaptchaCode(), (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getEmail(), (String)"\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        if (!payload.getNewPwd().equals(payload.getConfirmPwd())) {
            throw new BusinessException("\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01");
        }
    }

    private void checkPasswordStrength(String password) {
        Pattern digits = Pattern.compile("(?=.*[0-9]).*");
        Pattern lcases = Pattern.compile("(?=.*[a-z]).*");
        Pattern ucases = Pattern.compile("(?=.*[A-Z]).*");
        Pattern scases = Pattern.compile("(?=.*[~!@#$%^&*()_-]).*");
        int MIN_LEN = 8;
        int GOOD_LEN = 10;
        int strength = 0;
        if (password.length() >= 8) {
            strength = password.length() >= 10 ? (strength += 2) : ++strength;
            if (digits.matcher(password).matches()) {
                strength += 2;
            }
            if (lcases.matcher(password).matches()) {
                strength += 2;
            }
            if (ucases.matcher(password).matches()) {
                strength += 2;
            }
            if (scases.matcher(password).matches()) {
                strength += 2;
            }
        }
        if (5 > strength) {
            throw new BusinessException("\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u8db3");
        }
    }

    public List<PrdOrgDataRefVO> queryOrgList() {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryOrgListByKey(userId);
    }

    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId) {
        Long userId = GlobalUtil.getLoginUserId();
        return this.dao.queryLowListByKey(orgId, userId);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<PrdSystemMenuVO> queryMenus() {
        List<PrdSystemMenuVO> menuVOS = this.dao.queryUsableList();
        GeneralUserDetails loginGeneralUser = GlobalUtil.getLoginGeneralUser();
        if (loginGeneralUser.isSystemAdmin()) {
            return menuVOS;
        }
        if (loginGeneralUser.isTenantAdmin()) {
            return menuVOS.stream().filter(menuVO_ -> !menuVO_.getPortalRoute().contains("/tenancy")).collect(Collectors.toList());
        }
        List<Long> userMenuIds = this.dao.queryUserMenuIds(loginGeneralUser.getUserId());
        return menuVOS.stream().filter(menuVO -> userMenuIds.indexOf(menuVO.getId()) >= 0).collect(Collectors.toList());
    }

    private void customerOperationChance(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        CrmCustomerOperationChanceQuery query = new CrmCustomerOperationChanceQuery();
        query.setTrackerUserId(Long.valueOf(userId));
        query.setIsRead(Integer.valueOf(0));
        query.setNoPermissionFlag(Boolean.valueOf(true));
        PagingVO<CrmCustomerOperationChanceVO> paging = this.customerOperationChanceDAO.paging(query);
        Long total = paging.getTotal();
        if (total.compareTo(0L) != 0) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u7ecf\u8425\u673a\u4f1a\u70b9\u5f85\u8ddf\u8e2a", (Long)total, (String)TwRecentWorkVO.RecentWorkType.OPERATION_CHANCE_DETAIL.getCode()));
        }
    }

    private void activityRelease(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        Map objectMap = this.activityservice.findActivityUnReleaseByUserId(userId);
        long num = (Long)objectMap.get("num");
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u6d3b\u52a8\u5f85\u53d1\u5e03", (Long)num, (String)TwRecentWorkVO.RecentWorkType.ACTIVITY_RELEASE.getCode()));
        }
    }

    private void problemFeedback(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.prdSystemProblemFeedbackService.findWorkProblemFeedbackByUserId(Long.valueOf(userId));
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u95ee\u9898\u53cd\u9988", (Long)num, (String)TwRecentWorkVO.RecentWorkType.FEED_BACK.getCode()));
        }
    }

    private void leadsToReceive(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.crmLeadsService.countNotReceivedLeadsByUserId(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u5f85\u9886\u53d6\u7ebf\u7d22", (Long)num, (String)TwRecentWorkVO.RecentWorkType.LEADS_TO_RECEIVE.getCode()));
        }
    }

    private void leadsToDistribute(List<TwRecentWorkVO> recentWorkVOList, long userId) {
        long num = this.crmLeadsService.countNotDistributedLeadsByUserId(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u7ebf\u7d22\u5f85\u5206\u914d", (Long)num, (String)TwRecentWorkVO.RecentWorkType.LEADS_TO_DISTRIBUTE.getCode(), (String)"/leadsManager/offshore"));
        }
    }

    private void operationPlanDetail(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        CrmOperationPlanDetailQuery planDetailQuery = new CrmOperationPlanDetailQuery();
        planDetailQuery.setPerformerId(userId);
        planDetailQuery.setReadFlag(Integer.valueOf(0));
        long count = this.crmOperationPlanDetailService.count(planDetailQuery);
        if (count > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u7ecf\u8425\u8ba1\u5212\u5f85\u6267\u884c", (Long)count, (String)TwRecentWorkVO.RecentWorkType.OPERATION_PLAN_DETAIL.getCode(), (String)"/leadsManager/offshore"));
        }
    }

    private void visitTask(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setVisitMemberId(userId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(VisitTaskStatusEnum.NEW.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        long count = this.visitTaskDAO.done(taskQuery);
        if (count > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.VISIT_TASK.getDesc(), (Long)count, (String)TwRecentWorkVO.RecentWorkType.VISIT_TASK.getCode(), (String)"/visit/task"));
        }
    }

    private void visitTaskEval(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.EVAL_TASK_PIC.getCode())).booleanValue()) {
            taskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
            taskQuery.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
            long count = this.visitTaskDAO.count(taskQuery);
            if (count > 0L) {
                recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getDesc(), (Long)count, (String)TwRecentWorkVO.RecentWorkType.VISIT_TASK_EVAL.getCode(), (String)"/visit/task?eval=true"));
            }
        }
    }

    private void confilmedCustomer(List<TwRecentWorkVO> recentWorkVOList) {
        long count;
        if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.POTENTIAL_CUST_CONFIRM.getCode())).booleanValue() && (count = this.businessPartnerService.countConfirmedCustomer().longValue()) > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)"\u5f85\u786e\u8ba4\u6f5c\u5728\u5ba2\u6237", (Long)count, (String)TwRecentWorkVO.RecentWorkType.COMFIRMED_CUSTOMER.getCode()));
        }
    }

    private void contractNotice(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        long num = this.conContractService.findCountByDeliUserId(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.PROJECT_TO_CREATE.getDesc(), (Long)num, (String)TwRecentWorkVO.RecentWorkType.PROJECT_TO_CREATE.getCode()));
        }
    }

    private void resourcePlanNotice(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
    }

    private void taskAcceptance(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        long num = this.taskInfoService.findAcceptCount(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.TASK_ACCEPTANCE.getDesc(), (Long)num, (String)TwRecentWorkVO.RecentWorkType.TASK_ACCEPTANCE.getCode()));
        }
    }

    private void recycleSettle(List<TwRecentWorkVO> recentWorkVOList) {
        ConReceivablePlanQuery conReceivablePlanQuery = new ConReceivablePlanQuery();
        conReceivablePlanQuery.setRecycleSettleFlag(Integer.valueOf(0));
        long num = this.receivablePlanService.countListDynamic(conReceivablePlanQuery);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.RECYCLE_SETTLE.getDesc(), (Long)num, (String)TwRecentWorkVO.RecentWorkType.RECYCLE_SETTLE.getCode(), (String)""));
        }
    }

    private void contractBudgetPersonPlan(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
        long num = this.saleConExecConditionService.queryWorkAgentFlagCount(userId);
        if (num > 0L) {
            recentWorkVOList.add(TwRecentWorkVO.of((String)TwRecentWorkVO.RecentWorkType.CONTRACT_BUDGET_PERSON_PLAN.getDesc(), (Long)num, (String)TwRecentWorkVO.RecentWorkType.CONTRACT_BUDGET_PERSON_PLAN.getCode()));
        }
    }

    void transferSystemSelection(PrdUserDataVO vo) {
        vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
    }

    private void projectBriefWork(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
    }

    private void queryProjectUpdateBudgetWorkCount(List<TwRecentWorkVO> recentWorkVOList, Long userId) {
    }

    public PrdUserServiceImpl(PrdUserDAO dao, CrmCustomerOperationChanceDAO customerOperationChanceDAO, CacheUtil cacheUtil, FileUtil fileUtil, PrdSystemProblemFeedbackService prdSystemProblemFeedbackService, CrmActActivityService activityservice, CrmOperationPlanDetailService crmOperationPlanDetailService, PrdSystemRoleDAO systemRoleDAO, VisitTaskDAO visitTaskDAO, PrdOrgEmployeeService prdOrgEmployeeService, PmsConContractService conContractService, PmsResourcePlanService pmsResourcePlanService, PmsProjectService pmsProjectService, PrdOrgEmployeeEqvaRatioService eqvaRatioService, TaskInfoService taskInfoService, ConReceivablePlanService receivablePlanService, SaleConExecConditionService saleConExecConditionService, JavaMailUtil mailHelper, QiXinProperties qiXinProperties, BusinessPartnerService businessPartnerService, CalAccountService calAccountService, PrdPerformanceExamResultService prdPerformanceExamResultService, PrdOrgEmployeeConfigService prdOrgEmployeeConfigService, PrdSystemShortcutService prdSystemShortcutService) {
        this.dao = dao;
        this.customerOperationChanceDAO = customerOperationChanceDAO;
        this.cacheUtil = cacheUtil;
        this.fileUtil = fileUtil;
        this.prdSystemProblemFeedbackService = prdSystemProblemFeedbackService;
        this.activityservice = activityservice;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.systemRoleDAO = systemRoleDAO;
        this.visitTaskDAO = visitTaskDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.conContractService = conContractService;
        this.pmsResourcePlanService = pmsResourcePlanService;
        this.pmsProjectService = pmsProjectService;
        this.eqvaRatioService = eqvaRatioService;
        this.taskInfoService = taskInfoService;
        this.receivablePlanService = receivablePlanService;
        this.saleConExecConditionService = saleConExecConditionService;
        this.mailHelper = mailHelper;
        this.qiXinProperties = qiXinProperties;
        this.businessPartnerService = businessPartnerService;
        this.calAccountService = calAccountService;
        this.prdPerformanceExamResultService = prdPerformanceExamResultService;
        this.prdOrgEmployeeConfigService = prdOrgEmployeeConfigService;
        this.prdSystemShortcutService = prdSystemShortcutService;
    }
}

