/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceOtherPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceOtherQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceOtherService;
import com.elitesland.tw.tw5.api.prd.my.vo.ResAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceOtherConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceOtherDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceOtherDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceOtherRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class TAttendanceOtherServiceImpl
extends BaseServiceImpl
implements TAttendanceOtherService {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceOtherServiceImpl.class);
    private final TAttendanceOtherRepo tAttendanceOtherRepo;
    private final TAttendanceOtherDAO tAttendanceOtherDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    @Value(value="${tw4.attendance.other}")
    private String attendanceOtherTo5Url;

    public PagingVO<TAttendanceOtherVO> queryPaging(TAttendanceOtherQuery query) {
        return this.tAttendanceOtherDAO.queryPaging(query);
    }

    public List<TAttendanceOtherVO> queryListDynamic(TAttendanceOtherQuery query) {
        return this.tAttendanceOtherDAO.queryListDynamic(query);
    }

    public TAttendanceOtherVO queryByKey(Long key) {
        TAttendanceOtherDO entity = this.tAttendanceOtherRepo.findById(key).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceOtherVO vo = TAttendanceOtherConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceOtherVO insert(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entityDo = TAttendanceOtherConvert.INSTANCE.toDo(payload);
        return TAttendanceOtherConvert.INSTANCE.toVo((TAttendanceOtherDO)((Object)this.tAttendanceOtherRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceOtherVO update(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entity = this.tAttendanceOtherRepo.findById(payload.getId()).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceOtherDO entityDo = TAttendanceOtherConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceOtherConvert.INSTANCE.toVo((TAttendanceOtherDO)((Object)this.tAttendanceOtherRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entity = this.tAttendanceOtherRepo.findById(payload.getId()).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tAttendanceOtherDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tAttendanceOtherDAO.deleteSoft(keys);
        }
    }

    public List<ResAttendanceOtherVO> getAttendanceResOther(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        return this.tAttendanceOtherDAO.getAttendanceResOther(resId, attendanceDateStart, attendanceDateEnd);
    }

    public void attendanceOtherTo5(String param) {
        String syncType = "attendanceOtherTo5";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)("syncVacationApply localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApplyDetail syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        String result = this.httpUtil.sendSyncGet(this.attendanceOtherTo5Url, reqMap);
        Map data = (Map)JSONObject.parse((String)result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map v4AndV5UserIds = this.employeeService.getV4AndV5UserIds();
                Object datum = data.get("datum");
                List attendanceOtherData = (List)datum;
                ArrayList<TAttendanceOtherDO> tAttendanceOtherDOList = new ArrayList<TAttendanceOtherDO>();
                List<Long> tw4AttendanceOtherIds = attendanceOtherData.stream().map(attendanceOther -> (attendanceOther.get("id") == null ? Integer.valueOf(0) : attendanceOther.get("id")).longValue()).collect(Collectors.toList());
                List<TAttendanceOtherDO> oldTAttendanceOtherDOs = this.tAttendanceOtherRepo.selectByIdV4List(tw4AttendanceOtherIds);
                block0: for (TAttendanceOtherDO attendanceOtherDO : oldTAttendanceOtherDOs) {
                    Long attendanceOtherIdV4 = attendanceOtherDO.getAttendanceOtherIdV4();
                    for (Map applyData2 : attendanceOtherData) {
                        Long attendanceOtherIdV4FromV4 = (null == applyData2.get("id") ? Integer.valueOf(0) : applyData2.get("id")).longValue();
                        if (!attendanceOtherIdV4.equals(attendanceOtherIdV4FromV4)) continue;
                        TAttendanceOtherDO attendanceOtherDO1 = this.translateFromV4(applyData2, v4AndV5UserIds);
                        attendanceOtherDO1.setId(attendanceOtherDO.getId());
                        tAttendanceOtherDOList.add(attendanceOtherDO1);
                        continue block0;
                    }
                }
                this.tAttendanceOtherRepo.saveAll(tAttendanceOtherDOList);
                List newDatas = attendanceOtherData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = (applyData.get("id") == null ? Integer.valueOf(0) : applyData.get("id")).longValue();
                    for (TAttendanceOtherDO attendanceOtherDO : oldTAttendanceOtherDOs) {
                        if (!attendanceOtherDO.getAttendanceOtherIdV4().equals(applyId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<TAttendanceOtherDO> newTAttendanceOtherDOs = new ArrayList<TAttendanceOtherDO>();
                for (Map newData : newDatas) {
                    TAttendanceOtherDO attendanceOtherDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceOtherDOs.add(attendanceOtherDO1);
                }
                this.tAttendanceOtherRepo.saveAll(newTAttendanceOtherDOs);
                syncData = "\u66f4\u65b0\u4e86\u6b63\u5e38\u6253\u5361" + attendanceOtherData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6b63\u5e38\u6253\u5361\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6b63\u5e38\u6253\u5361\u4fe1\u606f\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
    }

    private TAttendanceOtherDO translateFromV4(Map attendanceOtherData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceOtherDO attendanceOtherDO = BeanUtil.mapToBean(TAttendanceOtherDO.class, attendanceOtherData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceOtherData.get("id")) {
            attendanceOtherDO.setAttendanceOtherIdV4(((Integer)attendanceOtherData.get("id")).longValue());
        }
        if (null != attendanceOtherData.get("attendanceResId")) {
            Long attendanceResId = ((Integer)attendanceOtherData.get("attendanceResId")).longValue();
            attendanceOtherDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceOtherDO;
    }

    public TAttendanceOtherServiceImpl(TAttendanceOtherRepo tAttendanceOtherRepo, TAttendanceOtherDAO tAttendanceOtherDAO, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService) {
        this.tAttendanceOtherRepo = tAttendanceOtherRepo;
        this.tAttendanceOtherDAO = tAttendanceOtherDAO;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.employeeService = employeeService;
        this.orgService = orgService;
    }
}

