/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ResActivityPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedDetailsService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedDetailsVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.ResActivityConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import com.elitesland.tw.tw5.server.prd.my.entity.ResActivityDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjectRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.ResActivityRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskAuthorizedRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanTempRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@Deprecated
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final TaskRepo taskRepo;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ProjectRepo projectRepo;
    private final ResActivityService resActivityService;
    private final TaskAuthorizedService taskAuthorizedService;
    private final TaskAuthorizedRepo taskAuthorizedRepo;
    private final TaskAuthorizedDetailsService taskAuthorizedDetailsService;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PrdOrgEmployeeService employeeService;
    private final ResActivityRepo resActivityRepo;
    @Value(value="${tw4.timesheet.task:api/openReport/v1/sync/taskApply}")
    private String timesheet_task;
    @Value(value="${tw4.url}")
    private String tw4_url;
    @Value(value="${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;

    public PagingVO<TaskVO> paging(TaskQuery query) {
        Page page = this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskConvert.INSTANCE::toVo));
    }

    public List<TaskVO> queryList(TaskQuery query) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"effectiveEqva"});
        return TaskConvert.INSTANCE.toVoList(this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), sort));
    }

    public List<ProjectAndTaskVO> queryListForSelect(TaskQuery query) {
        return TaskConvert.INSTANCE.toSelectVoList(this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public TaskVO queryByKey(Long key) {
        TaskDO entity = this.taskRepo.findById(key).orElseGet(TaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public TaskVO queryByTaskIdV4(Long taskIdV4) {
        TaskDO entity = this.taskRepo.getByTaskIdV4(taskIdV4);
        Assert.notNull((Object)((Object)entity), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskVO insert(TaskPayload payload) {
        if (payload.getReasonType() != null && payload.getReasonType().equals("01")) {
            Long reasonId = payload.getReasonId();
            String workType = this.projectRepo.findWorkTypeById(reasonId);
            String workType1 = this.projectRepo.findWorkTypeById1(reasonId);
            if (StringUtils.hasText((String)workType) && workType.equals("INDEPENDENT") || StringUtils.hasText((String)workType1) && workType1.equals("INDEPENDENT")) {
                throw TwException.error("", "\u81ea\u4e3b\u7814\u53d1\uff08\u8f6f\u4ef6\uff09\u9879\u76ee\u65e0\u6cd5\u7533\u8bf7\u4efb\u52a1\u5305\uff01");
            }
        }
        TaskPayload taskCopyPayload = new TaskPayload();
        BeanUtils.copyProperties((Object)payload, (Object)taskCopyPayload);
        if (null != payload.getReceiverUserId()) {
            taskCopyPayload.setReceiverUserId(this.employeeDAO.getV4UserId(payload.getReceiverUserId()));
        }
        if (null != payload.getDisterUserId()) {
            taskCopyPayload.setDisterUserId(this.employeeDAO.getV4UserId(payload.getDisterUserId()));
        }
        Map<String, Object> map = BeanUtil.beanToMap(taskCopyPayload);
        map.put("eqvaRatio", null);
        String result = this.httpUtil.sendPost(this.tw4_url + this.timesheet_task, map);
        Map parse = (Map)JSON.parse((String)result);
        if (("" + parse.get("ok")).equals("true")) {
            if (parse.get("datum") != null) {
                parse = (Map)parse.get("datum");
                Object taskId = parse.get("id");
                String taskNo = (String)parse.get("taskNo");
                BigDecimal taskEqva = (BigDecimal)parse.get("eqvaQty");
                Long reasonId = -1L;
                if (parse.get("reasonId") != null) {
                    reasonId = Long.valueOf(parse.get("reasonId").toString());
                }
                List resActivityList = (List)parse.get("resActivityList");
                for (Map stringObjectMap : resActivityList) {
                    ResActivityPayload resActivityPayload = BeanUtil.mapToBean(ResActivityPayload.class, stringObjectMap, new ArrayList<String>());
                    resActivityPayload.setActivityIdV4(resActivityPayload.getId());
                    this.resActivityService.insert(resActivityPayload);
                }
                long taskIdV4 = -999L;
                taskIdV4 = Long.valueOf(taskId.toString());
                payload.setTaskIdV4(Long.valueOf(taskIdV4));
                payload.setTaskNo(taskNo);
                payload.setReasonIdv4(reasonId);
                payload.setBaseTaskEqva(payload.getEqvaQty());
                payload.setEqvaRatio(null);
                payload.setTaskStatus("DISPATCH");
                payload.setEffectiveEqva(taskEqva);
                TaskDO entityDo = TaskConvert.INSTANCE.toDo(payload);
                TaskVO taskVO = TaskConvert.INSTANCE.toVo((TaskDO)((Object)this.taskRepo.save((Object)entityDo)));
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                List resActivityVOS = this.resActivityService.queryList(resActivityQuery);
                taskVO.setActivityList(resActivityVOS);
                return taskVO;
            }
            return null;
        }
        throw TwException.error("" + parse.get("errCode"), "" + parse.get("reason"));
    }

    private void check(TaskPayload payload) {
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskVO update(TaskPayload payload) {
        TaskDO entity = this.taskRepo.findById(payload.getId()).orElseGet(TaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskDO entityDo = TaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskConvert.INSTANCE.toVo((TaskDO)((Object)this.taskRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.taskRepo.deleteSoft(keys);
        }
    }

    public List<TaskVO> selectTaskForTimesheet(TaskQuery query, Long projIdV4, boolean test) {
        if (null == query.getEffectiveEqva()) {
            query.setEffectiveEqva(new BigDecimal("0.05"));
        }
        if (projIdV4 == 0L) {
            query.setTaskStatus(TaskStatusEnum.ACTIVE.getCode());
            query.setNotEqualReasonType("01");
            if (!test) {
                query.setReceiverUserId(GlobalUtil.getLoginUserId());
            }
            List<TaskVO> taskVOS = this.queryList(query);
            List<Long> taskIdList = taskVOS.stream().map(e -> e.getTaskIdV4()).collect(Collectors.toList());
            ResActivityQuery resActivityQuery = new ResActivityQuery();
            resActivityQuery.setTaskIds(taskIdList);
            List<ResActivityDO> resActivityDOS = this.resActivityRepo.queryByTaskIdIn(taskIdList);
            List resActivityVOS = resActivityDOS.stream().map(e -> ResActivityConvert.INSTANCE.toVo((ResActivityDO)((Object)e))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(taskVOS)) {
                taskVOS.forEach(taskVO -> {
                    List resActivityVOS1 = resActivityVOS.stream().filter(e -> e.getTaskId().equals(taskVO.getTaskIdV4())).collect(Collectors.toList());
                    taskVO.setActivityList(resActivityVOS1);
                });
            }
            return taskVOS;
        }
        ArrayList<String> taskStatusList = new ArrayList<String>();
        taskStatusList.add(TaskStatusEnum.ACTIVE.getCode());
        query.setTaskStatusList(taskStatusList);
        query.setReasonType("01");
        if (!test) {
            query.setReceiverUserId(GlobalUtil.getLoginUserId());
        }
        query.setReasonIdv4(projIdV4);
        List<TaskVO> taskVOS = this.queryList(query);
        if (!CollectionUtils.isEmpty(taskVOS)) {
            taskVOS.forEach(taskVO -> {
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                List resActivityVOS = this.resActivityService.queryList(resActivityQuery);
                taskVO.setActivityList(resActivityVOS);
            });
        }
        return taskVOS;
    }

    public Map<Long, Long> getV4AndV5TaskIds() {
        HashMap<Long, Long> taskMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5TaskIds = this.taskRepo.getV4AndV5TaskIds();
        for (Map<String, Object> v4AndV5TaskId : v4AndV5TaskIds) {
            Long taskId = (Long)v4AndV5TaskId.get("taskId");
            Long taskIdV4 = (Long)v4AndV5TaskId.get("taskIdV4");
            taskMap.put(taskIdV4, taskId);
        }
        return taskMap;
    }

    @Transactional
    public String updateTaskStatus(Long idV4, String status) {
        this.taskRepo.updateTaskStatus(idV4, status);
        List<TaskDO> taskDOS = this.taskRepo.queryByTaskIdV4In(Collections.singletonList(idV4));
        TaskDO taskDO = taskDOS.get(0);
        this.timesheetPlanRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        this.timesheetPlanTempRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        return null;
    }

    @Transactional
    public String updateTaskReason(Long taskIdV4, String reasonType, Long reasonId, Long expenseBuId) {
        this.taskRepo.updateTaskMess(taskIdV4, reasonId, expenseBuId);
        return null;
    }

    public List<PrdOrgEmployeeVO> getDisterUserIds(Long projectId) {
        HashSet<Long> userIds = new HashSet<Long>();
        PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
        ProjectDO projectDO = this.projectRepo.findByProjIdV4(projectId).orElse(null);
        if (!ObjectUtils.isEmpty((Object)((Object)projectDO))) {
            Long pmUserId = projectDO.getPmUserId();
            List<TaskAuthorizedDO> taskAuthorizedDOS = this.taskAuthorizedRepo.queryByReasonTypeAndReasonIdAndDeleteFlag("01", projectId, 0);
            List collect = taskAuthorizedDOS.stream().map(e -> e.getReceiverUserId()).collect(Collectors.toList());
            if (pmUserId != null) {
                userIds.add(pmUserId);
            }
            if (!CollectionUtils.isEmpty(collect)) {
                userIds.addAll(collect);
            }
        } else {
            throw TwException.error("", "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9879\u76ee");
        }
        query.setUserIdList(userIds);
        return this.employeeService.queryList(query);
    }

    public Long getApprResIdByAuthInfo(Long taskId) {
        Long authId;
        TaskAuthorizedVO taskAuthorizedVO;
        TaskAuthorizedDetailsQuery authorizedDetailsQuery = new TaskAuthorizedDetailsQuery();
        authorizedDetailsQuery.setTaskId(taskId);
        List taskAuthorizedDetailsVOS = this.taskAuthorizedDetailsService.queryList(authorizedDetailsQuery);
        if (!CollectionUtils.isEmpty((Collection)taskAuthorizedDetailsVOS) && null != (taskAuthorizedVO = this.taskAuthorizedService.queryByKey(authId = ((TaskAuthorizedDetailsVO)taskAuthorizedDetailsVOS.get(0)).getAuthIdV5()))) {
            String approvedType = taskAuthorizedVO.getApprovedType();
            if (StringUtils.hasText((String)approvedType)) {
                if (approvedType.equals("PM")) {
                    return taskAuthorizedVO.getDisterUserId();
                }
                if (approvedType.equals("PL")) {
                    return taskAuthorizedVO.getReceiverUserId();
                }
                log.info("===================>\u57fa\u4e8e\u6388\u6743\u53d1\u653e\u7684\u4efb\u52a1\u5305;\u6388\u6743\u914d\u7f6eAPPROVED_TYPE[" + approvedType + "]\u5f02\u5e38\uff1a\u6388\u6743\u4e3b\u952e=" + authId + ";");
            } else {
                log.info("===================>\u57fa\u4e8e\u6388\u6743\u53d1\u653e\u7684\u4efb\u52a1\u5305;\u6388\u6743\u914d\u7f6e\u5f02\u5e38\uff1a\u6388\u6743\u4e3b\u952e=" + authId + ";");
            }
        }
        return null;
    }

    public TaskServiceImpl(TaskRepo taskRepo, HttpUtil httpUtil, PrdOrgEmployeeDAO employeeDAO, ProjectRepo projectRepo, ResActivityService resActivityService, TaskAuthorizedService taskAuthorizedService, TaskAuthorizedRepo taskAuthorizedRepo, TaskAuthorizedDetailsService taskAuthorizedDetailsService, TimesheetPlanRepo timesheetPlanRepo, TimesheetPlanTempRepo timesheetPlanTempRepo, TimesheetBiweeklyRepo timesheetBiweeklyRepo, PrdOrgEmployeeService employeeService, ResActivityRepo resActivityRepo) {
        this.taskRepo = taskRepo;
        this.httpUtil = httpUtil;
        this.employeeDAO = employeeDAO;
        this.projectRepo = projectRepo;
        this.resActivityService = resActivityService;
        this.taskAuthorizedService = taskAuthorizedService;
        this.taskAuthorizedRepo = taskAuthorizedRepo;
        this.taskAuthorizedDetailsService = taskAuthorizedDetailsService;
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.timesheetPlanTempRepo = timesheetPlanTempRepo;
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.employeeService = employeeService;
        this.resActivityRepo = resActivityRepo;
    }
}

