/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRolePayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsProjectRoleRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectRoleDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectRoleRepo repo;
    private final QPmsProjectRoleDO qdo = QPmsProjectRoleDO.pmsProjectRoleDO;

    private JPAQuery<PmsProjectRoleVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectRoleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.roleName, this.qdo.roleCode, this.qdo.unitPrice})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectRoleVO> getJpaQueryWhere(PmsProjectRoleQuery query) {
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsProjectRoleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsProjectRoleQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIds())) {
            list.add(this.qdo.id.in((Collection)query.getIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleName())) {
            list.add(this.qdo.roleName.like(SqlUtil.toSqlLikeString(query.getRoleName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleCode())) {
            list.add(this.qdo.roleCode.like(SqlUtil.toSqlLikeString(query.getRoleCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUnitPrice())) {
            list.add(this.qdo.unitPrice.eq((Object)query.getUnitPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getKeyWord())) {
            list.add(this.qdo.roleName.like(SqlUtil.toSqlLikeString(query.getKeyWord())).or((Predicate)this.qdo.roleCode.like(SqlUtil.toSqlLikeString(query.getKeyWord()))));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectRoleVO queryByKey(Long id) {
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectRoleVO)jpaQuery.fetchFirst();
    }

    public PmsProjectRoleVO queryByRoleCode(String roleCode) {
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.roleCode.eq((Object)roleCode));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectRoleVO)jpaQuery.fetchFirst();
    }

    public PmsProjectRoleVO queryByRoleName(String roleName) {
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.roleName.eq((Object)roleName));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectRoleVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectRoleVO> queryListDynamic(PmsProjectRoleQuery query) {
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsProjectRoleVO> queryPaging(PmsProjectRoleQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectRoleVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectRoleDO save(PmsProjectRoleDO ado) {
        return (PmsProjectRoleDO)this.repo.save(ado);
    }

    public List<PmsProjectRoleDO> saveAll(List<PmsProjectRoleDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectRolePayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getRoleName() != null) {
            update.set((Path)this.qdo.roleName, (Object)payload.getRoleName());
        }
        if (payload.getRoleCode() != null) {
            update.set((Path)this.qdo.roleCode, (Object)payload.getRoleCode());
        }
        if (payload.getUnitPrice() != null) {
            update.set(this.qdo.unitPrice, (Object)payload.getUnitPrice());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("roleName")) {
                update.setNull((Path)this.qdo.roleName);
            }
            if (nullFields.contains("roleCode")) {
                update.setNull((Path)this.qdo.roleCode);
            }
            if (nullFields.contains("unitPrice")) {
                update.setNull(this.qdo.unitPrice);
            }
            if (nullFields.contains("remark")) {
                update.setNull((Path)this.qdo.remark);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectRoleDAO(JPAQueryFactory jpaQueryFactory, PmsProjectRoleRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

