/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRolePayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PmsProjectRoleConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsProjectRoleRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectRoleServiceImpl
extends BaseServiceImpl
implements PmsProjectRoleService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectRoleServiceImpl.class);
    private final PmsProjectRoleRepo pmsProjectRoleRepo;
    private final PmsProjectRoleDAO pmsProjectRoleDAO;
    private final PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO;

    public PagingVO<PmsProjectRoleVO> queryPaging(PmsProjectRoleQuery query) {
        return this.pmsProjectRoleDAO.queryPaging(query);
    }

    public List<PmsProjectRoleVO> queryListDynamic(PmsProjectRoleQuery query) {
        return this.pmsProjectRoleDAO.queryListDynamic(query);
    }

    public PmsProjectRoleVO queryByKey(Long key) {
        PmsProjectRoleDO entity = this.pmsProjectRoleRepo.findById(key).orElseGet(PmsProjectRoleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9879\u76ee\u89d2\u8272\u4e0d\u5b58\u5728");
        PmsProjectRoleVO vo = PmsProjectRoleConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectRoleVO insert(PmsProjectRolePayload payload) {
        this.checkData(payload);
        PmsProjectRoleDO entityDo = PmsProjectRoleConvert.INSTANCE.toDo(payload);
        return PmsProjectRoleConvert.INSTANCE.toVo((PmsProjectRoleDO)this.pmsProjectRoleRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectRoleVO update(PmsProjectRolePayload payload) {
        this.checkData(payload);
        PmsProjectRoleDO entity = this.pmsProjectRoleRepo.findById(payload.getId()).orElseGet(PmsProjectRoleDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectRoleDO entityDo = PmsProjectRoleConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectRoleConvert.INSTANCE.toVo((PmsProjectRoleDO)this.pmsProjectRoleRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectRolePayload payload) {
        this.checkData(payload);
        long result = this.pmsProjectRoleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (ObjectUtils.isEmpty(keys)) {
            throw TwException.error("", "\u89d2\u8272\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.pmsProjectRoleDAO.deleteSoft(keys);
        this.pmsProjectRoleAssignmentDAO.deleteByRoleIds(keys);
    }

    void checkData(PmsProjectRolePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getRoleCode())) {
            throw TwException.error("", "\u89d2\u8272\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getRoleName())) {
            throw TwException.error("", "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getUnitPrice())) {
            throw TwException.error("", "\u5e73\u5747\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            PmsProjectRoleVO vo = this.pmsProjectRoleDAO.queryByRoleCode(payload.getRoleCode());
            if (!ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error("", "\u89d2\u8272\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            vo = this.pmsProjectRoleDAO.queryByRoleName(payload.getRoleName());
            if (!ObjectUtils.isEmpty((Object)vo)) {
                throw TwException.error("", "\u89d2\u8272\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            PmsProjectRoleVO vo = this.pmsProjectRoleDAO.queryByKey(payload.getId());
            if (!payload.getRoleCode().equals(vo.getRoleCode()) && !ObjectUtils.isEmpty((Object)(vo = this.pmsProjectRoleDAO.queryByRoleCode(payload.getRoleCode())))) {
                throw TwException.error("", "\u89d2\u8272\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!payload.getRoleName().equals(vo.getRoleName()) && !ObjectUtils.isEmpty((Object)(vo = this.pmsProjectRoleDAO.queryByRoleName(payload.getRoleName())))) {
                throw TwException.error("", "\u89d2\u8272\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        payload.setUnitPrice(payload.getUnitPrice().setScale(2));
    }

    public PmsProjectRoleServiceImpl(PmsProjectRoleRepo pmsProjectRoleRepo, PmsProjectRoleDAO pmsProjectRoleDAO, PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO) {
        this.pmsProjectRoleRepo = pmsProjectRoleRepo;
        this.pmsProjectRoleDAO = pmsProjectRoleDAO;
        this.pmsProjectRoleAssignmentDAO = pmsProjectRoleAssignmentDAO;
    }
}

