/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetReleaseService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetReleaseDao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PmsWbsBudgetReleaseServiceImpl
implements PmsWbsBudgetReleaseService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsBudgetReleaseServiceImpl.class);
    private final PmsWbsBudgetReleaseDao dao;

    public PagingVO<PmsWbsBudgetReleaseVO> queryPage(PmsWbsBudgetReleaseQuery query) {
        PagingVO<PmsWbsBudgetReleaseVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return pageVO;
    }

    public List<PmsWbsBudgetReleaseVO> queryList(PmsWbsBudgetReleaseQuery query) {
        List<PmsWbsBudgetReleaseVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return listVO;
    }

    public long queryCount(PmsWbsBudgetReleaseQuery query) {
        return this.dao.queryCount(query);
    }

    public PmsWbsBudgetReleaseVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetReleaseVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return vo;
    }

    @Transactional
    public PmsWbsBudgetReleaseVO insert(PmsWbsBudgetReleasePayload payload) {
        this.checkData(payload);
        PmsWbsBudgetReleaseVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetReleaseVO update(PmsWbsBudgetReleasePayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsWbsBudgetReleaseVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetReleaseVO updateDynamic(PmsWbsBudgetReleasePayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dao.deleteSoft(ids);
    }

    public List<PmsWbsBudgetReleaseVO> insertAll(List<PmsWbsBudgetReleasePayload> releasePayloadList) {
        ArrayList<PmsWbsBudgetReleaseVO> list = new ArrayList<PmsWbsBudgetReleaseVO>();
        if (!CollectionUtils.isEmpty(releasePayloadList)) {
            releasePayloadList.forEach(releasePayload -> {
                PmsWbsBudgetReleaseVO insert = this.insert((PmsWbsBudgetReleasePayload)releasePayload);
                list.add(insert);
            });
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsWbsBudgetReleaseVO updatePro(PmsWbsBudgetReleasePayload payload) {
        Long id = payload.getId();
        Assert.notNull((Object)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PmsWbsBudgetReleaseVO pmsWbsBudgetReleaseVO = this.queryByKey(id);
        PmsWbsBudgetReleasePayload updatedPayload = new PmsWbsBudgetReleasePayload();
        BigDecimal confirmSettledRes = payload.getConfirmSettledRes() == null ? BigDecimal.ZERO : payload.getConfirmSettledRes();
        updatedPayload.setConfirmSettledRes(confirmSettledRes);
        BigDecimal settledResAmtBefore = pmsWbsBudgetReleaseVO.getSettledResAmtBefore() == null ? BigDecimal.ZERO : pmsWbsBudgetReleaseVO.getSettledResAmtBefore();
        updatedPayload.setId(id);
        BigDecimal settledResAmtAfter = settledResAmtBefore.add(confirmSettledRes);
        updatedPayload.setSettledResAmtAfter(settledResAmtAfter);
        updatedPayload.setAllocatedResAmtAfter(settledResAmtAfter);
        updatedPayload.setOccupiedResAmtAfter(BigDecimal.ZERO);
        updatedPayload.setRemainingResAmtAfter(BigDecimal.ZERO);
        BigDecimal changeResAmt = payload.getChangeResAmt() == null ? BigDecimal.ZERO : payload.getChangeResAmt();
        updatedPayload.setChangeResAmt(changeResAmt);
        this.dao.updateByKeyDynamic(updatedPayload);
        return this.queryByKey(id);
    }

    private void checkData(PmsWbsBudgetReleasePayload payload) {
    }

    private void translate(List<PmsWbsBudgetReleaseVO> vos) {
        vos.forEach(vo -> {});
    }

    public PmsWbsBudgetReleaseServiceImpl(PmsWbsBudgetReleaseDao dao) {
        this.dao = dao;
    }
}

