/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetDetailQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u7b97\u660e\u7ec6"})
@RestController
@RequestMapping(value={"/api/pms/pmsBudgetDetail"})
public class PmsBudgetDetailController {
    private static final Logger log = LoggerFactory.getLogger(PmsBudgetDetailController.class);
    private final PmsBudgetDetailService pmsBudgetDetailService;

    @GetMapping(value={"/queryByProjectId"})
    @ApiOperation(value="\u901a\u8fc7\u9879\u76eeid\u67e5\u8be2")
    public TwOutputUtil queryByProjectId(Long projectId) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryByProject(projectId));
    }

    @GetMapping(value={"/queryByWbs"})
    @ApiOperation(value="\u6839\u636ewbsId\u67e5\u8be2\u76f8\u5e94\u9884\u7b97\u4fe1\u606f")
    public TwOutputUtil queryByWbs(Long projectId, Long wbsId) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryByWbs(projectId, wbsId));
    }

    @GetMapping(value={"/queryBudgetStatus"})
    @ApiOperation(value="\u6839\u636ewbsId\u67e5\u8be2\u76f8\u5e94\u9884\u7b97\u72b6\u6001")
    public TwOutputUtil queryBudgetStatus(Long projectId, Long wbsId) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryProjectBudgetStatus(projectId, wbsId));
    }

    @GetMapping(value={"/submitByProjectId"})
    @ApiOperation(value="\u63d0\u4ea4\u9884\u7b97\u5ba1\u6279")
    public TwOutputUtil submitApprovalProcess(Long projectId) {
        this.pmsBudgetDetailService.submitApprovalProcess(projectId);
        return TwOutputUtil.ok();
    }

    @PostMapping
    @ApiOperation(value="\u9884\u7b97\u660e\u7ec6-\u65b0\u589e")
    public TwOutputUtil<PmsBudgetDetailVO> insert(@RequestBody PmsBudgetPayload payload) {
        this.pmsBudgetDetailService.insert(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u9884\u7b97\u660e\u7ec6-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<PmsBudgetDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u9884\u7b97\u660e\u7ec6-\u5206\u9875")
    public TwOutputUtil<PagingVO<PmsBudgetDetailVO>> paging(PmsBudgetDetailQuery query) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u9884\u7b97\u660e\u7ec6-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<PmsBudgetDetailVO>> queryList(PmsBudgetDetailQuery query) {
        return TwOutputUtil.ok(this.pmsBudgetDetailService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u9884\u7b97\u660e\u7ec6-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long budgetId, Long[] keys) {
        this.pmsBudgetDetailService.deleteSoft(budgetId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PmsBudgetDetailController(PmsBudgetDetailService pmsBudgetDetailService) {
        this.pmsBudgetDetailService = pmsBudgetDetailService;
    }
}

