/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsBudgetDetailPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsBudgetDetailQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsBudgetDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsBudgetDetailDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsBudgetDetailDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsBudgetDetailRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetDetailDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetDetailRepo repo;
    private final QPmsBudgetDetailDO qdo = QPmsBudgetDetailDO.pmsBudgetDetailDO;
    private final QPmsProjectRoleDO roleQdo = QPmsProjectRoleDO.pmsProjectRoleDO;

    private JPAQuery<PmsBudgetDetailVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsBudgetDetailVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.budgetId, this.qdo.sourceType, this.qdo.projectRoleId, this.qdo.unitPrice, this.qdo.days, this.qdo.totalMoney, this.qdo.proportion, this.qdo.usedMoney, this.qdo.subjectId, this.qdo.subjectParentId, this.roleQdo.roleName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.roleQdo)).on((Predicate)this.qdo.projectRoleId.eq(this.roleQdo.id));
    }

    private JPAQuery<PmsBudgetDetailVO> getJpaQueryWhere(PmsBudgetDetailQuery query) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetDetailQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetDetailQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetId())) {
            list.add(this.qdo.budgetId.eq((Object)query.getBudgetId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            list.add(this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectRoleId())) {
            list.add(this.qdo.projectRoleId.eq((Object)query.getProjectRoleId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUnitPrice())) {
            list.add(this.qdo.unitPrice.eq((Object)query.getUnitPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDays())) {
            list.add(this.qdo.days.eq((Object)query.getDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalMoney())) {
            list.add(this.qdo.totalMoney.eq((Object)query.getTotalMoney()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProportion())) {
            list.add(this.qdo.proportion.eq((Object)query.getProportion()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUsedMoney())) {
            list.add(this.qdo.usedMoney.eq((Object)query.getUsedMoney()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectId())) {
            list.add(this.qdo.subjectId.eq((Object)query.getSubjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectParentId())) {
            list.add(this.qdo.subjectParentId.eq((Object)query.getSubjectParentId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetDetailVO queryByKey(Long id) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetDetailVO)jpaQuery.fetchFirst();
    }

    public List<PmsBudgetDetailVO> queryByKeys(List<Long> ids) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsBudgetDetailVO> queryByBudgetId(Long budgetId) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.budgetId.eq((Object)budgetId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsBudgetDetailVO> queryByBudgetIds(List<Long> budgetId) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.budgetId.in(budgetId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsBudgetDetailVO queryByBudgetIdAndRole(Long budgetId, Long projectRoleId) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.budgetId.eq((Object)budgetId));
        jpaQuery.where((Predicate)this.qdo.projectRoleId.eq((Object)projectRoleId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsBudgetDetailVO)jpaQuery.fetchOne();
    }

    public List<PmsBudgetDetailVO> queryListDynamic(PmsBudgetDetailQuery query) {
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsBudgetDetailVO> queryPaging(PmsBudgetDetailQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetDetailVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsBudgetDetailDO save(PmsBudgetDetailDO ado) {
        return (PmsBudgetDetailDO)this.repo.save(ado);
    }

    public List<PmsBudgetDetailDO> saveAll(List<PmsBudgetDetailDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetDetailPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBudgetId() != null) {
            update.set(this.qdo.budgetId, (Object)payload.getBudgetId());
        }
        if (payload.getSourceType() != null) {
            update.set((Path)this.qdo.sourceType, (Object)payload.getSourceType());
        }
        if (payload.getProjectRoleId() != null) {
            update.set(this.qdo.projectRoleId, (Object)payload.getProjectRoleId());
        }
        if (payload.getUnitPrice() != null) {
            update.set(this.qdo.unitPrice, (Object)payload.getUnitPrice());
        }
        if (payload.getDays() != null) {
            update.set(this.qdo.days, (Object)payload.getDays());
        }
        if (payload.getTotalMoney() != null) {
            update.set(this.qdo.totalMoney, (Object)payload.getTotalMoney());
        }
        if (payload.getProportion() != null) {
            update.set(this.qdo.proportion, (Object)payload.getProportion());
        }
        if (payload.getUsedMoney() != null) {
            update.set(this.qdo.usedMoney, (Object)payload.getUsedMoney());
        }
        if (payload.getSubjectId() != null) {
            update.set(this.qdo.subjectId, (Object)payload.getSubjectId());
        }
        if (payload.getSubjectParentId() != null) {
            update.set(this.qdo.subjectParentId, (Object)payload.getSubjectParentId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("budgetId")) {
                update.setNull(this.qdo.budgetId);
            }
            if (nullFields.contains("sourceType")) {
                update.setNull((Path)this.qdo.sourceType);
            }
            if (nullFields.contains("projectRoleId")) {
                update.setNull(this.qdo.projectRoleId);
            }
            if (nullFields.contains("unitPrice")) {
                update.setNull(this.qdo.unitPrice);
            }
            if (nullFields.contains("days")) {
                update.setNull(this.qdo.days);
            }
            if (nullFields.contains("totalMoney")) {
                update.setNull(this.qdo.totalMoney);
            }
            if (nullFields.contains("proportion")) {
                update.setNull(this.qdo.proportion);
            }
            if (nullFields.contains("usedMoney")) {
                update.setNull(this.qdo.usedMoney);
            }
            if (nullFields.contains("subjectId")) {
                update.setNull(this.qdo.subjectId);
            }
            if (nullFields.contains("subjectParentId")) {
                update.setNull(this.qdo.subjectParentId);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteByBudgetIds(List<Long> budgetIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.budgetId.in(budgetIds)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateMoney(Long id, BigDecimal totalMoney, BigDecimal usedMoney, BigDecimal proportion) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        update.set(this.qdo.totalMoney, (Object)totalMoney);
        update.set(this.qdo.usedMoney, (Object)usedMoney);
        update.set(this.qdo.proportion, (Object)proportion);
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsBudgetDetailDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetDetailRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

