/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectSetPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectSetQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetRelationVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSetVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectSetDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectSetRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectSetDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectSetRepo repo;
    private final QPmsProjectSetDO qdo = QPmsProjectSetDO.pmsProjectSetDO;
    private final QPmsProjectDO qdoProject = QPmsProjectDO.pmsProjectDO;

    private JPAQuery<PmsProjectSetVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectSetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdoProject.id.count().as("projectCount"), this.qdo.parentId, this.qdo.setName, this.qdo.setCode, this.qdo.parentSetCode, this.qdo.nodeCode, this.qdo.managerUserId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdo.id.eq(this.qdoProject.projectSetId).and((Predicate)this.qdoProject.deleteFlag.eq((Object)0)));
    }

    private JPAQuery<PmsProjectSetVO> getJpaQueryWhere(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem item = new OrderItem();
        item.setColumn("setCode");
        orders.add(item);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orders));
        jpaQuery.groupBy(this.qdo.id);
        return jpaQuery;
    }

    private Predicate where(PmsProjectSetQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            list.add(this.qdo.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSetName())) {
            list.add(this.qdo.setName.like(SqlUtil.toSqlLikeString(query.getSetName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSetSearch())) {
            list.add(this.qdo.setName.like(SqlUtil.toSqlLikeString(query.getSetSearch())).or((Predicate)this.qdo.nodeCode.like(SqlUtil.toSqlLikeString(query.getSetSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSetCode())) {
            list.add(this.qdo.setCode.like(SqlUtil.toSqlLikeString(query.getSetCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentSetCode())) {
            list.add(this.qdo.parentSetCode.like(SqlUtil.toSqlLikeString(query.getParentSetCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNodeCode())) {
            list.add(this.qdo.nodeCode.like(SqlUtil.toSqlLikeString(query.getNodeCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserId())) {
            list.add(this.qdo.managerUserId.eq((Object)query.getManagerUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectSetVO queryByKey(Long id) {
        JPAQuery<PmsProjectSetVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectSetVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectSetVO> queryListDynamic(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<PmsProjectSetVO> queryListToProject(PmsProjectQuery query) {
        Predicate predicate = this.whereToProject(query);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectSetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.parentId, this.qdo.setName, this.qdo.setCode, this.qdo.parentSetCode, this.qdo.nodeCode, this.qdo.managerUserId, this.qdoProject.id.count().as("projectCount")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on(predicate);
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        jpaQuery.groupBy(this.qdo.id);
        return jpaQuery.fetch();
    }

    private Predicate whereToProject(PmsProjectQuery query) {
        Object jpaQueryOr0;
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        list.add(this.qdo.id.eq(this.qdoProject.projectSetId));
        list.add(this.qdoProject.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdoProject.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNameOrCode())) {
            String s = SqlUtil.toSqlLikeString(query.getProjectNameOrCode());
            list.add(this.qdoProject.projName.like(s).or((Predicate)this.qdoProject.projNo.like(s)));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjName())) {
            list.add(this.qdoProject.projName.like(SqlUtil.toSqlLikeString(query.getProjName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjNo())) {
            list.add(this.qdoProject.projNo.like(SqlUtil.toSqlLikeString(query.getProjNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustIndustry())) {
            list.add(this.qdoProject.custIdst.eq((Object)query.getCustIndustry()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustArea())) {
            list.add(this.qdoProject.custRegion.eq((Object)query.getCustArea()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectImportance())) {
            list.add(this.qdoProject.projectImportance.eq((Object)query.getProjectImportance()));
        }
        if ((jpaQueryOr0 = null) != null) {
            list.add((BooleanExpression)jpaQueryOr0);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSowFiles())) {
            list.add(this.qdoProject.sowFiles.eq((Object)query.getSowFiles()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalDays())) {
            list.add(this.qdoProject.totalDays.eq((Object)query.getTotalDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTotalCost())) {
            list.add(this.qdoProject.totalCost.eq((Object)query.getTotalCost()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetFiles())) {
            list.add(this.qdoProject.budgetFiles.eq((Object)query.getBudgetFiles()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTimesheetPeriod())) {
            list.add(this.qdoProject.timesheetPeriod.eq((Object)query.getTimesheetPeriod()));
        }
        return ExpressionUtils.allOf(list);
    }

    private JPAQuery<PmsProjectSetVO> getJpaQuerySelect0() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectSetVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.parentId, this.qdo.setName, this.qdo.setCode, this.qdo.parentSetCode, this.qdo.nodeCode, this.qdo.managerUserId})).from((EntityPath)this.qdo);
    }

    public List<PmsProjectSetVO> querySelectList(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetVO> jpaQuery = this.getJpaQuerySelect0();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    private JPAQuery<PmsProjectSetRelationVO> getJpaQuerySelect1() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectSetRelationVO.class, (Expression[])new Expression[]{this.qdoProject.remark, this.qdoProject.createUserId, this.qdoProject.creator, this.qdoProject.createTime, this.qdoProject.modifyUserId, this.qdoProject.updater, this.qdoProject.modifyTime, this.qdoProject.projectSetId, this.qdoProject.id, this.qdoProject.projNo.as("projectCode"), this.qdoProject.projName.as("projectName"), this.qdoProject.projStatus.as("projectStatus"), this.qdoProject.ext1.as("projectType"), this.qdoProject.pmResId.as("managerUserId")})).from((EntityPath)this.qdoProject);
    }

    public long count(PmsProjectSetQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoProject.count()).from((EntityPath)this.qdoProject);
        jpaQuery.where((Predicate)this.qdoProject.projectSetId.eq((Object)query.getId()));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    public PagingVO<PmsProjectSetRelationVO> queryRelationProjectPaging(PmsProjectSetQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectSetRelationVO> jpaQuery = this.getJpaQuerySelect1();
        jpaQuery.where((Predicate)this.qdoProject.projectSetId.eq((Object)query.getId()));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoProject, query.getOrders()));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public List<PmsProjectSetRelationVO> queryRelationProjectList(PmsProjectSetQuery query) {
        JPAQuery<PmsProjectSetRelationVO> jpaQuery = this.getJpaQuerySelect1();
        jpaQuery.where((Predicate)this.qdoProject.projectSetId.eq((Object)query.getId()));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdoProject, query.getOrders()));
        return jpaQuery.fetch();
    }

    public PmsProjectSetDO save(PmsProjectSetDO ado) {
        return (PmsProjectSetDO)this.repo.save(ado);
    }

    public List<PmsProjectSetDO> saveAll(List<PmsProjectSetDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectSetPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getSetName() != null) {
            update.set((Path)this.qdo.setName, (Object)payload.getSetName());
        }
        if (payload.getSetCode() != null) {
            update.set((Path)this.qdo.setCode, (Object)payload.getSetCode());
        }
        if (payload.getParentSetCode() != null) {
            update.set((Path)this.qdo.parentSetCode, (Object)payload.getParentSetCode());
        }
        if (payload.getNodeCode() != null) {
            update.set((Path)this.qdo.nodeCode, (Object)payload.getNodeCode());
        }
        if (payload.getManagerUserId() != null) {
            update.set(this.qdo.managerUserId, (Object)payload.getManagerUserId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("setName")) {
                update.setNull((Path)this.qdo.setName);
            }
            if (nullFields.contains("setCode")) {
                update.setNull((Path)this.qdo.setCode);
            }
            if (nullFields.contains("parentSetCode")) {
                update.setNull((Path)this.qdo.parentSetCode);
            }
            if (nullFields.contains("nodeCode")) {
                update.setNull((Path)this.qdo.nodeCode);
            }
            if (nullFields.contains("managerUserId")) {
                update.setNull(this.qdo.managerUserId);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectSetDAO(JPAQueryFactory jpaQueryFactory, PmsProjectSetRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

