/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.deliver.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.convert.PmsDeliverItemRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleExcelVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/pms/pmsDeliverItemRole"})
@Api(value="\u4ea4\u4ed8\u9879\u89c4\u5219", tags={"\u4ea4\u4ed8\u9879\u89c4\u5219"})
public class PmsDeliverItemRoleController {
    private final PmsDeliverItemRoleService pmsDeliverItemRoleService;

    @GetMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u4ea4\u4ed8\u9879\u89c4\u5219\u6e05\u5355\u6a21\u7248\u4e0b\u8f7d")
    public void downloadTemplate(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsDeliverItemTemplate.xlsx");
        try {
            InputStream fis = classPathResource.getInputStream();
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/vnd.ms-excel");
            String fileName = "\u4e0a\u4f20\u4ea4\u4ed8\u7269\u89c4\u5219\u6e05\u5355-Excel\u6a21\u677f-20240221";
            fileName = URLEncoder.encode(fileName, "utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + ".xlsx\"");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            bufferedOutputStream.write(buffer);
            bufferedOutputStream.flush();
            servletOutputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/excelImport"}, consumes={"multipart/form-data"})
    @ApiOperation(value="excel\u5bfc\u5165-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil excelImport(MultipartFile file, Long projectId, Boolean force, HttpServletResponse response) {
        Map<String, Object> resultMap = this.pmsDeliverItemRoleService.excelImport(file, projectId, force, response);
        return TwOutputUtil.ok(resultMap);
    }

    @GetMapping(value={"/excelDownload"})
    @ApiOperation(value="\u4ea4\u4ed8\u9879\u89c4\u5219\u6e05\u5355\u4e0b\u8f7d")
    public void excelDownload(PmsDeliverItemRoleQuery query, HttpServletResponse response) throws IOException {
        Assert.notNull((Object)query.getProjectId(), (String)"\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
        taskOrderItemList.add(OrderItem.asc((String)"createTime"));
        query.setOrders(taskOrderItemList);
        List<PmsDeliverItemRoleVO> vos = this.pmsDeliverItemRoleService.getList(query);
        String sheetName = "\u4ea4\u4ed8\u9879\u89c4\u5219\u6e05\u5355";
        List<PmsDeliverItemRoleExcelVO> resultList = PmsDeliverItemRoleConvert.INSTANCE.d2eList(vos);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        int k = 0;
        for (PmsDeliverItemRoleExcelVO pmsDeliverItemRoleExcelPayload : resultList) {
            pmsDeliverItemRoleExcelPayload.setNo(++k);
        }
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PmsDeliverItemRoleExcelVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, PmsDeliverItemRoleExcelVO.class, null);
        sheet.doWrite(resultList);
    }

    @PostMapping(value={"/updateItemByRole"})
    @ApiOperation(value="\u6839\u636e\u4ea4\u4ed8\u89c4\u5219\u66f4\u65b0\u4ea4\u4ed8\u9879")
    public TwOutputUtil<Long> updateItemByRole(@RequestParam Long projectId) {
        long count = this.pmsDeliverItemRoleService.updateItemByRole(projectId);
        return TwOutputUtil.ok(count);
    }

    @GetMapping(value={"get"})
    @ApiOperation(value="\u8be6\u60c5-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<PmsDeliverItemRoleVO> get(Long id) {
        PmsDeliverItemRoleVO res = this.pmsDeliverItemRoleService.get(id);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> save(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        PmsDeliverItemRoleVO res = this.pmsDeliverItemRoleService.save(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res.getId());
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> update(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Long res = this.pmsDeliverItemRoleService.update(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"updateNoShowFlag"})
    @ApiOperation(value="\u4fee\u6539\u88c1\u526a\u72b6\u6001-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> updateNoShowFlag(@RequestBody PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Long res = this.pmsDeliverItemRoleService.updateNoShowFlag(pmsDeliverItemRolePayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"updateNoShowFlagList"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u88c1\u526a\u72b6\u6001-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> updateNoShowFlagList(@RequestBody List<PmsDeliverItemRolePayload> list) {
        Long res = this.pmsDeliverItemRoleService.updateNoShowFlagList(list);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
        Long res = this.pmsDeliverItemRoleService.del(ids);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"countByProjectId"})
    @ApiOperation(value="\u6839\u636e\u9879\u76ee\u4e3b\u952e\u7edf\u8ba1\u4e2a\u6570-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> countByProjectId(@RequestParam Long projectId) {
        PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery = new PmsDeliverItemRoleQuery();
        pmsDeliverItemRoleQuery.setProjectId(projectId);
        long count = this.pmsDeliverItemRoleService.count(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(count);
    }

    @GetMapping(value={"count"})
    @ApiOperation(value="\u7edf\u8ba1\u4e2a\u6570-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<Long> count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        long count = this.pmsDeliverItemRoleService.count(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(count);
    }

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<PagingVO<PmsDeliverItemRoleVO>> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Assert.notNull((Object)pmsDeliverItemRoleQuery.getProjectId(), (String)"\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        PagingVO<PmsDeliverItemRoleVO> res = this.pmsDeliverItemRoleService.page(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"getList"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2-\u4ea4\u4ed8\u9879\u89c4\u5219")
    public TwOutputUtil<List<PmsDeliverItemRoleVO>> getList(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Assert.notNull((Object)pmsDeliverItemRoleQuery.getProjectId(), (String)"\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        List<PmsDeliverItemRoleVO> res = this.pmsDeliverItemRoleService.getList(pmsDeliverItemRoleQuery);
        return TwOutputUtil.ok(res);
    }

    public PmsDeliverItemRoleController(PmsDeliverItemRoleService pmsDeliverItemRoleService) {
        this.pmsDeliverItemRoleService = pmsDeliverItemRoleService;
    }
}

