/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCalendarVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectCalendarConvert;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectCalendarDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectCalendarRepo;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectCalendarServiceImpl
implements PmsProjectCalendarService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectCalendarServiceImpl.class);
    private final PmsProjectCalendarRepo pmsProjectCalendarRepo;
    private final ProVacationService proVacationService;
    private static Map<String, List<Map<LocalDate, BigDecimal>>> calendarCache = new HashMap<String, List<Map<LocalDate, BigDecimal>>>();

    Boolean check(PmsProjectCalendarPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getSourceId())) {
            throw TwException.error("", "\u5173\u8054\u4e3b\u952e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceType())) {
            throw TwException.error("", "\u5173\u8054\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEndDate()) && ObjectUtils.isEmpty((Object)payload.getStartDate()) && ObjectUtils.isEmpty((Object)payload.getDurationDays())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u3001\u7ed3\u675f\u65e5\u671f\u548c\u6301\u7eed\u5de5\u4f5c\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDurationDays()) && payload.getDurationDays() == 0) {
            LocalDate endDate = payload.getEndDate();
            LocalDate startDate = payload.getStartDate();
            payload.setStartDate(endDate);
            payload.setEndDate(startDate);
            payload.setDurationDays(Integer.valueOf(2));
            return true;
        }
        return false;
    }

    public PmsProjectCalendarVO findBySource(PmsProjectCalendarPayload payload) {
        Boolean isSpecial = this.check(payload);
        LocalDate startDate = payload.getStartDate();
        LocalDate endDate = payload.getEndDate();
        if (ObjectUtils.isEmpty((Object)startDate)) {
            if (ObjectUtils.isEmpty((Object)endDate) || ObjectUtils.isEmpty((Object)payload.getDurationDays())) {
                throw TwException.error("", "\u7ed3\u675f\u65e5\u671f\u548c\u6301\u7eed\u5de5\u4f5c\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            startDate = endDate.minusDays(30L);
        } else if (ObjectUtils.isEmpty((Object)endDate)) {
            if (ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)payload.getDurationDays())) {
                throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u548c\u6301\u7eed\u5de5\u4f5c\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            endDate = startDate.plusDays(30L);
        } else if (!ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            payload.setEndDate(payload.getStartDate().plusDays(1L));
        }
        PmsProjectCalendarVO vo = new PmsProjectCalendarVO();
        vo.setSourceId(payload.getSourceId());
        vo.setSourceType(payload.getSourceType());
        if (!ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            vo.setStartDate(payload.getStartDate());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            vo.setEndDate(endDate);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDurationDays())) {
            vo.setDurationDays(payload.getDurationDays());
        }
        if (endDate.isBefore(startDate)) {
            vo.setEndDate(endDate);
            vo.setDurationDays(Integer.valueOf(0));
        } else {
            if (payload.getFromCacheFlag().booleanValue()) {
                vo.setCalendarList(this.getDataByDate(calendarCache.get(payload.getSourceType() + payload.getSourceId()), startDate, endDate));
            } else {
                List<ProVacationVO> vacationList = this.getVacationList(startDate, endDate, payload.getProjectId());
                vo.setCalendarList(this.vacationToList(vacationList));
            }
            List list = vo.getCalendarList();
            if (!ObjectUtils.isEmpty((Object)list)) {
                if (ObjectUtils.isEmpty((Object)payload.getDurationDays())) {
                    this.countDurationDays(vo, list);
                } else {
                    if (!ObjectUtils.isEmpty((Object)payload.getStartDate())) {
                        this.countEndDate(vo, list, payload.getDurationDays());
                    }
                    if (!ObjectUtils.isEmpty((Object)payload.getEndDate())) {
                        this.countStartDate(vo, list, payload.getDurationDays());
                    }
                }
            }
        }
        if (isSpecial.booleanValue()) {
            LocalDate endDate0 = vo.getEndDate();
            LocalDate startDate0 = vo.getStartDate();
            vo.setStartDate(endDate0);
            vo.setEndDate(startDate0);
            vo.setDurationDays(Integer.valueOf(0));
        }
        return vo;
    }

    public void handleCalendarCache(List<Long> sourceIds, String sourceType, String handleType, Long projectId) {
        if ("save".equals(handleType)) {
            LocalDate today = LocalDate.now();
            LocalDate startDate = today.minus(1L, ChronoUnit.YEARS);
            LocalDate endDate = today.plus(1L, ChronoUnit.YEARS);
            List<ProVacationVO> vacationList = this.getVacationList(startDate, endDate, projectId);
            List<Map<LocalDate, BigDecimal>> list = this.vacationToList(vacationList);
            for (Long sourceId : sourceIds) {
                String key = sourceType + sourceId;
                if (calendarCache.containsKey(key)) continue;
                calendarCache.put(key, list);
            }
        } else if ("clean".equals(handleType)) {
            calendarCache.clear();
        }
    }

    private List<Map<LocalDate, BigDecimal>> handleCalendar(List<ProVacationVO> vacationList, LocalDate startDate, LocalDate endDate, PmsProjectCalendarDO pmsProjectCalendar) {
        LinkedList<Map<LocalDate, BigDecimal>> list = new LinkedList<Map<LocalDate, BigDecimal>>();
        if (startDate.isBefore(pmsProjectCalendar.getStartDate())) {
            List<ProVacationVO> vacation1 = vacationList.stream().filter(v -> v.getNaturalDate().isEqual(startDate) || v.getNaturalDate().isAfter(startDate) && v.getNaturalDate().isBefore(pmsProjectCalendar.getStartDate())).collect(Collectors.toList());
            list.addAll(this.vacationToList(vacation1));
        }
        list.addAll(this.calendarInfoToList(pmsProjectCalendar.getCalendarInfo(), startDate, endDate));
        if (endDate.isAfter(pmsProjectCalendar.getEndDate())) {
            List<ProVacationVO> vacation2 = vacationList.stream().filter(v -> v.getNaturalDate().isAfter(pmsProjectCalendar.getEndDate()) || v.getNaturalDate().isBefore(endDate) && v.getNaturalDate().isEqual(endDate)).collect(Collectors.toList());
            list.addAll(this.vacationToList(vacation2));
        }
        return this.getDataByDate(list, startDate, endDate);
    }

    private List<Map<LocalDate, BigDecimal>> getDataByDate(List<Map<LocalDate, BigDecimal>> list, LocalDate startDate, LocalDate endDate) {
        LinkedList<Map<LocalDate, BigDecimal>> result = new LinkedList<Map<LocalDate, BigDecimal>>();
        for (Map<LocalDate, BigDecimal> map : list) {
            for (LocalDate date : map.keySet()) {
                HashMap<LocalDate, BigDecimal> m;
                if (date.isBefore(endDate) && date.isAfter(startDate)) {
                    m = new HashMap<LocalDate, BigDecimal>();
                    m.put(date, map.get(date));
                    result.add(m);
                }
                if (!date.isEqual(endDate) && !date.isEqual(startDate)) continue;
                m = new HashMap();
                m.put(date, map.get(date));
                result.add(m);
            }
        }
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveData(PmsProjectCalendarPayload payload) {
        this.nonEmptyValidation(payload);
        this.setFixedShiftSystem(payload);
        PmsProjectCalendarDO calendarDO = this.pmsProjectCalendarRepo.findBySource(payload.getSourceId(), payload.getSourceType());
        if (!ObjectUtils.isEmpty((Object)calendarDO)) {
            calendarDO.setStartDate(payload.getStartDate());
            calendarDO.setEndDate(payload.getEndDate());
            calendarDO.setSetFixedShiftSystemFlag(payload.getSetFixedShiftSystemFlag());
            calendarDO.setHoliday(payload.getHoliday());
            Gson gson = new Gson();
            calendarDO.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            this.pmsProjectCalendarRepo.save(calendarDO);
        } else {
            PmsProjectCalendarDO entityDo = PmsProjectCalendarConvert.INSTANCE.toDo(payload);
            Gson gson = new Gson();
            entityDo.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            this.pmsProjectCalendarRepo.save(entityDo);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<PmsProjectCalendarPayload> list) {
        long count;
        List<Long> ids = list.stream().map(TwCommonPayload::getId).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(ids) && (count = this.pmsProjectCalendarRepo.findCountByKey(ids)) != (long)ids.size()) {
            throw TwException.error("", "\u5b58\u5728\u5de5\u4f5c\u65e5\u5386\u4e3b\u952e\u4e0d\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ArrayList<PmsProjectCalendarDO> doList = new ArrayList<PmsProjectCalendarDO>();
        for (PmsProjectCalendarPayload payload : list) {
            this.nonEmptyValidation(payload);
            this.setFixedShiftSystem(payload);
            PmsProjectCalendarDO entityDo = PmsProjectCalendarConvert.INSTANCE.toDo(payload);
            Gson gson = new Gson();
            entityDo.setCalendarInfo(gson.toJson((Object)payload.getCalendarList()));
            doList.add(entityDo);
        }
        this.pmsProjectCalendarRepo.saveAll(doList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        this.pmsProjectCalendarRepo.deleteByKey(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftBySource(List<Long> sourceIds, String sourceType) {
        this.pmsProjectCalendarRepo.deleteSoftBySource(sourceIds, sourceType);
    }

    private void nonEmptyValidation(PmsProjectCalendarPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getSourceId())) {
            throw TwException.error("", "\u5173\u8054\u4e3b\u952e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSourceType())) {
            throw TwException.error("", "\u5173\u8054\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getStartDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getEndDate())) {
            throw TwException.error("", "\u7ed3\u675f\u65e5\u671f\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    private void setFixedShiftSystem(PmsProjectCalendarPayload payload) {
        if (1 == payload.getSetFixedShiftSystemFlag()) {
            LinkedList info = new LinkedList();
            String holiday = payload.getHoliday();
            LocalDate startDate = payload.getStartDate();
            LocalDate endDate = payload.getEndDate();
            LocalDate currentDate = startDate;
            while (!currentDate.isAfter(endDate)) {
                DayOfWeek dayOfWeek = currentDate.getDayOfWeek();
                int day = dayOfWeek.getValue();
                HashMap<String, Double> m = new HashMap<String, Double>();
                if (!ObjectUtils.isEmpty((Object)holiday) && holiday.contains("" + day)) {
                    m.put(TimeUtil.dateToYmd(currentDate), 0.0);
                } else {
                    m.put(TimeUtil.dateToYmd(currentDate), 8.0);
                }
                info.add(m);
                currentDate = currentDate.plusDays(1L);
            }
            payload.setCalendarList(info);
        }
    }

    private List<ProVacationVO> getVacationList(LocalDate startDate, LocalDate endDate, Long projectId) {
        ProVacationQuery proVacationQuery = new ProVacationQuery();
        proVacationQuery.setNaturalDateStart(startDate);
        proVacationQuery.setNaturalDateEnd(endDate);
        proVacationQuery.setProjectId(projectId);
        List<ProVacationVO> list = this.proVacationService.getList(proVacationQuery);
        if (CollUtil.isEmpty(list)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u6ca1\u6709\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\uff0c\u8bf7\u5148\u8bbe\u7f6e");
        }
        return list.stream().sorted(Comparator.comparing(vo -> vo.getNaturalDate())).collect(Collectors.toList());
    }

    private List<Map<LocalDate, BigDecimal>> vacationToList(List<ProVacationVO> vacationList) {
        LinkedList<Map<LocalDate, BigDecimal>> info = new LinkedList<Map<LocalDate, BigDecimal>>();
        vacationList.forEach(twVacationView -> {
            HashMap<LocalDate, BigDecimal> map = new HashMap<LocalDate, BigDecimal>();
            map.put(twVacationView.getNaturalDate(), twVacationView.getWorkHours());
            info.add(map);
        });
        return info;
    }

    private List<Map<LocalDate, BigDecimal>> calendarInfoToList(String calendarInfo, LocalDate startDate, LocalDate endDate) {
        LinkedList<Map<LocalDate, BigDecimal>> result = new LinkedList<Map<LocalDate, BigDecimal>>();
        Gson gson = new Gson();
        Type listType = new TypeToken<List<Map<String, Object>>>(){}.getType();
        List list = (List)gson.fromJson(calendarInfo, listType);
        for (Map map : list) {
            for (String key : map.keySet()) {
                HashMap<LocalDate, BigDecimal> m;
                LocalDate date = LocalDate.parse(key);
                if (date.isBefore(endDate) && date.isAfter(startDate)) {
                    m = new HashMap<LocalDate, BigDecimal>();
                    m.put(date, new BigDecimal(map.get(key).toString()));
                    result.add(m);
                }
                if (!date.isEqual(endDate) && !date.isEqual(startDate)) continue;
                m = new HashMap();
                m.put(date, new BigDecimal(map.get(key).toString()));
                result.add(m);
            }
        }
        return result;
    }

    private void countEndDate(PmsProjectCalendarVO vo, List<Map<LocalDate, BigDecimal>> list, int durationDays) {
        int count = 0;
        int holiDays = 0;
        LocalDate startDate = null;
        LocalDate endDate = null;
        LinkedList<Map<LocalDate, BigDecimal>> list2 = new LinkedList<Map<LocalDate, BigDecimal>>();
        for (Map<LocalDate, BigDecimal> map : list) {
            list2.add(map);
            BigDecimal value = map.values().iterator().next();
            if (value.compareTo(BigDecimal.ZERO) > 0) {
                if (ObjectUtils.isEmpty(startDate)) {
                    startDate = map.keySet().iterator().next();
                }
                if (++count != durationDays) continue;
                endDate = map.keySet().iterator().next();
                break;
            }
            ++holiDays;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        vo.setHoliDays(Integer.valueOf(holiDays));
        vo.setCalendarList(list2);
    }

    private void countStartDate(PmsProjectCalendarVO vo, List<Map<LocalDate, BigDecimal>> list, int durationDays) {
        Collections.sort(list, new Comparator<Map<LocalDate, BigDecimal>>(){

            @Override
            public int compare(Map<LocalDate, BigDecimal> map1, Map<LocalDate, BigDecimal> map2) {
                LocalDate key1 = map1.keySet().iterator().next();
                LocalDate key2 = map2.keySet().iterator().next();
                return key2.compareTo(key1);
            }
        });
        int count = 0;
        int holiDays = 0;
        LocalDate startDate = null;
        LocalDate endDate = null;
        LinkedList<Map<LocalDate, BigDecimal>> list2 = new LinkedList<Map<LocalDate, BigDecimal>>();
        for (Map<LocalDate, BigDecimal> map : list) {
            list2.add(map);
            BigDecimal value = map.values().iterator().next();
            if (value.compareTo(BigDecimal.ZERO) > 0) {
                if (ObjectUtils.isEmpty(endDate)) {
                    endDate = map.keySet().iterator().next();
                }
                if (++count != durationDays) continue;
                startDate = map.keySet().iterator().next();
                break;
            }
            ++holiDays;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        vo.setHoliDays(Integer.valueOf(holiDays));
        Collections.sort(list2, new Comparator<Map<LocalDate, BigDecimal>>(){

            @Override
            public int compare(Map<LocalDate, BigDecimal> map1, Map<LocalDate, BigDecimal> map2) {
                LocalDate key1 = map1.keySet().iterator().next();
                LocalDate key2 = map2.keySet().iterator().next();
                return key1.compareTo(key2);
            }
        });
        vo.setCalendarList(list2);
    }

    private void countDurationDays(PmsProjectCalendarVO vo, List<Map<LocalDate, BigDecimal>> list) {
        int durationDays = 0;
        int holiDays = 0;
        for (Map<LocalDate, BigDecimal> map : list) {
            boolean hasValueGreaterThanZero = false;
            for (BigDecimal value : map.values()) {
                if (value.doubleValue() > 0.0) {
                    hasValueGreaterThanZero = true;
                    break;
                }
                ++holiDays;
            }
            if (!hasValueGreaterThanZero) continue;
            ++durationDays;
        }
        vo.setHoliDays(Integer.valueOf(holiDays));
        vo.setDurationDays(Integer.valueOf(durationDays));
    }

    public PmsProjectCalendarServiceImpl(PmsProjectCalendarRepo pmsProjectCalendarRepo, ProVacationService proVacationService) {
        this.pmsProjectCalendarRepo = pmsProjectCalendarRepo;
        this.proVacationService = proVacationService;
    }
}

