/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsAcceptService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsAcceptConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsAcceptDao;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsAcceptRepo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsProjectWbsAcceptServiceImpl
implements PmsProjectWbsAcceptService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsAcceptServiceImpl.class);
    private final PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo;
    private final ProRelatedPartiesService proRelatedPartiesService;
    private final PmsDeliverItemService pmsDeliverItemService;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsAcceptVO save(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        this.checkData(pmsProjectWbsAcceptPayload);
        PmsProjectWbsAcceptDO pmsProjectWbsAcceptDO = new PmsProjectWbsAcceptDO();
        pmsProjectWbsAcceptDO = PmsProjectWbsAcceptConvert.INSTANCE.p2d(pmsProjectWbsAcceptPayload);
        PmsProjectWbsAcceptDO res = (PmsProjectWbsAcceptDO)((Object)this.pmsProjectWbsAcceptRepo.save((Object)pmsProjectWbsAcceptDO));
        return PmsProjectWbsAcceptConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsAcceptVO updateAll(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PmsProjectWbsAcceptVO res = this.save(pmsProjectWbsAcceptPayload);
        return res;
    }

    public PmsProjectWbsAcceptVO get(Long id) {
        if (null == id) {
            return null;
        }
        PmsProjectWbsAcceptVO res = this.pmsProjectWbsAcceptDao.get(id);
        return res;
    }

    public PagingVO<PmsProjectWbsAcceptVO> page(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {
        PagingVO<PmsProjectWbsAcceptVO> res = this.pmsProjectWbsAcceptDao.page(pmsProjectWbsAcceptQuery);
        List records = res.getRecords();
        this.translate(records);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.pmsProjectWbsAcceptDao.del(ids);
        return res;
    }

    public List<PmsProjectWbsAcceptVO> getList(PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery) {
        List<PmsProjectWbsAcceptVO> res = this.pmsProjectWbsAcceptDao.getList(pmsProjectWbsAcceptQuery);
        this.translate(res);
        return res;
    }

    public List<PmsProjectWbsAcceptVO> listByContentAndTypeEqualZero(List<String> contents) {
        List<PmsProjectWbsAcceptVO> res = this.pmsProjectWbsAcceptDao.listByContent(contents);
        return res;
    }

    private void translate(List<PmsProjectWbsAcceptVO> res) {
        if (!CollectionUtil.isEmpty(res)) {
            res.forEach(x -> {
                Long deliverId;
                PmsDeliverItemVO pmsDeliverItemVO;
                String content;
                ProRelatedPartiesVO proRelatedPartiesVO;
                if (null != x.getManagerUserId() && null != (proRelatedPartiesVO = this.proRelatedPartiesService.get(x.getManagerUserId()))) {
                    x.setManagerUserName(proRelatedPartiesVO.getName());
                }
                if (x.getType() != null && x.getType() == 0 && org.springframework.util.StringUtils.hasText((String)(content = x.getContent())) && null != (pmsDeliverItemVO = this.pmsDeliverItemService.get(deliverId = Long.valueOf(content)))) {
                    x.setContentDesc(pmsDeliverItemVO.getName());
                }
            });
        }
    }

    private void checkData(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getWbsId(), (String)"wbsid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getWbsCode(), (String)"wbscode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getWbsId(), (String)"versionId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getWbsId(), (String)"versionNo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload) {
        Assert.notNull((Object)pmsProjectWbsAcceptPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean saveAll(List<PmsProjectWbsAcceptPayload> pmsProjectWbsAcceptPayloadList) {
        if (CollUtil.isEmpty(pmsProjectWbsAcceptPayloadList)) {
            return false;
        }
        Long wbsId = pmsProjectWbsAcceptPayloadList.get(0).getWbsId();
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(wbsId);
        if (null == pmsProjectWbsVO) {
            throw new BusinessException("wbsId\u672a\u627e\u5230:" + wbsId);
        }
        this.pmsProjectWbsAcceptDao.delByWbsId(List.of(wbsId));
        ArrayList<PmsProjectWbsAcceptDO> list = new ArrayList<PmsProjectWbsAcceptDO>();
        for (PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload : pmsProjectWbsAcceptPayloadList) {
            pmsProjectWbsAcceptPayload.setWbsCode(pmsProjectWbsVO.getWbsCode());
            this.checkData(pmsProjectWbsAcceptPayload);
            PmsProjectWbsAcceptDO pmsProjectWbsAcceptDO = new PmsProjectWbsAcceptDO();
            pmsProjectWbsAcceptDO = PmsProjectWbsAcceptConvert.INSTANCE.p2d(pmsProjectWbsAcceptPayload);
            list.add(pmsProjectWbsAcceptDO);
        }
        this.pmsProjectWbsAcceptDao.save(list);
        list.stream().filter(x -> x.getType() == 0 && StringUtils.isNotBlank((CharSequence)x.getContent())).forEach(x -> {
            String content = x.getContent();
            Long deliverId = Long.valueOf(content);
            PmsDeliverItemPayload updateDeliverItemPayload = new PmsDeliverItemPayload();
            updateDeliverItemPayload.setId(deliverId);
            updateDeliverItemPayload.setWbsId(wbsId);
            updateDeliverItemPayload.setWbsName(pmsProjectWbsVO.getWbsName());
            updateDeliverItemPayload.setDirectorRelatedPartiesId(x.getManagerUserId());
            this.pmsDeliverItemService.update(updateDeliverItemPayload);
        });
        this.updateWbsStatus(wbsId);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean updateWbsStatus(Long wbsId) {
        PmsProjectWbsVO pmsProjectWbsVOZero;
        if (null == wbsId) {
            throw new BusinessException("wbsId\u672a\u627e\u5230:" + wbsId);
        }
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(wbsId);
        if (null == pmsProjectWbsVO) {
            throw new BusinessException("wbsId\u672a\u627e\u5230:" + wbsId);
        }
        PmsProjectWbsAcceptQuery queryAll = new PmsProjectWbsAcceptQuery();
        queryAll.setWbsId(wbsId);
        Long count = this.pmsProjectWbsAcceptDao.count(queryAll);
        PmsProjectWbsAcceptQuery queryOk = new PmsProjectWbsAcceptQuery();
        queryOk.setWbsId(wbsId);
        queryOk.setAcceptanceStatus(Integer.valueOf(1));
        Long countOk = this.pmsProjectWbsAcceptDao.count(queryOk);
        if (count > 0L && countOk.equals(count)) {
            PmsProjectWbsPayload pmsProjectWbsPayload = new PmsProjectWbsPayload();
            pmsProjectWbsPayload.setId(wbsId);
            pmsProjectWbsPayload.setEndDate(LocalDate.now());
            pmsProjectWbsPayload.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
            this.pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
            Long effRelateId = pmsProjectWbsVO.getEffRelateId();
            if (null != effRelateId) {
                PmsProjectWbsPayload pmsProjectWbsPayloadV0 = new PmsProjectWbsPayload();
                pmsProjectWbsPayloadV0.setId(effRelateId);
                pmsProjectWbsPayloadV0.setEndDate(LocalDate.now());
                pmsProjectWbsPayloadV0.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                this.pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayloadV0);
            }
        }
        Long v0WbsId = pmsProjectWbsVO.getEffRelateId();
        boolean updateV0 = false;
        if (pmsProjectWbsVO.getWbsStatus().equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
            Long currentVersionId = pmsProjectWbsVO.getVersionId();
            if (null != v0WbsId) {
                PmsProjectWbsAcceptQuery queryV0 = new PmsProjectWbsAcceptQuery();
                queryV0.setWbsId(v0WbsId);
                Long countV0 = this.pmsProjectWbsAcceptDao.count(queryV0);
                PmsProjectWbsAcceptQuery queryCurrent = new PmsProjectWbsAcceptQuery();
                queryCurrent.setWbsId(wbsId);
                queryCurrent.setVersionId(currentVersionId);
                Long countCurrent = this.pmsProjectWbsAcceptDao.count(queryCurrent);
                PmsProjectWbsAcceptQuery queryUnAcceptanceStatus = new PmsProjectWbsAcceptQuery();
                queryUnAcceptanceStatus.setWbsId(wbsId);
                queryUnAcceptanceStatus.setVersionId(currentVersionId);
                queryUnAcceptanceStatus.setAcceptanceStatus(Integer.valueOf(0));
                Long countUnAcceptanceStatus = this.pmsProjectWbsAcceptDao.count(queryUnAcceptanceStatus);
                if (countCurrent > countV0 || countUnAcceptanceStatus > 0L) {
                    this.pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(wbsId, ProjectWbsStatusEnum.NOSTART.getCode());
                    this.pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(v0WbsId, ProjectWbsStatusEnum.NOSTART.getCode());
                }
            }
        }
        if (null != v0WbsId && (pmsProjectWbsVOZero = this.pmsProjectWbsDAO.queryByKey(v0WbsId)).getWbsStatus().equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
            Long currentVersionId = pmsProjectWbsVO.getVersionId();
            PmsProjectWbsAcceptQuery queryV0 = new PmsProjectWbsAcceptQuery();
            queryV0.setWbsId(v0WbsId);
            Long countV0 = this.pmsProjectWbsAcceptDao.count(queryV0);
            PmsProjectWbsAcceptQuery queryCurrent = new PmsProjectWbsAcceptQuery();
            queryCurrent.setWbsId(wbsId);
            queryCurrent.setVersionId(currentVersionId);
            Long countCurrent = this.pmsProjectWbsAcceptDao.count(queryCurrent);
            PmsProjectWbsAcceptQuery queryUnAcceptanceStatus = new PmsProjectWbsAcceptQuery();
            queryUnAcceptanceStatus.setWbsId(wbsId);
            queryUnAcceptanceStatus.setVersionId(currentVersionId);
            queryUnAcceptanceStatus.setAcceptanceStatus(Integer.valueOf(0));
            Long countUnAcceptanceStatus = this.pmsProjectWbsAcceptDao.count(queryUnAcceptanceStatus);
            if (countCurrent > countV0 || countUnAcceptanceStatus > 0L) {
                this.pmsProjectWbsDAO.updateWbsStatusAndEndDateIsNull(v0WbsId, ProjectWbsStatusEnum.NOSTART.getCode());
            }
        }
        return true;
    }

    public PmsProjectWbsAcceptServiceImpl(PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao, PmsProjectWbsDAO pmsProjectWbsDAO, PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo, ProRelatedPartiesService proRelatedPartiesService, PmsDeliverItemService pmsDeliverItemService) {
        this.pmsProjectWbsAcceptDao = pmsProjectWbsAcceptDao;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.pmsProjectWbsAcceptRepo = pmsProjectWbsAcceptRepo;
        this.proRelatedPartiesService = proRelatedPartiesService;
        this.pmsDeliverItemService = pmsDeliverItemService;
    }
}

