/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ResourceCostStrategyVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.ResourceCostStrategyService;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsResourceConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsResourceDao;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsResourceDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsResourceRepo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsProjectWbsResourceServiceImpl
implements PmsProjectWbsResourceService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsResourceServiceImpl.class);
    private final PmsProjectWbsResourceDao pmsProjectWbsResourceDao;
    private final PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo;
    private final ProRelatedPartiesService proRelatedPartiesService;
    private final PmsProjectRoleService pmsProjectRoleService;
    private final ResourceCostStrategyService resourceCostStrategyService;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsResourceVO save(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        this.checkData(pmsProjectWbsResourcePayload);
        PmsProjectWbsResourceDO pmsProjectWbsResourceDO = new PmsProjectWbsResourceDO();
        pmsProjectWbsResourceDO = PmsProjectWbsResourceConvert.INSTANCE.p2d(pmsProjectWbsResourcePayload);
        PmsProjectWbsResourceDO res = (PmsProjectWbsResourceDO)((Object)this.pmsProjectWbsResourceRepo.save((Object)pmsProjectWbsResourceDO));
        return PmsProjectWbsResourceConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsResourceVO updateAll(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PmsProjectWbsResourceVO res = this.save(pmsProjectWbsResourcePayload);
        return res;
    }

    public PmsProjectWbsResourceVO get(Long id) {
        if (null == id) {
            return null;
        }
        PmsProjectWbsResourceVO res = this.pmsProjectWbsResourceDao.get(id);
        this.trans(List.of(res));
        return res;
    }

    public PagingVO<PmsProjectWbsResourceVO> page(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {
        PagingVO<PmsProjectWbsResourceVO> res = this.pmsProjectWbsResourceDao.page(pmsProjectWbsResourceQuery);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.pmsProjectWbsResourceDao.del(ids);
        return res;
    }

    public List<PmsProjectWbsResourceVO> getList(PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery) {
        List<PmsProjectWbsResourceVO> res = this.pmsProjectWbsResourceDao.getList(pmsProjectWbsResourceQuery);
        this.trans(res);
        return res;
    }

    private void trans(List<PmsProjectWbsResourceVO> res) {
        List collect = res.stream().map(x -> x.getRelatePartiesId()).collect(Collectors.toList());
        List roleIds = res.stream().map(x -> x.getRoleId()).collect(Collectors.toList());
        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
        proRelatedPartiesQuery.setIdList(collect);
        List list = this.proRelatedPartiesService.getList(proRelatedPartiesQuery);
        Map<Long, String> relateMap = list.stream().collect(Collectors.toMap(BaseViewModel::getId, ProRelatedPartiesVO::getName, (t1, t2) -> t1));
        PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
        pmsProjectRoleQuery.setIds(roleIds);
        List pmsProjectRoleVOS = this.pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);
        Map<Long, String> roleMap = pmsProjectRoleVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, PmsProjectRoleVO::getRoleName, (t1, t2) -> t1));
        TwOutputUtil<List<ResourceCostStrategyVO>> listTwOutputUtil = this.resourceCostStrategyService.queryList(new ResourceCostStrategyQuery());
        List<ResourceCostStrategyVO> resourceCostStrategyVOList = listTwOutputUtil.getData();
        ResourceCostStrategyVO resourceCostStrategyVO = new ResourceCostStrategyVO();
        resourceCostStrategyVO.setType(Integer.valueOf(1));
        if (CollUtil.isNotEmpty(resourceCostStrategyVOList)) {
            resourceCostStrategyVO = resourceCostStrategyVOList.get(0);
        }
        for (PmsProjectWbsResourceVO x2 : res) {
            x2.setRelatePartiesName(relateMap.get(x2.getRelatePartiesId()));
            x2.setRoleName(roleMap.get(x2.getRoleId()));
            if (resourceCostStrategyVO.getType() != 1) continue;
            x2.setReferenceEqvaRatio(BigDecimal.ONE);
        }
    }

    private void checkData(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getWbsId(), (String)"wbsId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getRelatePartiesId(), (String)"\u76f8\u5173\u65b9Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getVersionId(), (String)"versionId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getVersionNo(), (String)"versionNo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload) {
        Assert.notNull((Object)pmsProjectWbsResourcePayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.pmsProjectWbsResourceDao.update(pmsProjectWbsResourcePayload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean saveAll(List<PmsProjectWbsResourcePayload> pmsProjectWbsResourcePayload) {
        ArrayList<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<PmsProjectWbsResourceDO>();
        if (CollUtil.isNotEmpty(pmsProjectWbsResourcePayload)) {
            List<Long> wbsIds = pmsProjectWbsResourcePayload.stream().map(x -> x.getWbsId()).collect(Collectors.toList());
            this.pmsProjectWbsResourceDao.delByWbsIds(wbsIds);
            for (PmsProjectWbsResourcePayload projectWbsResourcePayload : pmsProjectWbsResourcePayload) {
                this.checkData(projectWbsResourcePayload);
                PmsProjectWbsResourceDO pmsProjectWbsResourceDO = new PmsProjectWbsResourceDO();
                pmsProjectWbsResourceDO = PmsProjectWbsResourceConvert.INSTANCE.p2d(projectWbsResourcePayload);
                pmsProjectWbsResourceDOList.add(pmsProjectWbsResourceDO);
            }
            this.pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);
        }
        return true;
    }

    public PmsProjectWbsResourceServiceImpl(PmsProjectWbsResourceDao pmsProjectWbsResourceDao, PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo, ProRelatedPartiesService proRelatedPartiesService, PmsProjectRoleService pmsProjectRoleService, ResourceCostStrategyService resourceCostStrategyService) {
        this.pmsProjectWbsResourceDao = pmsProjectWbsResourceDao;
        this.pmsProjectWbsResourceRepo = pmsProjectWbsResourceRepo;
        this.proRelatedPartiesService = proRelatedPartiesService;
        this.pmsProjectRoleService = pmsProjectRoleService;
        this.resourceCostStrategyService = resourceCostStrategyService;
    }
}

