/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowConfigPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowConfigRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowConfigDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StateFlowConfigServiceImpl
implements StateFlowConfigService {
    private static final Logger log = LoggerFactory.getLogger(StateFlowConfigServiceImpl.class);
    private final StateFlowConfigDao stateFlowConfigDao;
    private final StateFlowConfigRepo stateFlowConfigRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StateFlowConfigVO save(StateFlowConfigPayload stateFlowConfigPayload) {
        if (null == stateFlowConfigPayload.getState()) {
            stateFlowConfigPayload.setState(1);
        }
        this.checkData(stateFlowConfigPayload);
        StateFlowConfigDO stateFlowConfigDO = new StateFlowConfigDO();
        stateFlowConfigDO = StateFlowConfigConvert.INSTANCE.p2d(stateFlowConfigPayload);
        StateFlowConfigDO res = (StateFlowConfigDO)((Object)this.stateFlowConfigRepo.save((Object)stateFlowConfigDO));
        return StateFlowConfigConvert.INSTANCE.d2v(res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StateFlowConfigVO updateAll(StateFlowConfigPayload stateFlowConfigPayload) {
        Assert.notNull((Object)stateFlowConfigPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        StateFlowConfigVO res = this.save(stateFlowConfigPayload);
        return res;
    }

    @Override
    public StateFlowConfigVO get(Long id) {
        if (null == id) {
            return null;
        }
        StateFlowConfigVO res = this.stateFlowConfigDao.get(id);
        return res;
    }

    @Override
    public PagingVO<StateFlowConfigVO> page(StateFlowConfigQuery stateFlowConfigQuery) {
        PagingVO<StateFlowConfigVO> res = this.stateFlowConfigDao.page(stateFlowConfigQuery);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.stateFlowConfigDao.del(ids);
        return res;
    }

    @Override
    public List<StateFlowConfigVO> getList(StateFlowConfigQuery stateFlowConfigQuery) {
        List<StateFlowConfigVO> res = this.stateFlowConfigDao.getList(stateFlowConfigQuery);
        return res;
    }

    private void checkData(StateFlowConfigPayload stateFlowConfigPayload) {
        Assert.notNull((Object)stateFlowConfigPayload.getConfigFlowId(), (String)"\u914d\u7f6e\u6d41id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)stateFlowConfigPayload.getConfigFlowCode(), (String)"\u914d\u7f6e\u6d41code\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(StateFlowConfigPayload stateFlowConfigPayload) {
        Assert.notNull((Object)stateFlowConfigPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.stateFlowConfigDao.update(stateFlowConfigPayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delByFlowId(Long flowId) {
        Long res = this.stateFlowConfigDao.delByFlowId(flowId);
        return res > 0L;
    }

    public StateFlowConfigServiceImpl(StateFlowConfigDao stateFlowConfigDao, StateFlowConfigRepo stateFlowConfigRepo) {
        this.stateFlowConfigDao = stateFlowConfigDao;
        this.stateFlowConfigRepo = stateFlowConfigRepo;
    }
}

