/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.provacation.controller;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/proVacation"})
@Api(value="\u9879\u76ee\u5047\u671f", tags={"\u9879\u76ee\u5047\u671f"})
public class ProVacationController {
    private final ProVacationService proVacationService;

    @GetMapping(value={"get"})
    @ApiOperation(value="\u8be6\u60c5-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<ProVacationVO> get(Long id) {
        ProVacationVO res = this.proVacationService.get(id);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<Boolean> save(@RequestBody ProVacationPayload proVacationPayload) {
        List<Map<String, BigDecimal>> list = proVacationPayload.getMapList();
        ArrayList<ProVacationPayload> vacationPlayloadList = new ArrayList<ProVacationPayload>();
        list.forEach(o -> {
            Map map = o;
            Set keys = map.keySet();
            keys.forEach(key -> {
                ProVacationPayload vacationPlayload = new ProVacationPayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setWorkHours((BigDecimal)map.get(key));
                vacationPlayload.setProjectId(proVacationPayload.getProjectId());
                vacationPlayload.setType(proVacationPayload.getType());
                vacationPlayloadList.add(vacationPlayload);
            });
        });
        Boolean res = this.proVacationService.saveAll(vacationPlayloadList, proVacationPayload.getProjectId(), proVacationPayload.getYear());
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<Long> update(@RequestBody ProVacationPayload proVacationPayload) {
        Long res = this.proVacationService.update(proVacationPayload);
        return TwOutputUtil.ok(res);
    }

    @DeleteMapping(value={"del"})
    @ApiOperation(value="\u5220\u9664-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
        Long res = this.proVacationService.del(ids);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/page"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<PagingVO<ProVacationVO>> page(@RequestBody ProVacationQuery proVacationQuery) {
        PagingVO<ProVacationVO> res = this.proVacationService.page(proVacationQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"getList"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2-\u9879\u76ee\u5047\u671f")
    public TwOutputUtil<List<ProVacationVO>> getList(ProVacationQuery proVacationQuery) {
        List<ProVacationVO> res = this.proVacationService.getList(proVacationQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/{year}/{projectId}"})
    @ApiOperation(value="\u5e74\u5ea6-\u9879\u76ee\u5047\u671f\u67e5\u8be2")
    public TwOutputUtil<List<Map<String, BigDecimal>>> findVacation(@PathVariable int year, @PathVariable Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProVacationQuery proVacationQuery = new ProVacationQuery();
        proVacationQuery.setYear(year);
        proVacationQuery.setProjectId(projectId);
        List<ProVacationVO> list = this.proVacationService.getList(proVacationQuery);
        ArrayList mapList = new ArrayList();
        list.forEach(twVacationView -> {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            map.put(TimeUtil.dateToYmd(twVacationView.getNaturalDate()), twVacationView.getWorkHours());
            mapList.add(map);
        });
        return TwOutputUtil.ok(mapList);
    }

    public ProVacationController(ProVacationService proVacationService) {
        this.proVacationService = proVacationService;
    }
}

