/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.task.dao.PmsTaskRouteDtlDao;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteDtlService;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsTaskRouteDtlServiceImpl
implements PmsTaskRouteDtlService {
    private static final Logger log = LoggerFactory.getLogger(PmsTaskRouteDtlServiceImpl.class);
    private final PmsTaskRouteDtlDao dao;
    private final TaskInfoService taskInfoService;

    @Override
    public TwOutputUtil<PagingVO<PmsTaskRouteDtlVO>> queryPage(PmsTaskRouteDtlQuery query) {
        PagingVO<PmsTaskRouteDtlVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsTaskRouteDtlVO>> queryList(PmsTaskRouteDtlQuery query) {
        List<PmsTaskRouteDtlVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsTaskRouteDtlQuery query) {
        return TwOutputUtil.ok(this.dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteDtlVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsTaskRouteDtlVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> insert(PmsTaskRouteDtlPayload payload) {
        this.checkData(payload);
        PmsTaskRouteDtlVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> update(PmsTaskRouteDtlPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsTaskRouteDtlVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsTaskRouteDtlVO> updateDynamic(PmsTaskRouteDtlPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return TwOutputUtil.ok(this.dao.deleteSoft(ids));
    }

    @Override
    public TwOutputUtil<PmsTaskRouteDtlVO> childList(PmsTaskRouteDtlQuery query) {
        Assert.notNull((Object)query.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)query.getMasId(), (String)"masId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (query.getParentId() == null) {
            query.setParentId(Long.valueOf(0L));
        }
        TwOutputUtil<List<PmsTaskRouteDtlVO>> listTwOutputUtil = this.queryList(query);
        PmsTaskRouteDtlVO pmsV0TaskRouteDtlVO = listTwOutputUtil.getData().get(0);
        Long v0Id = pmsV0TaskRouteDtlVO.getId();
        query.setParentId(v0Id);
        List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS1 = this.childData(query);
        pmsV0TaskRouteDtlVO.setChildren(pmsTaskRouteDtlVOS1);
        return TwOutputUtil.ok(pmsV0TaskRouteDtlVO);
    }

    private List<PmsTaskRouteDtlVO> childData(PmsTaskRouteDtlQuery query) {
        TwOutputUtil<List<PmsTaskRouteDtlVO>> listTwOutputUtil = this.queryList(query);
        for (PmsTaskRouteDtlVO pmsTaskRouteDtlVO : listTwOutputUtil.getData()) {
            query.setParentId(pmsTaskRouteDtlVO.getId());
            List<PmsTaskRouteDtlVO> pmsTaskRouteDtlVOS = this.childData(query);
            pmsTaskRouteDtlVO.setChildren(pmsTaskRouteDtlVOS);
        }
        return listTwOutputUtil.getData();
    }

    private TwOutputUtil<Long> startWorkFlow(PmsTaskRouteDtlPayload payload) {
        HashMap varMaps = new HashMap();
        String procInstId = "";
        Long update = this.dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    private void checkData(PmsTaskRouteDtlPayload payload) {
        Assert.notNull((Object)payload.getMasId(), (String)"\u8def\u7ebf\u56feid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void translate(List<PmsTaskRouteDtlVO> vos) {
        vos.forEach(vo -> {
            if (null != vo.getTaskId()) {
                TaskInfoVO taskInfoVO = this.taskInfoService.queryByKey(vo.getTaskId(), Boolean.valueOf(false));
                vo.setTaskName(taskInfoVO.getTaskName());
                vo.setTaskNo(taskInfoVO.getTaskNo());
                vo.setStateFlowId(taskInfoVO.getStateFlowId());
                vo.setStateFlowName(taskInfoVO.getStateFlowName());
                vo.setPlanStartDate(taskInfoVO.getPlanStartDate());
                vo.setPlanEndDate(taskInfoVO.getPlanEndDate());
                vo.setTaskResId(taskInfoVO.getTaskResId());
                vo.setTaskRes(taskInfoVO.getTaskRes());
                vo.setTaskDes(taskInfoVO.getTaskDes());
                vo.setPriority(taskInfoVO.getPriority());
            }
        });
    }

    public PmsTaskRouteDtlServiceImpl(PmsTaskRouteDtlDao dao, TaskInfoService taskInfoService) {
        this.dao = dao;
        this.taskInfoService = taskInfoService;
    }
}

