/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ComLogTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationSettingService;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskMemberRefObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskMemberRefTypeEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProGroupEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProPriorityEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProStatusEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskProConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskProDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProBoardViewGroupInfoVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskProRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskProDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskMemberRefService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.impl.TaskProCostUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.support.TaskProEventFactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskProServiceImpl
extends BaseServiceImpl
implements TaskProService {
    private static final Logger log = LoggerFactory.getLogger(TaskProServiceImpl.class);
    private final TaskProRepo taskProRepo;
    private final TaskProDAO taskProDAO;
    private final TaskMemberRefService taskMemberRefService;
    private final TaskCategoryService taskCategoryService;
    @Resource
    private ProRelatedPartiesService proRelatedPartiesService;
    private final StateFlowService stateFlowService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final PmsProjectWbsService pmsProjectWbsService;
    private final ProVacationSettingService proVacationSettingService;
    private final PmsProjectRoleService pmsProjectRoleService;
    @Resource
    private PmsWbsBudgetDetailsService pmsWbsBudgetDetailsService;

    @Override
    public PagingVO<TaskProVO> queryPaging(TaskProQuery query) {
        ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
        taskOrderItemList.add(OrderItem.desc((String)"topFlag"));
        taskOrderItemList.add(OrderItem.desc((String)"topModifyTime"));
        taskOrderItemList.add(OrderItem.desc((String)"sort"));
        taskOrderItemList.add(OrderItem.desc((String)"createTime"));
        query.setOrders(taskOrderItemList);
        if (ObjectUtils.isEmpty((Object)query.getSearchType())) {
            query.setSearchType(TaskProGroupEnum.ALL_ALL.getCode());
        }
        String searchType = query.getSearchType();
        PagingVO<TaskProVO> pagingVO = PagingVO.empty();
        Long reasonId = query.getReasonId();
        if (searchType.equals(TaskProGroupEnum.ALL_ALL.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listSimple.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
            query.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(query.getRelatedIdList())) {
                relatedIdList.add(9999L);
                query.setRelatedIdList(relatedIdList);
            }
            pagingVO = this.taskProDAO.queryPaging(query);
        } else if (searchType.equals(TaskProGroupEnum.MY_CREATE.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (null != reasonId) {
                List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
                if (!CollectionUtils.isEmpty(listSimple)) {
                    ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                    Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                    query.setCreateRelatedPartiesId(relatedPartiesVOId);
                    pagingVO = this.taskProDAO.queryPaging(query);
                }
            } else {
                query.setCreateUserId(loginUserId);
                pagingVO = this.taskProDAO.queryPaging(query);
            }
        } else if (searchType.equals(TaskProGroupEnum.MY_DIRECTOR.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                query.setDirectorRelatedPartiesId(relatedPartiesVOId);
                pagingVO = this.taskProDAO.queryPaging(query);
            }
        } else if (searchType.equals(TaskProGroupEnum.MY_FOLLOW.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                pagingVO = this.taskProDAO.queryPagingLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
            }
        } else if (searchType.equals(TaskProGroupEnum.MY_PART.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                pagingVO = this.taskProDAO.queryPagingLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
            }
        } else {
            pagingVO = this.taskProDAO.queryPaging(query);
        }
        pagingVO.getRecords().forEach(vo -> this.translate((TaskProVO)vo));
        return pagingVO;
    }

    private List<ProRelatedPartiesVO> getProRelatedPartiesVOS(Long reasonId, Long loginUserId) {
        ProRelatedPartiesQuery relatedPartiesQuery = new ProRelatedPartiesQuery();
        relatedPartiesQuery.setProId(reasonId);
        relatedPartiesQuery.setUserId(loginUserId);
        List listSimple = this.proRelatedPartiesService.getListSimple(relatedPartiesQuery);
        return listSimple;
    }

    @Override
    public List<TaskProVO> queryListDynamic(TaskProQuery query) {
        ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
        taskOrderItemList.add(OrderItem.desc((String)"topFlag"));
        taskOrderItemList.add(OrderItem.desc((String)"topModifyTime"));
        taskOrderItemList.add(OrderItem.desc((String)"sort"));
        taskOrderItemList.add(OrderItem.desc((String)"createTime"));
        query.setOrders(taskOrderItemList);
        return this.taskProDAO.queryListDynamic(query);
    }

    @Override
    public Long count(TaskProQuery query) {
        return this.taskProDAO.count(query);
    }

    @Override
    public List<TaskProVO> tree(TaskProQuery query) {
        ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
        taskOrderItemList.add(OrderItem.desc((String)"topFlag"));
        taskOrderItemList.add(OrderItem.desc((String)"topModifyTime"));
        taskOrderItemList.add(OrderItem.desc((String)"sort"));
        taskOrderItemList.add(OrderItem.desc((String)"createTime"));
        query.setOrders(taskOrderItemList);
        List<TaskProVO> taskProVOS = this.taskProDAO.queryListDynamic(query);
        List<TaskProVO> tree = this.buildTree(taskProVOS);
        return tree;
    }

    public List<TaskProVO> buildTree(List<TaskProVO> categoryVOList) {
        List<Object> trees = new ArrayList<TaskProVO>();
        HashSet<Long> ids = new HashSet<Long>();
        for (TaskProVO categoryDTO : categoryVOList) {
            if (categoryDTO.getParentId() == null) {
                trees.add(categoryDTO);
            }
            for (TaskProVO it : categoryVOList) {
                if (!categoryDTO.getId().equals(it.getParentId())) continue;
                if (categoryDTO.getChildren() == null) {
                    categoryDTO.setChildren(new ArrayList());
                }
                categoryDTO.getChildren().add(it);
                ids.add(it.getId());
            }
        }
        if (trees.size() == 0) {
            trees = categoryVOList.stream().filter(s -> !ids.contains(s.getId())).collect(Collectors.toList());
        }
        return trees;
    }

    @Override
    public TaskProVO queryByKey(Long key) {
        TaskProDO entity = this.taskProRepo.findById(key).orElseGet(TaskProDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        TaskProVO vo = TaskProConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    @Override
    public void translate(TaskProVO vo) {
        Long taskId = vo.getId();
        TaskMemberRefQuery taskMemberRefQuery = new TaskMemberRefQuery();
        taskMemberRefQuery.setTaskId(taskId);
        taskMemberRefQuery.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        List<TaskMemberRefVO> taskMemberRefVOS = this.taskMemberRefService.queryListDynamic(taskMemberRefQuery);
        vo.setTaskMemberRefList(taskMemberRefVOS);
        List memberFollowIdList = taskMemberRefVOS.stream().filter(taskMemberRefVO -> taskMemberRefVO.getObjType().equals(TaskMemberRefObjTypeEnum.FOLLOW.getCode())).map(TaskMemberRefVO::getObjId).collect(Collectors.toList());
        vo.setMemberFollowIdList(memberFollowIdList);
        if (!CollectionUtils.isEmpty(memberFollowIdList)) {
            ProRelatedPartiesQuery proRelatedPartiesFollowQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesFollowQuery.setIdList(memberFollowIdList);
            List memberFollowVos = this.proRelatedPartiesService.getList(proRelatedPartiesFollowQuery);
            List memberFollowNameList = memberFollowVos.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.toList());
            vo.setMemberFollowNameList(memberFollowNameList);
        }
        List memberPartIdList = taskMemberRefVOS.stream().filter(taskMemberRefVO -> taskMemberRefVO.getObjType().equals(TaskMemberRefObjTypeEnum.PART.getCode())).map(TaskMemberRefVO::getObjId).collect(Collectors.toList());
        vo.setMemberPartIdList(memberPartIdList);
        if (!CollectionUtils.isEmpty(memberPartIdList)) {
            ProRelatedPartiesQuery proRelatedPartiesPartQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesPartQuery.setIdList(memberPartIdList);
            List memberPartVos = this.proRelatedPartiesService.getList(proRelatedPartiesPartQuery);
            List memberPartNameList = memberPartVos.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.toList());
            vo.setMemberPartNameList(memberPartNameList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskProVO insert(TaskProPayload payload) {
        this.check(payload);
        this.initData(payload);
        TaskProDO entityDo = TaskProConvert.INSTANCE.toDo(payload);
        TaskProDO save = (TaskProDO)this.taskProRepo.save(entityDo);
        Long taskId = save.getId();
        StringBuilder fieldsUpdateLog = new StringBuilder();
        this.taskMemberDataProcess(fieldsUpdateLog, payload, taskId);
        this.logService.saveNewLog(entityDo.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), "\u521b\u5efa\u4e86\u4efb\u52a1");
        if (save.getWbsId() != null) {
            TaskProEventFactory.SERVICE_MAP.forEach((taskProEventEnum, taskProEventService) -> taskProEventService.taskCreateOk(save));
        }
        return TaskProConvert.INSTANCE.toVo(save);
    }

    private void check(TaskProPayload payload) {
        if (!ObjectUtils.isEmpty((Object)payload.getReasonType()) && payload.getReasonType().equals(TaskReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            Long reasonId = payload.getReasonId();
            Assert.notNull((Object)reasonId, (String)"reasonId\u4e0d\u80fd\u4e3a\u7a7a");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (CollectionUtils.isEmpty(listSimple)) {
                throw TwException.error("", "\u60a8\u672a\u52a0\u5165\u5f53\u524d\u9879\u76ee\uff0c\u65e0\u6743\u9650\u521b\u5efa\u4efb\u52a1");
            }
            ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
            Long relatedPartiesVOId = proRelatedPartiesVO.getId();
            payload.setCreateRelatedPartiesId(relatedPartiesVOId);
            payload.setCreateRelatedPartiesName(proRelatedPartiesVO.getName());
        }
        Assert.hasText((String)payload.getTaskName(), (String)"\u4efb\u52a1\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getTaskCategoryId(), (String)"\u4efb\u52a1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getPriority(), (String)"\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getDirectorRelatedPartiesId(), (String)"\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getPlanStartDate(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)payload.getPlanEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Long wbsId = payload.getWbsId();
        if (null != wbsId) {
            PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsService.queryByKey(wbsId);
            Long directorRelatedPartiesId = payload.getDirectorRelatedPartiesId();
            this.checkWbsBudget(payload, directorRelatedPartiesId, wbsId, pmsProjectWbsVO);
        }
    }

    private void checkWbsBudget(TaskProPayload payload, Long directorRelatedPartiesId, Long wbsId, PmsProjectWbsVO pmsProjectWbsVO) {
        Long directorRelatedPartiesRoleId;
        BigDecimal workHours = null;
        BigDecimal unitPrice = null;
        BigDecimal predictWorkHours = payload.getPredictWorkHours();
        ProVacationSettingQuery vacationSettingQuery = new ProVacationSettingQuery();
        int year = LocalDate.now().getYear();
        vacationSettingQuery.setYear(year);
        vacationSettingQuery.setProjectId(payload.getReasonId());
        List<ProVacationSettingVO> list = this.proVacationSettingService.getList(vacationSettingQuery);
        if (!CollectionUtils.isEmpty(list)) {
            ProVacationSettingVO proVacationSettingVO = list.get(0);
            workHours = proVacationSettingVO.getWorkHours();
        }
        if (null != (directorRelatedPartiesRoleId = payload.getDirectorRelatedPartiesRoleId())) {
            PmsProjectRoleVO pmsProjectRoleVO = this.pmsProjectRoleService.queryByKey(directorRelatedPartiesRoleId);
            unitPrice = pmsProjectRoleVO.getUnitPrice();
        } else {
            ProRelatedPartiesVO proRelatedPartiesVO = this.proRelatedPartiesService.get(directorRelatedPartiesId);
            String proRole = proRelatedPartiesVO.getProRole();
            if (StringUtils.hasText((String)proRole)) {
                String[] split = proRole.split(",");
                proRole = split[0];
                PmsProjectRoleVO pmsProjectRoleVO = this.pmsProjectRoleService.queryByKey(Long.valueOf(proRole));
                unitPrice = pmsProjectRoleVO.getUnitPrice();
            }
        }
        if (null != unitPrice && null != predictWorkHours && null != workHours) {
            BigDecimal taskCost = TaskProCostUtil.calculateTaskCost(unitPrice, predictWorkHours, workHours);
            log.info("\u4efb\u52a1\u6210\u672c\u91d1\u989d\uff1a{}", (Object)taskCost);
            PmsWbsBudgetDetailsVO wbsBudgetDetailsVO = this.pmsWbsBudgetDetailsService.getByWbsId(wbsId, payload.getReasonId());
            if (null == wbsBudgetDetailsVO) {
                throw TwException.error("", "\u4efb\u52a1\u5173\u8054\u7684WBS\u4e0d\u5b58\u5728\u9884\u7b97\u4fe1\u606f");
            }
            BigDecimal allocatedResAmt = wbsBudgetDetailsVO.getAllocatedResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getAllocatedResAmt();
            log.info("\u4efb\u52a1\u5173\u8054\u7684WBS\u9884\u7b97\u91d1\u989d\uff1a{}", (Object)allocatedResAmt);
            BigDecimal occupiedResAmt = wbsBudgetDetailsVO.getOccupiedResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getOccupiedResAmt();
            log.info("\u4efb\u52a1\u5173\u8054\u7684WBS\u5df2\u5360\u7528\u91d1\u989d\uff1a{}", (Object)occupiedResAmt);
            BigDecimal settledResAmt = wbsBudgetDetailsVO.getSettledResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getSettledResAmt();
            log.info("\u4efb\u52a1\u5173\u8054\u7684WBS\u5df2\u7ed3\u8f6c\u91d1\u989d\uff1a{}", (Object)settledResAmt);
            BigDecimal remainResAmt = allocatedResAmt.subtract(occupiedResAmt).subtract(settledResAmt);
            log.info("\u4efb\u52a1\u5173\u8054\u7684WBS\u5269\u4f59\u91d1\u989d\uff1a{}", (Object)remainResAmt);
            if (taskCost.compareTo(remainResAmt) > 0) {
                Optional<PmsProjectWbsResourceVO> first;
                String managerUserName = "";
                List pmsProjectWbsResourceVOList = pmsProjectWbsVO.getPmsProjectWbsResourceVOList();
                if (!CollectionUtils.isEmpty((Collection)pmsProjectWbsResourceVOList) && (first = pmsProjectWbsResourceVOList.stream().filter(pmsProjectWbsResourceVO -> pmsProjectWbsResourceVO.getManagerUserFlag().equals(true)).findFirst()).isPresent()) {
                    String relatePartiesName;
                    PmsProjectWbsResourceVO pmsProjectWbsResourceVO2 = first.get();
                    managerUserName = relatePartiesName = pmsProjectWbsResourceVO2.getRelatePartiesName();
                }
                log.info("\u6d3b\u52a8\u8d1f\u8d23\u4eba\uff1a{}", (Object)managerUserName);
                throw TwException.error("", "\u4efb\u52a1\u6210\u672c\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u9884\u7b97\u91d1\u989d\uff0c\u8bf7\u5148\u8054\u7cfb\u6d3b\u52a8\u8d1f\u8d23\u4eba\uff1a" + managerUserName);
            }
        }
    }

    private void initData(TaskProPayload payload) {
        String taskNo = this.generateSeqNum("PMS_TASK_PRO", new String[0]);
        payload.setTaskNo(taskNo);
        Long taskCategoryId = payload.getTaskCategoryId();
        if (taskCategoryId != null) {
            TaskCategoryVO taskCategoryVO = this.taskCategoryService.queryByKey(taskCategoryId);
            if (taskCategoryVO != null) {
                payload.setTaskCategoryName(taskCategoryVO.getName());
            }
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(taskCategoryId);
            stateFlowQuery.setSize(1);
            OrderItem orderItem = OrderItem.desc((String)"sort");
            OrderItem orderItem2 = OrderItem.asc((String)"createTime");
            ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
            orderItemList.add(orderItem);
            orderItemList.add(orderItem2);
            stateFlowQuery.setOrders(orderItemList);
            PagingVO<StateFlowVO> page = this.stateFlowService.page(stateFlowQuery);
            if (page.getTotal() < 1L) {
                throw TwException.error("", "\u4efb\u52a1\u7c7b\u522b\u672a\u914d\u7f6e\u72b6\u6001\u6d41");
            }
            StateFlowVO stateFlowVO = (StateFlowVO)page.getRecords().get(0);
            Assert.notNull((Object)stateFlowVO, (String)"\u5173\u8054\u72b6\u6001\u6d41\u672a\u914d\u7f6e\u72b6\u6001");
            payload.setStateFlowId(stateFlowVO.getId());
            payload.setStateFlowName(stateFlowVO.getName());
            payload.setTaskStatus(TaskProStatusEnum.START.getCode());
        }
    }

    private void taskMemberDataProcess(StringBuilder fieldsUpdateLog, TaskProPayload payload, Long taskId) {
        List<Long> memberPartIdList;
        TaskMemberRefQuery memberRefQueryFollow = new TaskMemberRefQuery();
        memberRefQueryFollow.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        memberRefQueryFollow.setObjType(TaskMemberRefObjTypeEnum.FOLLOW.getCode());
        memberRefQueryFollow.setTaskId(taskId);
        List<TaskMemberRefVO> followOldList = this.taskMemberRefService.queryListDynamic(memberRefQueryFollow);
        List followIdList1 = followOldList.stream().map(item -> item.getObjId()).collect(Collectors.toList());
        Object followChange = "\u5173\u6ce8\u4eba";
        String followOldName = "";
        boolean followChangeFlag1 = false;
        if (CollectionUtils.isEmpty(followOldList)) {
            followChangeFlag1 = true;
        } else {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(followIdList1);
            List listSimple = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            followOldName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
        }
        TaskMemberRefQuery memberRefQuery = new TaskMemberRefQuery();
        memberRefQuery.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        memberRefQuery.setObjType(TaskMemberRefObjTypeEnum.PART.getCode());
        memberRefQuery.setTaskId(taskId);
        List<TaskMemberRefVO> partOldList = this.taskMemberRefService.queryListDynamic(memberRefQuery);
        List partIdList1 = partOldList.stream().map(item -> item.getObjId()).collect(Collectors.toList());
        Object partChange = "\u53c2\u4e0e\u4eba";
        String partOldName = "";
        boolean partChangeFlag1 = false;
        if (CollectionUtils.isEmpty(partOldList)) {
            partChangeFlag1 = true;
        } else {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(partIdList1);
            List listSimple = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            partOldName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
        }
        this.taskMemberRefService.deleteSoftByTaskId(taskId);
        List<Long> memberFollowIdList = payload.getMemberFollowIdList();
        if (null == memberFollowIdList) {
            memberFollowIdList = new ArrayList<Long>();
        }
        List<Long> finalMemberFollowIdList = memberFollowIdList;
        List diffFollow = followIdList1.stream().filter(item -> !finalMemberFollowIdList.contains(item)).collect(Collectors.toList());
        List diffFollow1 = finalMemberFollowIdList.stream().filter(item -> !followIdList1.contains(item)).collect(Collectors.toList());
        diffFollow.addAll(diffFollow1);
        boolean followChangeFlag2 = false;
        if (!CollectionUtils.isEmpty(memberFollowIdList)) {
            memberFollowIdList.forEach(id -> {
                TaskMemberRefPayload memberRefPayload = new TaskMemberRefPayload();
                memberRefPayload.setType(TaskMemberRefTypeEnum.RELATED.getCode());
                memberRefPayload.setObjType(TaskMemberRefObjTypeEnum.FOLLOW.getCode());
                memberRefPayload.setObjId((Long)id);
                memberRefPayload.setTaskId(taskId);
                this.taskMemberRefService.insert(memberRefPayload);
            });
        } else {
            followChangeFlag2 = true;
        }
        if (!CollectionUtils.isEmpty(diffFollow)) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(finalMemberFollowIdList);
            List listSimple = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            String changeFollowName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
            followChange = followChangeFlag1 ? (String)followChange + " \u7531 \u7a7a \u4fee\u6539\u4e3a " + changeFollowName : (followChangeFlag2 ? (String)followChange + " \u7531 " + followOldName + " \u4fee\u6539\u4e3a \u7a7a" : (String)followChange + " \u7531 " + followOldName + " \u4fee\u6539\u4e3a " + changeFollowName);
            fieldsUpdateLog.append((String)followChange + "\n");
        }
        if (null == (memberPartIdList = payload.getMemberPartIdList())) {
            memberPartIdList = new ArrayList<Long>();
        }
        List<Long> finalMemberPartIdList = memberPartIdList;
        List diffPart = partIdList1.stream().filter(item -> !finalMemberPartIdList.contains(item)).collect(Collectors.toList());
        List diffPart1 = memberPartIdList.stream().filter(item -> !partIdList1.contains(item)).collect(Collectors.toList());
        diffPart.addAll(diffPart1);
        boolean partChangeFlag2 = false;
        if (!CollectionUtils.isEmpty(memberPartIdList)) {
            memberPartIdList.forEach(id -> {
                TaskMemberRefPayload memberRefPayload = new TaskMemberRefPayload();
                memberRefPayload.setType(TaskMemberRefTypeEnum.RELATED.getCode());
                memberRefPayload.setObjType(TaskMemberRefObjTypeEnum.PART.getCode());
                memberRefPayload.setObjId((Long)id);
                memberRefPayload.setTaskId(taskId);
                this.taskMemberRefService.insert(memberRefPayload);
            });
        } else {
            partChangeFlag2 = true;
        }
        if (!CollectionUtils.isEmpty(diffPart)) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(finalMemberPartIdList);
            List listSimple = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            String changeName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
            partChange = partChangeFlag1 ? (String)partChange + " \u7531 \u7a7a \u4fee\u6539\u4e3a " + changeName : (partChangeFlag2 ? (String)partChange + " \u7531 " + changeName + " \u4fee\u6539\u4e3a \u7a7a" : (String)partChange + " \u7531 " + partOldName + " \u4fee\u6539\u4e3a " + changeName);
            fieldsUpdateLog.append((String)partChange + "\n");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskProVO update(TaskProPayload payload) {
        Long stateFlowId;
        TaskProDO entity = this.taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        Long wbsId = entity.getWbsId();
        if (wbsId != null) {
            PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsService.queryByKey(wbsId);
            String wbsStatus = pmsProjectWbsVO.getWbsStatus();
            if (StringUtils.hasText((String)wbsStatus) && wbsStatus.equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
                throw TwException.error("", "\u8be5\u4efb\u52a1\u5f52\u5c5e\u7684\u6d3b\u52a8\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c");
            }
            Long directorRelatedPartiesId = payload.getDirectorRelatedPartiesId();
            if (null == directorRelatedPartiesId) {
                directorRelatedPartiesId = entity.getDirectorRelatedPartiesId();
            }
            if (null == payload.getReasonId()) {
                payload.setReasonId(entity.getReasonId());
            }
            this.checkWbsBudget(payload, directorRelatedPartiesId, wbsId, pmsProjectWbsVO);
        }
        if (entity.getDirectorRelatedPartiesId() != null) {
            ProRelatedPartiesVO simple = this.proRelatedPartiesService.getSimple(entity.getDirectorRelatedPartiesId());
            entity.setDirectorRelatedPartiesName(simple.getName());
        }
        if (null != (stateFlowId = payload.getStateFlowId())) {
            StateFlowVO stateFlowVO = this.stateFlowService.get(stateFlowId);
            Assert.notNull((Object)stateFlowVO, (String)"\u72b6\u6001\u4e0d\u5b58\u5728");
            String stateFlowVOName = stateFlowVO.getName();
            payload.setStateFlowName(stateFlowVOName);
        }
        TaskProDO entityLog = new TaskProDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        TaskProDO entityDo = TaskProConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (entityDo.getActualWorkHoursChangeLog() != null) {
            entityDo.setActualWorkHoursChangeLog((int)entityDo.getActualWorkHoursChangeLog());
        }
        if (entityDo.getPredictWorkHoursChangeLog() != null) {
            entityDo.setPredictWorkHoursChangeLog((int)entityDo.getPredictWorkHoursChangeLog());
        }
        if (entityDo.getDirectorRelatedPartiesId() != null) {
            ProRelatedPartiesVO simple = this.proRelatedPartiesService.getSimple(payload.getDirectorRelatedPartiesId());
            entityDo.setDirectorRelatedPartiesName(simple.getName());
        }
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        TaskProDO save = (TaskProDO)this.taskProRepo.save(entity);
        Long taskId = save.getId();
        this.taskMemberDataProcess(fieldsUpdateLog, payload, taskId);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), fieldsUpdateLog.toString());
        }
        if (save.getWbsId() != null) {
            TaskProEventFactory.SERVICE_MAP.forEach((taskProEventEnum, taskProEventService) -> taskProEventService.taskCreateOk(save));
        }
        return TaskProConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TaskProPayload payload) {
        TaskProDO entity = this.taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        long result = this.taskProDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.taskProDAO.deleteSoft(keys);
        }
    }

    @Override
    public long top(TaskProPayload payload) {
        if (payload.getTopFlag() != null) {
            TaskProDO entity = this.taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
            String logMsg = "";
            if (payload.getTopFlag().booleanValue()) {
                entity.setTopModifyTime(LocalDateTime.now());
                logMsg = "\u7f6e\u9876";
            } else {
                entity.setTopModifyTime(null);
                logMsg = "\u53d6\u6d88\u7f6e\u9876";
            }
            entity.setTopFlag(payload.getTopFlag());
            entity.setTopModifyTime(LocalDateTime.now());
            this.taskProRepo.save(entity);
            this.logService.saveNewLog(entity.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), logMsg);
        }
        return 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updatePartiesId(List<TaskProQuery> taskProQueryList) {
        taskProQueryList.forEach(x -> {
            TaskProPayload taskProPayload = new TaskProPayload();
            taskProPayload.setId(x.getId());
            taskProPayload.setDirectorRelatedPartiesId(x.getDirectorRelatedPartiesId());
            this.taskProDAO.updateByKeyDynamic(taskProPayload);
        });
        return null;
    }

    @Override
    public TaskProVO createSub(TaskProPayload payload) {
        Long parentId = payload.getParentId();
        Assert.notNull((Object)parentId, (String)"\u7236\u4efb\u52a1id[parentId]\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)payload.getTaskName(), (String)"\u4efb\u52a1\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        TaskProVO taskProParentVO = this.queryByKey(parentId);
        TaskProPayload subTaskPayload = new TaskProPayload();
        subTaskPayload.setParentId(parentId);
        subTaskPayload.setTaskName(payload.getTaskName());
        subTaskPayload.setPriority(TaskProPriorityEnum.LOW.getCode());
        subTaskPayload.setTaskCategoryId(taskProParentVO.getTaskCategoryId());
        subTaskPayload.setDirectorRelatedPartiesId(taskProParentVO.getDirectorRelatedPartiesId());
        subTaskPayload.setPlanStartDate(taskProParentVO.getPlanStartDate());
        subTaskPayload.setPlanEndDate(taskProParentVO.getPlanEndDate());
        subTaskPayload.setReasonId(taskProParentVO.getReasonId());
        subTaskPayload.setReasonType(taskProParentVO.getReasonType());
        subTaskPayload.setShowScope(taskProParentVO.getShowScope());
        subTaskPayload.setWbsId(taskProParentVO.getWbsId());
        subTaskPayload.setWbsName(taskProParentVO.getWbsName());
        subTaskPayload.setPredictWorkHours(taskProParentVO.getPredictWorkHours());
        return this.insert(subTaskPayload);
    }

    @Override
    public List<TaskProBoardViewGroupInfoVO> boardViewGroup(TaskProQuery query) {
        ArrayList<TaskProBoardViewGroupInfoVO> list = new ArrayList<TaskProBoardViewGroupInfoVO>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        long myDirectorCount = 0L;
        long myPartCount = 0L;
        long myFollowCount = 0L;
        long myAllCount = 0L;
        long myCreateCount = 0L;
        Long reasonId = query.getReasonId();
        String reasonType = query.getReasonType();
        Long taskCategoryId = query.getTaskCategoryId();
        if (!ObjectUtils.isEmpty((Object)reasonType) && reasonType.equals(TaskReasonTypeEnum.PROJ_CONTRACT.getCode()) && reasonId != null) {
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                TaskProQuery taskProDirectorQuery = new TaskProQuery();
                BeanUtils.copyProperties((Object)query, (Object)taskProDirectorQuery);
                taskProDirectorQuery.setDirectorRelatedPartiesId(relatedPartiesVOId);
                myDirectorCount = this.taskProDAO.count(taskProDirectorQuery);
                myPartCount = this.taskProDAO.countLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
                myFollowCount = this.taskProDAO.countLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
                TaskProQuery taskProQuery = new TaskProQuery();
                BeanUtils.copyProperties((Object)query, (Object)taskProQuery);
                taskProQuery.setCreateRelatedPartiesId(relatedPartiesVOId);
                myCreateCount = this.taskProDAO.count(taskProQuery);
            }
            TaskProQuery taskAllProQuery = new TaskProQuery();
            BeanUtils.copyProperties((Object)query, (Object)taskAllProQuery);
            taskAllProQuery.setSearchType(TaskProGroupEnum.ALL_ALL.getCode());
            List<ProRelatedPartiesVO> listAllSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listAllSimple.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
            taskAllProQuery.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(relatedIdList)) {
                relatedIdList.add(9999L);
                taskAllProQuery.setRelatedIdList(relatedIdList);
            }
            taskAllProQuery.setReasonId(reasonId);
            taskAllProQuery.setTaskCategoryId(taskCategoryId);
            myAllCount = this.taskProDAO.count(taskAllProQuery);
        } else {
            TaskProQuery taskProQuery = new TaskProQuery();
            BeanUtils.copyProperties((Object)query, (Object)taskProQuery);
            taskProQuery.setCreateUserId(loginUserId);
            myCreateCount = this.taskProDAO.count(taskProQuery);
        }
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.ALL_ALL.getType(), TaskProGroupEnum.ALL_ALL.getCode(), TaskProGroupEnum.ALL_ALL.getDesc(), myAllCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_CREATE.getType(), TaskProGroupEnum.MY_CREATE.getCode(), TaskProGroupEnum.MY_CREATE.getDesc(), myCreateCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_DIRECTOR.getType(), TaskProGroupEnum.MY_DIRECTOR.getCode(), TaskProGroupEnum.MY_DIRECTOR.getDesc(), myDirectorCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_PART.getType(), TaskProGroupEnum.MY_PART.getCode(), TaskProGroupEnum.MY_PART.getDesc(), myPartCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_FOLLOW.getType(), TaskProGroupEnum.MY_FOLLOW.getCode(), TaskProGroupEnum.MY_FOLLOW.getDesc(), myFollowCount));
        return list;
    }

    @Override
    public List<TaskProBoardVO> boardView(TaskProQuery query) {
        ArrayList<TaskProBoardVO> resultList = new ArrayList<TaskProBoardVO>();
        Long taskCategoryId = query.getTaskCategoryId();
        if (null != taskCategoryId) {
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(taskCategoryId);
            OrderItem orderItem = OrderItem.desc((String)"sort");
            OrderItem orderItem2 = OrderItem.asc((String)"createTime");
            ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
            orderItemList.add(orderItem);
            orderItemList.add(orderItem2);
            stateFlowQuery.setOrders(orderItemList);
            List<StateFlowVO> stateFlowVOList = this.stateFlowService.getList(stateFlowQuery);
            String searchType = query.getSearchType();
            if (ObjectUtils.isEmpty((Object)searchType)) {
                searchType = TaskProGroupEnum.ALL_ALL.getCode();
            }
            String finalSearchType = searchType;
            stateFlowVOList.forEach(stateFlowVO -> {
                TaskProBoardVO taskProBoardVO = new TaskProBoardVO();
                taskProBoardVO.setName(stateFlowVO.getName());
                taskProBoardVO.setState(stateFlowVO.getState());
                taskProBoardVO.setStateFlowId(stateFlowVO.getId());
                taskProBoardVO.setBackgroundColor(stateFlowVO.getBackgroundColor());
                taskProBoardVO.setFontColor(stateFlowVO.getFontColor());
                query.setStateFlowId(stateFlowVO.getId());
                ArrayList<OrderItem> taskOrderItemList = new ArrayList<OrderItem>();
                taskOrderItemList.add(OrderItem.desc((String)"topFlag"));
                taskOrderItemList.add(OrderItem.desc((String)"topModifyTime"));
                taskOrderItemList.add(OrderItem.desc((String)"sort"));
                taskOrderItemList.add(OrderItem.desc((String)"createTime"));
                query.setOrders(taskOrderItemList);
                List<TaskProVO> taskProVOS = this.getTaskProVOS(query, finalSearchType);
                resultList.add(taskProBoardVO);
            });
        }
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean unbindRef(Long subTaskId, Long parentTaskId) {
        long count = this.taskProDAO.unbindRef(subTaskId, parentTaskId);
        return count > 0L;
    }

    @Override
    public List<TaskProVO> queryListDynamicForExcelExport(TaskProQuery query) {
        String finalSearchType = query.getSearchType();
        if (ObjectUtils.isEmpty((Object)finalSearchType)) {
            finalSearchType = TaskProGroupEnum.ALL_ALL.getCode();
        }
        List<TaskProVO> taskProVOS = this.getTaskProVOS(query, finalSearchType);
        return taskProVOS;
    }

    @Override
    @Transactional
    public Boolean updateBatch(List<TaskProPayload> payloadList) {
        for (TaskProPayload taskProPayload : payloadList) {
            this.updateByKeyDynamic(taskProPayload);
        }
        return true;
    }

    @Override
    public BigDecimal summaryWbs(Long wbsId, String type) {
        BigDecimal resSum = BigDecimal.ZERO;
        if ("ACT".equals(type)) {
            TaskProQuery taskProQuery = new TaskProQuery();
            taskProQuery.setWbsId(wbsId);
            List<TaskProVO> taskProVOS = this.queryListDynamic(taskProQuery);
            BigDecimal sumTaskHours = taskProVOS.stream().filter(x -> null != x.getPredictWorkHours()).map(x -> x.getPredictWorkHours()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(sumTaskHours) == 0) {
                return BigDecimal.ZERO;
            }
            for (TaskProVO taskProVO : taskProVOS) {
                if (null == taskProVO.getPredictWorkHours()) continue;
                StateFlowVO stateFlowVO = this.stateFlowService.get(taskProVO.getStateFlowId());
                BigDecimal bigDecimal = taskProVO.getPredictWorkHours().divide(sumTaskHours, 2, 4);
                BigDecimal multiply = stateFlowVO.getProgressPercentage().multiply(bigDecimal);
                resSum = resSum.add(multiply);
            }
        }
        return resSum;
    }

    @Override
    public List<TaskProVO> queryListByTaskIdsAndHaveWbsId(List<Long> taskIds) {
        return this.taskProDAO.queryListByTaskIdsAndHaveWbsId(taskIds);
    }

    private List<TaskProVO> getTaskProVOS(TaskProQuery query, String finalSearchType) {
        List<Object> taskProVOS = new ArrayList();
        Long reasonId = query.getReasonId();
        if (finalSearchType.equals(TaskProGroupEnum.ALL_ALL.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listSimple.stream().map(BaseViewModel::getId).collect(Collectors.toSet());
            query.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(query.getRelatedIdList())) {
                relatedIdList.add(9999L);
                query.setRelatedIdList(relatedIdList);
            }
            taskProVOS = this.queryListDynamic(query);
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_CREATE.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (null != reasonId) {
                List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
                if (!CollectionUtils.isEmpty(listSimple)) {
                    ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                    Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                    query.setCreateRelatedPartiesId(relatedPartiesVOId);
                    taskProVOS = this.queryListDynamic(query);
                }
            } else {
                query.setCreateUserId(loginUserId);
                taskProVOS = this.queryListDynamic(query);
            }
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_DIRECTOR.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                query.setDirectorRelatedPartiesId(relatedPartiesVOId);
                taskProVOS = this.queryListDynamic(query);
            }
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_FOLLOW.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                taskProVOS = this.taskProDAO.queryListDynamicLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
            }
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_PART.getCode())) {
            Assert.notNull((Object)reasonId, (String)"\u8bf7\u9009\u62e9\u9879\u76ee\uff0c\u53c2\u6570\u7f3a\u5931");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = this.getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();
                taskProVOS = this.taskProDAO.queryListDynamicLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
            }
        } else {
            taskProVOS = this.queryListDynamic(query);
        }
        return taskProVOS;
    }

    public TaskProServiceImpl(TaskProRepo taskProRepo, TaskProDAO taskProDAO, TaskMemberRefService taskMemberRefService, TaskCategoryService taskCategoryService, StateFlowService stateFlowService, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, PmsProjectWbsService pmsProjectWbsService, ProVacationSettingService proVacationSettingService, PmsProjectRoleService pmsProjectRoleService) {
        this.taskProRepo = taskProRepo;
        this.taskProDAO = taskProDAO;
        this.taskMemberRefService = taskMemberRefService;
        this.taskCategoryService = taskCategoryService;
        this.stateFlowService = stateFlowService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.pmsProjectWbsService = pmsProjectWbsService;
        this.proVacationSettingService = proVacationSettingService;
        this.pmsProjectRoleService = pmsProjectRoleService;
    }
}

