package com.elitesland.tw.tw5.base.common;


import com.elitesland.tw.tw5.base.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.base.common.annotation.FieldUpdateLog;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 通用payload
 *
 * @author zhangyongqiang
 */
@Data
public class TwCommonPayload {
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("备注")
    @FieldCreateLog(fieldName = "备注")
    @FieldUpdateLog(fieldName = "备注")
    private String remark;

    @ApiModelProperty("创建者用户ID")
    private Long createUserId;
    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;


    @ApiModelProperty("修改者用户ID")
    private Long modifyUserId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间起")
    private LocalDateTime modifyTime;

    @ApiModelProperty("删除标识（0：未删除，1：已删除）")
    private Integer deleteFlag;

    @ApiModelProperty("忽视警告")
    protected boolean ignoreWarning;

    @ApiModelProperty("需要设置成null值的属性")
    protected List<String> nullFields;

    @ApiModelProperty("变更日志的id")
    protected Long changeLogId;


}
