package com.elitesland.tw.tw5.base.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.base.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

/**
 * tw查询参数
 *
 * @author duwh
 * @date 2023/06/15
 */
@Data
public class TwQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("主键")
    private List<Long> ids;

    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("备注模糊搜索")
    private String remarkLike;

    @ApiModelProperty("登录用户id 用于数据权限")
    private Long loginUserId;

    @Query
    @ApiModelProperty("创建者用户ID")
    private Long createUserId;

    @ApiModelProperty("创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    @ApiModelProperty("创建时间起")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeStart;
    @ApiModelProperty("创建时间止")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("修改者用户ID")
    private Long modifyUserId;

    @ApiModelProperty("修改时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifyTime;
    @ApiModelProperty("修改时间起")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifyTimeStart;
    @ApiModelProperty("修改时间止")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifyTimeEnd;


    @ApiModelProperty("数据权限标记 默认true")
    private Boolean dataPermissionFlag = true;

    public TwQueryParam() {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        defaultOrder(orderItem);
    }
}
