package com.elitesland.tw.tw5.base.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface DuplicateSubmissionPrevention {

    // 是否开启防重复提交，默认开启
    boolean enabled() default true;

    // 防重复时间间隔，默认 1000 毫秒
    long timeIntervalMillis() default 1000;

    // 防重复的提示语，默认空
    String message() default "";

    // 防重复唯一标志生成的参数依据，字符串类型数组
    String[] parametersForUniqueFlagGeneration() default {};

}
