package com.elitesland.tw.tw5.base.config;

import com.elitesland.tw.tw5.base.common.TwException;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 统一异常处理
 *
 * @author duwh
 * @date 2023/03/29
 */
@ControllerAdvice
@Slf4j
public class TwExceptionHandler {

    /**
     * 全局异常处理
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(Exception.class)
    public ResponseEntity<TwOutputUtil<Object>> exceptionHandler(Exception exception) {
        exception.printStackTrace();

        return new ResponseEntity<>(TwOutputUtil.error("",exception.getMessage()),HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 业务异常处理
     *
     * @param exception 异常
     * @return {@link TwOutputUtil}
     */
    @ExceptionHandler(TwException.class)
    @ResponseBody
    public TwOutputUtil<Object> exceptionHandler(TwException exception) {
        return TwOutputUtil.output(false,exception.getData(),null, exception.getErrors(),exception.getWarns());
    }
//
//    /**
//     * 不在线异常处理程序
//     *
//     * @param exception 异常
//     * @return {@link TwOutputUtil}
//     */
//    @ExceptionHandler(NotOnlineException.class)
//    @ResponseBody
//    public TwOutputUtil notOnlineExceptionHandler(NotOnlineException exception) {
//        return TwOutputUtil.addNotOnlineException(exception);
//    }
//
//    /**
//     * 工作流异常处理程序
//     *
//     * @param exception 异常
//     * @return {@link TwOutputUtil}
//     */
//    @ExceptionHandler(WorkflowException.class)
//    @ResponseBody
//    public TwOutputUtil workflowExceptionHandler(WorkflowException exception) {
//        return TwOutputUtil.addWorkflowException(exception);
//    }

}
