package com.elitesland.tw.tw5.base.util;

import com.elitescloud.boot.redis.util.RedisUtils;
//import com.elitesland.tw.tw5.api.common.TwOutputUtil;
//import com.elitesland.tw.tw5.api.prd.org.dto.PrdOrgEmployeeDTO;
//import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.pms.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.pms.PrdOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
//import com.elitesland.tw.tw5.api.prd.org.dto.PrdOrgEmployeeDTO;
//import com.elitesland.tw.tw5.api.prd.org.service.ComOrgEmployeeRpcService;
//import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeRpcService;
import com.elitesland.tw.tw5.base.ancillary.api.ComSelectionRpcService;
import com.elitesland.tw.tw5.base.ancillary.model.query.ComSelectionQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.ComSelectionVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.*;

@Slf4j
@Component
@RequiredArgsConstructor
public class TwCacheUtil {

    private final RedisUtils redisUtils;

//    private final ComOrgEmployeeRpcService comOrgEmployeeRpcService;
    private final ComSelectionRpcService comSelectionRpcService;


    /**
     * 选择项缓存
     */
    private final Map<String, ComSelectionVO> selectionCacheMap = new HashMap<>();
    private static long lastLoadTimeSelection = 0L;

    /**
     * 加载系统选择项缓存
     */
    public void loadSelectionCache() {
        selectionCacheMap.clear();
        ComSelectionQuery query = new ComSelectionQuery();

        List<ComSelectionVO> selectionViews = comSelectionRpcService.queryList(query);
        selectionViews.forEach(selectionView -> {
            selectionCacheMap.put(selectionView.getSelectionKey(), selectionView);
        });
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSelection = new Date().getTime();
    }

    /**
     * 获取系统选择项
     *
     * @param selectionKey 选择项key
     * @return 消息提醒
     */
    public ComSelectionVO getSelection(String selectionKey) {
        ComSelectionVO prdSystemSelectionVO = this.selectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && shouldLoadCache(lastLoadTimeSelection)) {
            loadSelectionCache();
            return this.selectionCacheMap.get(selectionKey);
        } else {
            return prdSystemSelectionVO;
        }
    }

    /**
     * 翻译系统选择项
     *
     * @param selectionKey 选择项key
     * @param value        选择项值
     * @return 选择项描述
     */
    public String transferSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        ComSelectionVO selection = getSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<ComSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (ComSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView.getSelectionName();
                    break;
                }
            }
        }
        return result;
    }

    /**
     * 翻译级联系统选择项
     *
     * @param selectionKey   选择项key
     * @param cascaderValues 级联值
     * @return 消息提醒
     */
    public String transferSelectionCascader(String selectionKey, String[] cascaderValues) {
        if (cascaderValues == null || cascaderValues.length == 0) {
            return null;
        }
        String result = cascaderValues[cascaderValues.length - 1];
        ComSelectionVO view = getSelection(selectionKey);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return result;
        }
        List<ComSelectionVO> children = view.getChildren();
        ComSelectionVO resultView = null;
        for (int i = 0; i < cascaderValues.length; i++) {
            int valueIndex = i;
            Optional<ComSelectionVO> view1 = children.stream()
                    .filter(selectionView -> selectionView.getSelectionValue().equals(cascaderValues[valueIndex]))
                    .findFirst();
            if (view1.isPresent()) {
                resultView = view1.get();
                children = resultView.getChildren();
            } else {
                return result;
            }

        }
        return resultView.getSelectionName();

    }

    // ===========用户翻译================
    private final Map<String, String> userCacheMap = new HashMap<>();

    private static long lastLoadTimeUser = 0L;

    public void loadUserCache() {
        userCacheMap.clear();
    }

    /**
     * 获取员工
     *
     * @param id 选择项key
     * @return 消息提醒
     */
    public ComSelectionVO getEmployee(Long id) {
        // todo
//        ComSelectionVO prdSystemSelectionVO = this.selectionCacheMap.get(selectionKey);
//        if (prdSystemSelectionVO == null && shouldLoadCache(lastLoadTimeSelection)) {
//            loadSelectionCache();
//            return this.selectionCacheMap.get(selectionKey);
//        } else {
//            return prdSystemSelectionVO;
//        }
        return null;
    }

    /**
     * 获取不到缓存时是否应该重新
     *
     * @param lastLoadTime 上次加载缓存时间
     * @return 是否
     */
    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 1000L * 60;
        return new Date().getTime() - lastLoadTime > interval;

    }



    // 帮我写一个新的类，用来做微服务接口调用的
    // 1. 用来调用 comOrgEmployeeRpcService.getEmployeeList()，并返回结果


}
