/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.common;

import com.elitesland.tw.tw5.base.common.TwMessage;
import java.util.ArrayList;
import java.util.List;

public class TwOutputUtil<T> {
    private boolean ok;
    private T data;
    private List<TwMessage> infos = new ArrayList<TwMessage>();
    private List<TwMessage> errors = new ArrayList<TwMessage>();
    private List<TwMessage> warns = new ArrayList<TwMessage>();

    private TwOutputUtil(boolean ok) {
        this.ok = ok;
    }

    public static <T> TwOutputUtil<T> output(boolean ok) {
        return new TwOutputUtil<T>(ok);
    }

    public static <T> TwOutputUtil<T> output(boolean ok, T data, List<TwMessage> infos, List<TwMessage> errors, List<TwMessage> warns) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(ok);
        outputUtil.data = data;
        outputUtil.infos = infos;
        outputUtil.errors = errors;
        outputUtil.warns = warns;
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> ok() {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(true);
        outputUtil.infos.add(TwMessage.of("COM-SUCCESS", "\u64cd\u4f5c\u6210\u529f", null));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> ok(T data) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(true);
        outputUtil.setData(data);
        outputUtil.infos.add(TwMessage.of("COM-SUCCESS", "\u64cd\u4f5c\u6210\u529f", null));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> ok(String localeCode, String defaultMsg, T data) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(true);
        outputUtil.data = data;
        outputUtil.infos.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> error() {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(false);
        outputUtil.errors.add(TwMessage.of("COM-ERROR", "\u64cd\u4f5c\u5931\u8d25", null));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> error(String localeCode, String defaultMsg) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(false);
        outputUtil.data = null;
        outputUtil.errors.add(TwMessage.of(localeCode, defaultMsg, null));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> error(String localeCode, String defaultMsg, T data) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(false);
        outputUtil.data = data;
        outputUtil.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public TwOutputUtil<T> addError(String localeCode, String defaultMsg, Object data) {
        this.errors.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public static <T> TwOutputUtil<T> warn() {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(false);
        outputUtil.warns.add(TwMessage.of("COM-WARN", "\u662f\u5426\u786e\u8ba4\uff1f", null));
        return outputUtil;
    }

    public static <T> TwOutputUtil<T> warn(String localeCode, String defaultMsg, T data) {
        TwOutputUtil<T> outputUtil = new TwOutputUtil<T>(false);
        outputUtil.data = data;
        outputUtil.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return outputUtil;
    }

    public TwOutputUtil<T> addWarn(String localeCode, String defaultMsg, T data) {
        this.warns.add(TwMessage.of(localeCode, defaultMsg, data));
        return this;
    }

    public boolean isOk() {
        return this.ok;
    }

    public T getData() {
        return this.data;
    }

    public List<TwMessage> getInfos() {
        return this.infos;
    }

    public List<TwMessage> getErrors() {
        return this.errors;
    }

    public List<TwMessage> getWarns() {
        return this.warns;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setInfos(List<TwMessage> infos) {
        this.infos = infos;
    }

    public void setErrors(List<TwMessage> errors) {
        this.errors = errors;
    }

    public void setWarns(List<TwMessage> warns) {
        this.warns = warns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwOutputUtil)) {
            return false;
        }
        TwOutputUtil other = (TwOutputUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOk() != other.isOk()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        List<TwMessage> this$infos = this.getInfos();
        List<TwMessage> other$infos = other.getInfos();
        if (this$infos == null ? other$infos != null : !((Object)this$infos).equals(other$infos)) {
            return false;
        }
        List<TwMessage> this$errors = this.getErrors();
        List<TwMessage> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<TwMessage> this$warns = this.getWarns();
        List<TwMessage> other$warns = other.getWarns();
        return !(this$warns == null ? other$warns != null : !((Object)this$warns).equals(other$warns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TwOutputUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOk() ? 79 : 97);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        List<TwMessage> $infos = this.getInfos();
        result = result * 59 + ($infos == null ? 43 : ((Object)$infos).hashCode());
        List<TwMessage> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<TwMessage> $warns = this.getWarns();
        result = result * 59 + ($warns == null ? 43 : ((Object)$warns).hashCode());
        return result;
    }

    public String toString() {
        return "TwOutputUtil(ok=" + this.isOk() + ", data=" + this.getData() + ", infos=" + this.getInfos() + ", errors=" + this.getErrors() + ", warns=" + this.getWarns() + ")";
    }
}

