/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.config;

import com.elitesland.tw.tw5.base.common.TwException;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class TwExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(TwExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<TwOutputUtil<Object>> exceptionHandler(Exception exception) {
        exception.printStackTrace();
        return new ResponseEntity(TwOutputUtil.error("", exception.getMessage()), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={TwException.class})
    @ResponseBody
    public TwOutputUtil<Object> exceptionHandler(TwException exception) {
        return TwOutputUtil.output(false, exception.getData(), null, exception.getErrors(), exception.getWarns());
    }
}

