/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.base.util;

import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitesland.tw.tw5.base.ancillary.api.ComSelectionRpcService;
import com.elitesland.tw.tw5.base.ancillary.model.query.ComSelectionQuery;
import com.elitesland.tw.tw5.base.ancillary.model.vo.ComSelectionVO;
import com.elitesland.tw.tw5.base.util.TreeListUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TwCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(TwCacheUtil.class);
    private final RedisUtils redisUtils;
    private final ComSelectionRpcService comSelectionRpcService;
    private final Map<String, ComSelectionVO> selectionCacheMap = new HashMap<String, ComSelectionVO>();
    private static long lastLoadTimeSelection = 0L;
    private final Map<String, String> userCacheMap = new HashMap<String, String>();
    private static long lastLoadTimeUser = 0L;

    public void loadSelectionCache() {
        this.selectionCacheMap.clear();
        ComSelectionQuery query = new ComSelectionQuery();
        List<ComSelectionVO> selectionViews = this.comSelectionRpcService.queryList(query);
        selectionViews.forEach(selectionView -> this.selectionCacheMap.put(selectionView.getSelectionKey(), (ComSelectionVO)selectionView));
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSelection = new Date().getTime();
    }

    public ComSelectionVO getSelection(String selectionKey) {
        ComSelectionVO prdSystemSelectionVO = this.selectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && this.shouldLoadCache(lastLoadTimeSelection)) {
            this.loadSelectionCache();
            return this.selectionCacheMap.get(selectionKey);
        }
        return prdSystemSelectionVO;
    }

    public String transferSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        ComSelectionVO selection = this.getSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<ComSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (ComSelectionVO selectionView : children) {
                if (!value.equals(selectionView.getSelectionValue())) continue;
                result = selectionView.getSelectionName();
                break;
            }
        }
        return result;
    }

    public String transferSelectionCascader(String selectionKey, String[] cascaderValues) {
        if (cascaderValues == null || cascaderValues.length == 0) {
            return null;
        }
        String result = cascaderValues[cascaderValues.length - 1];
        ComSelectionVO view = this.getSelection(selectionKey);
        if (view == null || view.getChildren() == null || view.getChildren().isEmpty()) {
            return result;
        }
        List<ComSelectionVO> children = view.getChildren();
        ComSelectionVO resultView = null;
        int i = 0;
        while (i < cascaderValues.length) {
            int valueIndex = i++;
            Optional<ComSelectionVO> view1 = children.stream().filter(selectionView -> selectionView.getSelectionValue().equals(cascaderValues[valueIndex])).findFirst();
            if (!view1.isPresent()) {
                return result;
            }
            resultView = view1.get();
            children = resultView.getChildren();
        }
        return resultView.getSelectionName();
    }

    public void loadUserCache() {
        this.userCacheMap.clear();
    }

    public ComSelectionVO getEmployee(Long id) {
        return null;
    }

    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 60000L;
        return new Date().getTime() - lastLoadTime > interval;
    }

    public TwCacheUtil(RedisUtils redisUtils, ComSelectionRpcService comSelectionRpcService) {
        this.redisUtils = redisUtils;
        this.comSelectionRpcService = comSelectionRpcService;
    }
}

