package com.elitesland.tw.tw5.base.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.base.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * tw查询参数
 *
 * @author duwh
 * @date 2023/06/15
 */
@Data
public class TwQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("备注")
    private String remark;

    @Query
    @ApiModelProperty("创建者用户ID")
    private Long createUserId;
    /**
     * 登录用户id 用于数据权限
     */
    @ApiModelProperty("登录用户id")
    private Long loginUserId;
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间起")
    private LocalDateTime createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间止")
    private LocalDateTime createTimeEnd;

    @ApiModelProperty("修改者用户ID")
    private Long modifyUserId;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间起")
    private LocalDateTime modifyTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("修改时间止")
    private LocalDateTime modifyTimeEnd;


    @ApiModelProperty("数据权限标记 默认true")
    private Boolean dataPermissionFlag = true;

    public TwQueryParam() {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("createTime");
        defaultOrder(orderItem);
    }
}
