package com.elitesland.tw.tw5.base.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 字段变更记录日志
 *
 * @author duwh
 * @date 2022/11/16
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FieldUpdateLog {

    /**
     * 对象名对应的字段
     *
     * @return {@link String}
     */
    String objectNameField() default "";

    /**
     * 字段对应对象
     *
     * @return {@link String}
     */
    String fieldObject() default "";

    /**
     * 字段对应中文名
     *
     * @return {@link String}
     */
    String fieldName() default "";

    /**
     * 系统选择项key
     *
     * @return {@link String}
     */
    String selectionKey() default "";

    /**
     * 变更动作
     */
    String changeAction() default "修改为";
}
