package com.elitesland.tw.tw5.base.demo.vacation.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.ComOrgEmployeeRpcService;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.base.demo.vacation.service.UserVacationApplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户假期申请
 */
@RestController
@RequestMapping("/api/userVacationApply")
@RequiredArgsConstructor
@Api(value = "用户假期申请", tags = {"用户假期申请"})
public class UserVacationApplyController {

    private final UserVacationApplyService userVacationApplyService;

    private final ComOrgEmployeeRpcService comOrgEmployeeRpcService;

    @GetMapping("test1")
    @ApiOperation("详情-用户假期申请")
    public void test1() {

        System.out.println(comOrgEmployeeRpcService.getEmployeeList());

    }

    @GetMapping("get")
    @ApiOperation("详情-用户假期申请")
    public TwOutputUtil<UserVacationApplyVO> get(Long id) {

        UserVacationApplyVO res = userVacationApplyService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-用户假期申请")
    public TwOutputUtil<Long> save(@RequestBody UserVacationApplyPayload userVacationApplyPayload) {

        UserVacationApplyVO res = userVacationApplyService.save(userVacationApplyPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-用户假期申请")
    public TwOutputUtil<Long> update(@RequestBody UserVacationApplyPayload userVacationApplyPayload) {

        Long res = userVacationApplyService.update(userVacationApplyPayload);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("del")
    @ApiOperation("删除-用户假期申请")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

        Long res = userVacationApplyService.del(ids);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("/page")
//    @UdcNameClass
    @ApiOperation("分页查询-用户假期申请")
    public TwOutputUtil<PagingVO<UserVacationApplyVO>> page(@RequestBody UserVacationApplyQuery userVacationApplyQuery) {

        PagingVO<UserVacationApplyVO> res = userVacationApplyService.page(userVacationApplyQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("getList")
    @ApiOperation("获取列表-用户假期申请")
    public TwOutputUtil<List<UserVacationApplyVO>> getList(UserVacationApplyQuery userVacationApplyQuery) {

        List<UserVacationApplyVO> res = userVacationApplyService.getList(userVacationApplyQuery);
        return TwOutputUtil.ok(res);

    }

}

