package com.elitesland.tw.tw5.base.demo.vacation.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.base.common.TwOutputUtil;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyDtlPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyDtlQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyDtlVO;
import com.elitesland.tw.tw5.base.demo.vacation.service.UserVacationApplyDtlService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户请假申请明细
 */
@RestController
@RequestMapping("/api/userVacationApplyDtl")
@RequiredArgsConstructor
@Api(value = "用户请假申请明细", tags = {"用户请假申请明细"})
public class UserVacationApplyDtlController {

    private final UserVacationApplyDtlService userVacationApplyDtlService;


    @GetMapping("get")
    @ApiOperation("详情-用户请假申请明细")
    public TwOutputUtil<UserVacationApplyDtlVO> get(Long id) {

        UserVacationApplyDtlVO res = userVacationApplyDtlService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-用户请假申请明细")
    public TwOutputUtil<Long> save(@RequestBody UserVacationApplyDtlPayload userVacationApplyDtlPayload) {

        UserVacationApplyDtlVO res = userVacationApplyDtlService.save(userVacationApplyDtlPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-用户请假申请明细")
    public TwOutputUtil<Long> update(@RequestBody UserVacationApplyDtlPayload userVacationApplyDtlPayload) {

        Long res = userVacationApplyDtlService.update(userVacationApplyDtlPayload);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("del")
    @ApiOperation("删除-用户请假申请明细")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {

        Long res = userVacationApplyDtlService.del(ids);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("/page")
//    @UdcNameClass
    @ApiOperation("分页查询-用户请假申请明细")
    public TwOutputUtil<PagingVO<UserVacationApplyDtlVO>> page(@RequestBody UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        PagingVO<UserVacationApplyDtlVO> res = userVacationApplyDtlService.page(userVacationApplyDtlQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("getList")
    @ApiOperation("获取列表-用户请假申请明细")
    public TwOutputUtil<List<UserVacationApplyDtlVO>> getList(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        List<UserVacationApplyDtlVO> res = userVacationApplyDtlService.getList(userVacationApplyDtlQuery);
        return TwOutputUtil.ok(res);

    }


}

