package com.elitesland.tw.tw5.base.demo.vacation.model.entity;

import com.elitesland.tw.tw5.base.common.BaseWorkflowDO;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
* @author : WWW
* @date : 2024-1-18
* @desc : 用户假期申请
*/

@Entity
@Table(name = "user_vacation_apply_demo")
@org.hibernate.annotations.Table(appliesTo = "user_vacation_apply_demo", comment = "用户假期申请")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class UserVacationApplyDO extends BaseWorkflowDO {


   /**
    * 编号
    */
   @Column(name = "doc_no", columnDefinition = "varchar(50) comment '编号'")
   private String docNo;

   /**
    * 用户id
    */
   @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
   private Long userId;

   /**
    * 上级id
    */
   @Column(name = "p_user_id", columnDefinition = "bigint(20) comment '上级id'")
   private Long pUserId;

   /**
    * 组织id
    */
   @Column(name = "base_bu_id", columnDefinition = "bigint(20) comment '组织id'")
   private Long baseBuId;

   /**
    * 假期类型
    */
   @Column(name = "type", columnDefinition = "varchar(50) comment '假期类型'")
   private String type;

   /**
    * 开始时间
    */
   @Column(name = "start_date", columnDefinition = "date comment '开始时间'")
   private LocalDate startDate;

   /**
    * 结束时间
    */
   @Column(name = "end_date", columnDefinition = "date comment '结束时间'")
   private LocalDate endDate;

   /**
    * 申请天数
    */
   @Column(name = "days", columnDefinition = "decimal(20,2) comment '申请天数'")
   private BigDecimal days;

   /**
    * 申请日期
    */
   @Column(name = "apply_time", columnDefinition = "datetime(6) comment '申请日期'")
   private LocalDateTime applyTime;

   /**
    * 文件附件
    */
   @Column(name = "file_code", columnDefinition = "varchar(255) comment '文件附件'")
   private String fileCode;

   /**
    * 是否在项目上
    */
   @Column(name = "in_pro_flag", columnDefinition = "tinyint(1) comment '是否在项目上'")
   private Boolean inProFlag;

   /**
    * 是否自动生成
    */
   @Column(name = "auto_flag", columnDefinition = "tinyint(1) comment '是否自动生成'")
   private Boolean autoFlag;

   /**
    * 申请说明
    */
   @Column(name = "apply_desc", columnDefinition = "varchar(500) comment '申请说明'")
   private String applyDesc;


}

