package com.elitesland.tw.tw5.base.demo.vacation.model.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
* @author : WWW
* @date : 2024-1-18
* @desc : 用户请假申请明细
*/

@Entity
@Table(name = "user_vacation_apply_dtl_demo")
@org.hibernate.annotations.Table(appliesTo = "user_vacation_apply_dtl_demo", comment = "用户请假申请明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class UserVacationApplyDtlDO extends BaseModel {


   /**
    * 申请id
    */
   @Column(name = "apply_id", columnDefinition = "bigint(20) comment '申请id'")
   private Long applyId;

   /**
    * 申假日期
    */
   @Column(name = "vacation_date", columnDefinition = "date comment '申假日期'")
   private LocalDate vacationDate;

   /**
    * 申假小时
    */
   @Column(name = "vacation_hour", columnDefinition = "decimal(20,2) comment '申假小时'")
   private BigDecimal vacationHour;


}

