package com.elitesland.tw.tw5.base.demo.vacation.model.query;

import com.elitesland.tw.tw5.base.common.TwQueryParam;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;


/**
* @author : WWW
* @date : 2024-1-18
* @desc : 用户假期申请
*/

@Data
@ApiModel(description = "用户假期申请")
public class UserVacationApplyQuery extends TwQueryParam {


   /**
    * 编号
    */
   @ApiModelProperty("编号")
   private String docNo;

   /**
    * 用户id
    */
   @ApiModelProperty("用户id")
   private Long userId;

   /**
    * 上级id
    */
   @ApiModelProperty("上级id")
   private Long pUserId;

   /**
    * 组织id
    */
   @ApiModelProperty("组织id")
   private Long baseBuId;

   /**
    * 假期类型
    */
   @ApiModelProperty("假期类型")
   private String type;

   /**
    * 开始时间
    */
   @ApiModelProperty("开始时间")
   @DateTimeFormat(pattern = "yyyy-MM-dd")
   private LocalDate startDate;

   /**
    * 结束时间
    */
   @ApiModelProperty("结束时间")
   @DateTimeFormat(pattern = "yyyy-MM-dd")
   private LocalDate endDate;

   /**
    * 申请天数
    */
   @ApiModelProperty("申请天数")
   private BigDecimal days;

   /**
    * 申请日期
    */
   @ApiModelProperty("申请日期")
   @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
   private LocalDateTime applyTime;

   /**
    * 文件附件
    */
   @ApiModelProperty("文件附件")
   private String fileCode;

   /**
    * 是否在项目上
    */
   @ApiModelProperty("是否在项目上")
   private Boolean inProFlag;

   /**
    * 是否自动生成
    */
   @ApiModelProperty("是否自动生成")
   private Boolean autoFlag;

   /**
    * 申请说明
    */
   @ApiModelProperty("申请说明")
   private String applyDesc;


}

