package com.elitesland.tw.tw5.base.demo.vacation.repo.dao;

import com.elitesland.tw.tw5.base.demo.vacation.model.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户假期申请RepoProc
 */

@Component
public class UserVacationApplyDao extends BaseRepoProc<UserVacationApplyDO> {

    private static final QUserVacationApplyDO qUserVacationApplyDO = QUserVacationApplyDO.userVacationApplyDO;


    protected UserVacationApplyDao() {

        super(qUserVacationApplyDO);

    }


    public PagingVO<UserVacationApplyVO> page(UserVacationApplyQuery userVacationApplyQuery) {

        JPAQuery<UserVacationApplyVO> query =
                select(UserVacationApplyVO.class)
                        .where(bulidPredicate(userVacationApplyQuery));
        userVacationApplyQuery.setPaging(query);
        userVacationApplyQuery.fillOrders(query, qUserVacationApplyDO);
        return PagingVO.<UserVacationApplyVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qUserVacationApplyDO)
                .set(qUserVacationApplyDO.deleteFlag, 1)
                .where(qUserVacationApplyDO.id.in(ids))
                .execute();

        return res;

    }


    public UserVacationApplyVO get(Long id) {

        UserVacationApplyVO userVacationApplyVO = select(UserVacationApplyVO.class)
                .where(qUserVacationApplyDO.id.eq(id))
                .fetchOne();

        return userVacationApplyVO;

    }


    public List<UserVacationApplyVO> getList(UserVacationApplyQuery userVacationApplyQuery) {

        List<UserVacationApplyVO> res =
                select(UserVacationApplyVO.class)
                        .where(bulidPredicate(userVacationApplyQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qUserVacationApplyDO.docNo,
                        qUserVacationApplyDO.userId,
                        qUserVacationApplyDO.pUserId,
                        qUserVacationApplyDO.baseBuId,
                        qUserVacationApplyDO.type,
                        qUserVacationApplyDO.startDate,
                        qUserVacationApplyDO.endDate,
                        qUserVacationApplyDO.days,
                        qUserVacationApplyDO.applyTime,
                        qUserVacationApplyDO.fileCode,
                        qUserVacationApplyDO.inProFlag,
                        qUserVacationApplyDO.autoFlag,
                        qUserVacationApplyDO.applyDesc,
                        qUserVacationApplyDO.id,
                        qUserVacationApplyDO.createTime,
                        qUserVacationApplyDO.remark

                )).from(qUserVacationApplyDO);

    }


    private Predicate bulidPredicate(UserVacationApplyQuery userVacationApplyQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(userVacationApplyQuery.getDocNo()), qUserVacationApplyDO.docNo, userVacationApplyQuery.getDocNo())
                .andEq(null != userVacationApplyQuery.getUserId(), qUserVacationApplyDO.userId, userVacationApplyQuery.getUserId())
                .andEq(null != userVacationApplyQuery.getPUserId(), qUserVacationApplyDO.pUserId, userVacationApplyQuery.getPUserId())
                .andEq(null != userVacationApplyQuery.getBaseBuId(), qUserVacationApplyDO.baseBuId, userVacationApplyQuery.getBaseBuId())
                .andEq(StringUtils.isNotBlank(userVacationApplyQuery.getType()), qUserVacationApplyDO.type, userVacationApplyQuery.getType())
                .andEq(null != userVacationApplyQuery.getStartDate(), qUserVacationApplyDO.startDate, userVacationApplyQuery.getStartDate())
                .andEq(null != userVacationApplyQuery.getEndDate(), qUserVacationApplyDO.endDate, userVacationApplyQuery.getEndDate())
                .andEq(null != userVacationApplyQuery.getDays(), qUserVacationApplyDO.days, userVacationApplyQuery.getDays())
                .andEq(null != userVacationApplyQuery.getApplyTime(), qUserVacationApplyDO.applyTime, userVacationApplyQuery.getApplyTime())
                .andEq(StringUtils.isNotBlank(userVacationApplyQuery.getFileCode()), qUserVacationApplyDO.fileCode, userVacationApplyQuery.getFileCode())
                .andEq(null != userVacationApplyQuery.getInProFlag(), qUserVacationApplyDO.inProFlag, userVacationApplyQuery.getInProFlag())
                .andEq(null != userVacationApplyQuery.getAutoFlag(), qUserVacationApplyDO.autoFlag, userVacationApplyQuery.getAutoFlag())
                .andEq(StringUtils.isNotBlank(userVacationApplyQuery.getApplyDesc()), qUserVacationApplyDO.applyDesc, userVacationApplyQuery.getApplyDesc())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(UserVacationApplyQuery userVacationApplyQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 编号
        if (StringUtils.isNotEmpty(userVacationApplyQuery.getDocNo())) {
            predicates.add(qUserVacationApplyDO.docNo.eq(userVacationApplyQuery.getDocNo()));
        }
        // 用户id
        if (null != userVacationApplyQuery.getUserId()) {
            predicates.add(qUserVacationApplyDO.userId.eq(userVacationApplyQuery.getUserId()));
        }
        // 上级id
        if (null != userVacationApplyQuery.getPUserId()) {
            predicates.add(qUserVacationApplyDO.pUserId.eq(userVacationApplyQuery.getPUserId()));
        }
        // 组织id
        if (null != userVacationApplyQuery.getBaseBuId()) {
            predicates.add(qUserVacationApplyDO.baseBuId.eq(userVacationApplyQuery.getBaseBuId()));
        }
        // 假期类型
        if (StringUtils.isNotEmpty(userVacationApplyQuery.getType())) {
            predicates.add(qUserVacationApplyDO.type.eq(userVacationApplyQuery.getType()));
        }
        // 开始时间
        if (null != userVacationApplyQuery.getStartDate()) {
            predicates.add(qUserVacationApplyDO.startDate.eq(userVacationApplyQuery.getStartDate()));
        }
        // 结束时间
        if (null != userVacationApplyQuery.getEndDate()) {
            predicates.add(qUserVacationApplyDO.endDate.eq(userVacationApplyQuery.getEndDate()));
        }
        // 申请天数
        if (null != userVacationApplyQuery.getDays()) {
            predicates.add(qUserVacationApplyDO.days.eq(userVacationApplyQuery.getDays()));
        }
        // 申请日期
        if (null != userVacationApplyQuery.getApplyTime()) {
            predicates.add(qUserVacationApplyDO.applyTime.eq(userVacationApplyQuery.getApplyTime()));
        }
        // 文件附件
        if (StringUtils.isNotEmpty(userVacationApplyQuery.getFileCode())) {
            predicates.add(qUserVacationApplyDO.fileCode.eq(userVacationApplyQuery.getFileCode()));
        }
        // 是否在项目上
        if (null != userVacationApplyQuery.getInProFlag()) {
            predicates.add(qUserVacationApplyDO.inProFlag.eq(userVacationApplyQuery.getInProFlag()));
        }
        // 是否自动生成
        if (null != userVacationApplyQuery.getAutoFlag()) {
            predicates.add(qUserVacationApplyDO.autoFlag.eq(userVacationApplyQuery.getAutoFlag()));
        }
        // 申请说明
        if (StringUtils.isNotEmpty(userVacationApplyQuery.getApplyDesc())) {
            predicates.add(qUserVacationApplyDO.applyDesc.eq(userVacationApplyQuery.getApplyDesc()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(UserVacationApplyQuery userVacationApplyQuery) {

        long res = select(UserVacationApplyVO.class)
                .where(bulidPredicates(userVacationApplyQuery))
                .fetchCount();

        return res;


    }

    public Long update(UserVacationApplyPayload userVacationApplyPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qUserVacationApplyDO);

        // 编号
        if (StringUtils.isNotEmpty(userVacationApplyPayload.getDocNo())) {
            update.set(qUserVacationApplyDO.docNo, userVacationApplyPayload.getDocNo());
        }
        // 用户id
        if (null != userVacationApplyPayload.getUserId()) {
            update.set(qUserVacationApplyDO.userId, userVacationApplyPayload.getUserId());
        }
        // 上级id
        if (null != userVacationApplyPayload.getPUserId()) {
            update.set(qUserVacationApplyDO.pUserId, userVacationApplyPayload.getPUserId());
        }
        // 组织id
        if (null != userVacationApplyPayload.getBaseBuId()) {
            update.set(qUserVacationApplyDO.baseBuId, userVacationApplyPayload.getBaseBuId());
        }
        // 假期类型
        if (StringUtils.isNotEmpty(userVacationApplyPayload.getType())) {
            update.set(qUserVacationApplyDO.type, userVacationApplyPayload.getType());
        }
        // 开始时间
        if (null != userVacationApplyPayload.getStartDate()) {
            update.set(qUserVacationApplyDO.startDate, userVacationApplyPayload.getStartDate());
        }
        // 结束时间
        if (null != userVacationApplyPayload.getEndDate()) {
            update.set(qUserVacationApplyDO.endDate, userVacationApplyPayload.getEndDate());
        }
        // 申请天数
        if (null != userVacationApplyPayload.getDays()) {
            update.set(qUserVacationApplyDO.days, userVacationApplyPayload.getDays());
        }
        // 申请日期
        if (null != userVacationApplyPayload.getApplyTime()) {
            update.set(qUserVacationApplyDO.applyTime, userVacationApplyPayload.getApplyTime());
        }
        // 文件附件
        if (StringUtils.isNotEmpty(userVacationApplyPayload.getFileCode())) {
            update.set(qUserVacationApplyDO.fileCode, userVacationApplyPayload.getFileCode());
        }
        // 是否在项目上
        if (null != userVacationApplyPayload.getInProFlag()) {
            update.set(qUserVacationApplyDO.inProFlag, userVacationApplyPayload.getInProFlag());
        }
        // 是否自动生成
        if (null != userVacationApplyPayload.getAutoFlag()) {
            update.set(qUserVacationApplyDO.autoFlag, userVacationApplyPayload.getAutoFlag());
        }
        // 申请说明
        if (StringUtils.isNotEmpty(userVacationApplyPayload.getApplyDesc())) {
            update.set(qUserVacationApplyDO.applyDesc, userVacationApplyPayload.getApplyDesc());
        }
        long res = update.where(qUserVacationApplyDO.id.eq(userVacationApplyPayload.getId()))
                .execute();
        return res;

    }

}

