package com.elitesland.tw.tw5.base.demo.vacation.repo.dao;

import com.elitesland.tw.tw5.base.demo.vacation.model.entity.QUserVacationApplyDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.entity.QUserVacationApplyDtlDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.entity.UserVacationApplyDtlDO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyDtlPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyDtlQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyDtlVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.elitescloud.boot.exception.BusinessException;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户请假申请明细RepoProc
 */

@Component
public class UserVacationApplyDtlDao extends BaseRepoProc<UserVacationApplyDtlDO> {

    private static final QUserVacationApplyDtlDO qUserVacationApplyDtlDO = QUserVacationApplyDtlDO.userVacationApplyDtlDO;

    private static final QUserVacationApplyDO qUserVacationApplyDO = QUserVacationApplyDO.userVacationApplyDO;

    protected UserVacationApplyDtlDao() {

        super(qUserVacationApplyDtlDO);

    }


    public PagingVO<UserVacationApplyDtlVO> page(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        JPAQuery<UserVacationApplyDtlVO> query =
                select(UserVacationApplyDtlVO.class)
                        .where(bulidPredicate(userVacationApplyDtlQuery));
        userVacationApplyDtlQuery.setPaging(query);
        userVacationApplyDtlQuery.fillOrders(query, qUserVacationApplyDtlDO);
        return PagingVO.<UserVacationApplyDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qUserVacationApplyDtlDO)
                .set(qUserVacationApplyDtlDO.deleteFlag, 1)
                .where(qUserVacationApplyDtlDO.id.in(ids))
                .execute();

        return res;

    }


    public UserVacationApplyDtlVO get(Long id) {

        UserVacationApplyDtlVO userVacationApplyDtlVO = select(UserVacationApplyDtlVO.class)
                .where(qUserVacationApplyDtlDO.id.eq(id))
                .fetchOne();

        return userVacationApplyDtlVO;

    }


    public List<UserVacationApplyDtlVO> getList(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        List<UserVacationApplyDtlVO> res =
                select(UserVacationApplyDtlVO.class)
                        .where(bulidPredicate(userVacationApplyDtlQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                                qUserVacationApplyDtlDO.applyId,
                                qUserVacationApplyDtlDO.vacationDate,
                                qUserVacationApplyDtlDO.vacationHour,
                                qUserVacationApplyDtlDO.id,
                                qUserVacationApplyDtlDO.createTime,
                                qUserVacationApplyDtlDO.remark,
//                                关联查询
                                qUserVacationApplyDO.userId,
                                qUserVacationApplyDO.applyTime

                        )).from(qUserVacationApplyDtlDO)
                        .leftJoin(qUserVacationApplyDO).on(qUserVacationApplyDtlDO.applyId.eq(qUserVacationApplyDO.id));


    }


    private Predicate bulidPredicate(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != userVacationApplyDtlQuery.getApplyId(), qUserVacationApplyDtlDO.applyId, userVacationApplyDtlQuery.getApplyId())
                .andEq(null != userVacationApplyDtlQuery.getVacationDate(), qUserVacationApplyDtlDO.vacationDate, userVacationApplyDtlQuery.getVacationDate())
                .andEq(null != userVacationApplyDtlQuery.getVacationHour(), qUserVacationApplyDtlDO.vacationHour, userVacationApplyDtlQuery.getVacationHour())
                .build();

        return predicate;

    }


    private Predicate bulidPredicates(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 申请id
        if (null != userVacationApplyDtlQuery.getApplyId()) {
            predicates.add(qUserVacationApplyDtlDO.applyId.eq(userVacationApplyDtlQuery.getApplyId()));
        }
        // 申假日期
        if (null != userVacationApplyDtlQuery.getVacationDate()) {
            predicates.add(qUserVacationApplyDtlDO.vacationDate.eq(userVacationApplyDtlQuery.getVacationDate()));
        }
        // 申假小时
        if (null != userVacationApplyDtlQuery.getVacationHour()) {
            predicates.add(qUserVacationApplyDtlDO.vacationHour.eq(userVacationApplyDtlQuery.getVacationHour()));
        }

        Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicate;
    }


    public Long count(UserVacationApplyDtlQuery userVacationApplyDtlQuery) {

        long res = select(UserVacationApplyDtlVO.class)
                .where(bulidPredicates(userVacationApplyDtlQuery))
                .fetchCount();

        return res;


    }

    public Long update(UserVacationApplyDtlPayload userVacationApplyDtlPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qUserVacationApplyDtlDO);

        // 申请id
        if (null != userVacationApplyDtlPayload.getApplyId()) {
            update.set(qUserVacationApplyDtlDO.applyId, userVacationApplyDtlPayload.getApplyId());
        }
        // 申假日期
        if (null != userVacationApplyDtlPayload.getVacationDate()) {
            update.set(qUserVacationApplyDtlDO.vacationDate, userVacationApplyDtlPayload.getVacationDate());
        }
        // 申假小时
        if (null != userVacationApplyDtlPayload.getVacationHour()) {
            update.set(qUserVacationApplyDtlDO.vacationHour, userVacationApplyDtlPayload.getVacationHour());
        }
        long res = update.where(qUserVacationApplyDtlDO.id.eq(userVacationApplyDtlPayload.getId()))
                .execute();
        return res;

    }

}

