package com.elitesland.tw.tw5.base.demo.vacation.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyDtlPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyDtlQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyDtlVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户请假申请明细Service
 */

public interface UserVacationApplyDtlService {

    /**
     * 新增用户请假申请明细数据
     *
     * @param userVacationApplyDtlPayload
     * @return
     */
    UserVacationApplyDtlVO save(UserVacationApplyDtlPayload userVacationApplyDtlPayload);

    /**
     * 根据主键更新
     *
     * @param userVacationApplyDtlPayload
     * @return
     */
    UserVacationApplyDtlVO updateAll(UserVacationApplyDtlPayload userVacationApplyDtlPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    UserVacationApplyDtlVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param userVacationApplyDtlQuery
     * @return
     */
    PagingVO<UserVacationApplyDtlVO> page(UserVacationApplyDtlQuery userVacationApplyDtlQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param userVacationApplyDtlQuery
     * @return
     */
    List<UserVacationApplyDtlVO> getList(UserVacationApplyDtlQuery userVacationApplyDtlQuery);

    /**
     * 根据条件修改
     *
     * @param userVacationApplyDtlPayload
     * @return
     */
    Long update(UserVacationApplyDtlPayload userVacationApplyDtlPayload);

}

