package com.elitesland.tw.tw5.base.demo.vacation.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.base.demo.vacation.model.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.base.demo.vacation.model.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.base.demo.vacation.model.vo.UserVacationApplyVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2024-1-18
 * @desc : 用户假期申请Service
 */

public interface UserVacationApplyService {

    /**
     * 新增用户假期申请数据
     *
     * @param userVacationApplyPayload
     * @return
     */
    UserVacationApplyVO save(UserVacationApplyPayload userVacationApplyPayload);

    /**
     * 根据主键更新
     *
     * @param userVacationApplyPayload
     * @return
     */
    UserVacationApplyVO updateAll(UserVacationApplyPayload userVacationApplyPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    UserVacationApplyVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param userVacationApplyQuery
     * @return
     */
    PagingVO<UserVacationApplyVO> page(UserVacationApplyQuery userVacationApplyQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param userVacationApplyQuery
     * @return
     */
    List<UserVacationApplyVO> getList(UserVacationApplyQuery userVacationApplyQuery);

    /**
     * 根据条件修改
     *
     * @param userVacationApplyPayload
     * @return
     */
    Long update(UserVacationApplyPayload userVacationApplyPayload);

}

